/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.apduio.CadEvent;
import com.sun.javacard.apduio.CadServerListener;
import com.sun.javacard.apduio.ServerT0Protocol;
import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.jcwde.Globals;
import com.sun.javacard.jcwde.SimulationException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class SimAPDU
implements CadServerListener {
    private static final short BUFFER_OVERFLOW = -16383;
    private static final short READ_ERROR = -16381;
    private static final short WRITE_ERROR = -16380;
    private static final short INVALID_GET_RESPONSE = -16378;
    private static final byte ACK_NONE = 0;
    private static final byte ACK_INS = 1;
    private static final byte ACK_NOT_INS = 2;
    private static final byte GET_RESPONSE_CLA = 0;
    private static final byte GET_RESPONSE_INS = -64;
    private static final byte GET_RESPONSE_P1 = 0;
    private static final byte GET_RESPONSE_P2 = 0;
    private static boolean invalidGetResponse;
    public static int port;
    public static ServerSocket srvSock;
    protected static ServerT0Protocol _protocol;
    protected static SimAPDU _simApdu;
    private static final int APDU_BUFFER_LENGTH = 37;
    private static byte[] apduBuffer;
    private static short apduStatus;
    private static byte[] command;

    static ServerT0Protocol protocol() {
        if (_protocol == null) {
            try {
                byte[] byArray = new byte[6];
                byArray[0] = 59;
                byArray[1] = -16;
                byArray[2] = 17;
                byArray[4] = -1;
                byte[] byArray2 = byArray;
                Socket socket = srvSock.accept();
                socket.setTcpNoDelay(true);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
                _protocol = new ServerT0Protocol(bufferedInputStream, bufferedOutputStream);
                _simApdu = new SimAPDU();
                _protocol.addCadServerListener(_simApdu);
                _protocol.sendATR(byArray2);
            }
            catch (TLP224Exception tLP224Exception) {
                System.err.println(tLP224Exception);
                throw new SimulationException();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                throw new SimulationException();
            }
        }
        return _protocol;
    }

    public void powerUp(CadEvent cadEvent) {
    }

    public void powerDown(CadEvent cadEvent) {
        System.out.println(Globals._messages.getString("PowerDown"));
        System.exit(0);
    }

    public static short t0RcvCommand() {
        if (SimAPDU.protocol().t0RcvCommand(apduBuffer) != 0) {
            return -16381;
        }
        System.arraycopy(apduBuffer, 0, command, 0, 5);
        return 0;
    }

    public static short t0SndStatusRcvCommand() {
        if (invalidGetResponse) {
            invalidGetResponse = false;
            System.arraycopy(command, 0, apduBuffer, 0, 5);
        } else {
            if (SimAPDU.protocol().t0SndStatusRcvCommand(apduBuffer, apduStatus) != 0) {
                return -16381;
            }
            System.arraycopy(apduBuffer, 0, command, 0, 5);
        }
        return 0;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static short t0RcvData(short s) {
        short s2;
        byte by;
        block5: {
            short s3;
            short s4;
            block4: {
                block3: {
                    by = 0;
                    s2 = (short)(command[4] & 0xFF);
                    s4 = (short)(apduBuffer.length - s);
                    if (s2 <= s4) break block3;
                    s2 = s4;
                    if (!true) break block4;
                    s3 = s4;
                    s4 = (short)(s3 - 1);
                    if (s3 == 0 || by != 0) break block5;
                }
                by = SimAPDU.protocol().t0RcvData(apduBuffer, s, s2, command[1]);
                break block5;
            }
            do {
                short s5 = s;
                s = (short)(s5 + 1);
                by = SimAPDU.protocol().t0RcvData(apduBuffer, s5, (short)1, ~command[1]);
                s3 = s4;
                s4 = (short)(s3 - 1);
            } while (s3 != 0 && by == 0);
        }
        SimAPDU.command[4] = (byte)(command[4] - s2);
        if (by == 0) {
            return s2;
        }
        return -16381;
    }

    public static short t0SndData(byte[] byArray, short s, short s2, byte by) {
        switch (by) {
            case 0: {
                if (SimAPDU.protocol().t0SndData(byArray, s, s2) == 0) break;
                return -16380;
            }
            case 1: {
                if (SimAPDU.protocol().t0SndData(byArray, s, s2, command[1]) == 0) break;
                return -16380;
            }
            case 2: {
                if (SimAPDU.protocol().t0SndData(byArray, s, s2, ~command[1]) == 0) break;
                return -16380;
            }
            default: {
                return -16380;
            }
        }
        return 0;
    }

    public static short t0SndGetResponse() {
        if (SimAPDU.protocol().t0SndStatusRcvCommand(command, apduStatus) != 0) {
            return -16381;
        }
        if (command[0] != 0 || command[1] != -64 || command[2] != 0 || command[3] != 0) {
            invalidGetResponse = true;
            return -16378;
        }
        return (short)(command[4] & 0xFF);
    }

    public static short t0Wait() {
        if (SimAPDU.protocol().t0SndData(apduBuffer, (short)0, (short)0, (byte)96) != 0) {
            return -16380;
        }
        return 0;
    }

    public static byte[] t0InitAPDUBuffer() {
        try {
            srvSock = new ServerSocket(port);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.err.println(String.valueOf(Globals._messages.getString("BadSocket")) + port);
            throw new SimulationException();
        }
        return apduBuffer;
    }

    public static short t0SetStatus(short s) {
        apduStatus = s;
        return 0;
    }

    static {
        srvSock = null;
        apduBuffer = new byte[37];
        command = new byte[5];
    }
}

