/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.apduio.TLP224Message;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Cad {
    protected InputStream in;
    protected OutputStream out;
    private boolean debug = false;

    public Cad(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
        int n = Integer.getInteger("apduIODebug", 0);
        if ((n & 1) == 1) {
            this.debug = true;
        }
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.out.flush();
        this.out.close();
        this.out = null;
    }

    public synchronized void receiveTLP224Message(TLP224Message tLP224Message) throws IOException, TLP224Exception {
        int n = 0;
        while (true) {
            int n2;
            if (n++ > 5) {
                throw new TLP224Exception(1);
            }
            boolean bl = false;
            boolean bl2 = false;
            byte[] byArray = tLP224Message.getData();
            int n3 = 0;
            while ((n2 = this.in.read()) != 3) {
                int n4;
                if (n2 == -1) {
                    throw new EOFException();
                }
                if ((n2 -= 48) > 9) {
                    n2 -= 7;
                }
                if (n2 < 0 || n2 > 15) {
                    bl2 = true;
                }
                if ((n4 = this.in.read()) == 3) {
                    bl2 = true;
                    break;
                }
                if (n4 == -1) {
                    throw new EOFException();
                }
                if ((n4 -= 48) > 9) {
                    n4 -= 7;
                }
                if (n4 < 0 || n4 > 15) {
                    bl2 = true;
                }
                if (bl || bl2) continue;
                try {
                    byArray[n3++] = (byte)(n2 << 4 | n4);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    bl = true;
                }
            }
            if (bl2) {
                if (this.debug) {
                    System.out.println("<-- message received with transmission error");
                    System.out.flush();
                }
                this.transmissionError();
                continue;
            }
            if (bl) {
                if (this.debug) {
                    System.out.println("<-- received message too long");
                    System.out.flush();
                }
                this.statusResponse(18);
                continue;
            }
            tLP224Message.setLength(n3);
            if (this.debug) {
                System.out.println("<-- " + tLP224Message);
                System.out.flush();
            }
            if (byArray[n3 - 1] != (byte)tLP224Message.computeLRC(n3 - 1)) {
                this.transmissionError();
                continue;
            }
            if (byArray[1] != (byte)(n3 - 3)) {
                this.transmissionError();
                continue;
            }
            if (byArray[0] == 96 || byArray[0] == -32) break;
            this.statusResponse(9);
        }
    }

    public void sendTLP224Message(TLP224Message tLP224Message) throws IOException {
        if (this.debug) {
            System.out.println("--> " + tLP224Message);
            System.out.flush();
        }
        byte[] byArray = tLP224Message.getData();
        int n = 0;
        while (n < tLP224Message.getLength()) {
            int n2 = byArray[n] >> 4 & 0xF;
            n2 = n2 < 10 ? (n2 += 48) : (n2 += 55);
            this.out.write(n2);
            n2 = byArray[n] & 0xF;
            n2 = n2 < 10 ? (n2 += 48) : (n2 += 55);
            this.out.write(n2);
            ++n;
        }
        this.out.write(3);
        this.out.flush();
    }

    void statusResponse(int n) throws IOException {
        TLP224Message tLP224Message = new TLP224Message(new byte[4]);
        byte[] byArray = tLP224Message.getData();
        byArray[0] = 96;
        byArray[1] = 1;
        byArray[2] = (byte)n;
        byArray[3] = (byte)tLP224Message.computeLRC(3);
        tLP224Message.setLength(4);
        this.sendTLP224Message(tLP224Message);
    }

    private void transmissionError() throws IOException {
        TLP224Message tLP224Message = new TLP224Message(new byte[3]);
        byte[] byArray = tLP224Message.getData();
        byArray[0] = -32;
        byArray[1] = 0;
        byArray[2] = (byte)tLP224Message.computeLRC(2);
        tLP224Message.setLength(3);
        this.sendTLP224Message(tLP224Message);
    }
}

