/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.me.utils;

import com.sun.tck.me.utils.Converter;
import com.sun.tck.me.utils.Converters;
import com.sun.tck.me.utils.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class CommandLineAdapter {
    private String optionPrefix = "-";
    private Object[] commands;
    private HashMap<String, MethodDescriptor> methods = new HashMap();
    private MethodDescriptor setArguments;
    private boolean hasCommand;
    private static final Map<String, Converter> converters = Converters.createConverters();
    private String[] prefixes = new String[0];

    public CommandLineAdapter(Object ... commands) {
        this(false, commands);
    }

    public CommandLineAdapter(boolean hasCommand, Object ... commands) {
        this.hasCommand = hasCommand;
        this.commands = commands;
        for (Object command : commands) {
            for (Method meth : command.getClass().getMethods()) {
                Class<?>[] params = meth.getParameterTypes();
                if (params.length != 1) continue;
                this.registerMethod(command, meth);
            }
        }
    }

    public void setOptionPrefix(String prefix) {
        this.optionPrefix = prefix;
    }

    public void setPrefixes(String ... list) {
        this.prefixes = list;
    }

    private void registerMethod(Object command, Method meth) {
        String key = meth.getName().toLowerCase();
        Class<?>[] params = meth.getParameterTypes();
        if (key.equals("setarguments") && params[0].equals(String[].class)) {
            this.setArguments = new MethodDescriptor(command, meth, Converters.TO_ARRAY);
        } else if (key.startsWith("set") && params.length == 1 && converters.get(params[0].getName()) != null) {
            if (this.methods.containsKey(key)) {
                throw new IllegalArgumentException("More than one method for the same attribute:" + key);
            }
            Converter converter = converters.get(params[0].getName());
            this.methods.put(key, new MethodDescriptor(command, meth, converter));
        }
    }

    private void printHelp() {
        System.out.print("java " + this.commands[this.commands.length - 1].getClass().getName() + " [options]");
        if (this.setArguments == null) {
            System.out.println();
        } else {
            System.out.println(" ... ");
        }
        System.out.println("  Where options are:");
        for (String key : this.methods.keySet()) {
            System.out.println("    -" + this.methods.get(key).getMethod().getName().substring(3));
        }
    }

    private boolean isSingle(String arg) {
        for (String prefix : this.prefixes) {
            if (!arg.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public synchronized void init(String ... args) {
        if (args == null) {
            return;
        }
        try {
            int start;
            boolean isParamsEnded = false;
            for (int i = start = this.hasCommand && args.length > 0 && args[0].charAt(0) != '-' ? 1 : 0; i < args.length; ++i) {
                if (isParamsEnded || this.isSingle(args[i])) {
                    this.addDefaultArgument(args[i]);
                    continue;
                }
                if (args[i].equals("-h") || args[i].equals("-help") || args[i].equals("-?") || args[i].equals("--help")) {
                    this.printHelp();
                    System.exit(0);
                    continue;
                }
                if (args[i].equals(this.optionPrefix + this.optionPrefix)) {
                    isParamsEnded = true;
                    continue;
                }
                if (isParamsEnded || !args[i].startsWith(this.optionPrefix)) {
                    this.addDefaultArgument(args[i]);
                    continue;
                }
                this.setValue(args[i], args[i + 1]);
                ++i;
            }
            this.invokeSetters();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not set value", e);
        }
        finally {
            this.clearMethodDescriptors();
        }
    }

    private void addDefaultArgument(String value) {
        if (this.setArguments == null) {
            throw new IllegalArgumentException("The default argument list is not supported");
        }
        this.setArguments.addValue(value);
    }

    private void setValue(String name, String value) {
        String methName = ("set" + name.substring(1)).toLowerCase();
        MethodDescriptor meth = this.methods.get(methName);
        if (meth == null) {
            throw new IllegalArgumentException("Unknown parameter:" + name);
        }
        meth.addValue(value);
    }

    private void invokeSetters() throws Exception {
        for (String methName : this.methods.keySet()) {
            MethodDescriptor meth = this.methods.get(methName);
            meth.invoke();
        }
        if (this.setArguments != null) {
            this.setArguments.invoke();
        }
    }

    private void clearMethodDescriptors() {
        for (String methName : this.methods.keySet()) {
            MethodDescriptor meth = this.methods.get(methName);
            meth.clear();
        }
        if (this.setArguments != null) {
            this.setArguments.clear();
        }
    }

    public static interface CommandBundle {
        public void setCommand(String var1);

        public Object[] getObjects();

        public void init();
    }
}

