/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.me.tools.fs;

import com.sun.tck.me.tools.fs.FileSystem;
import com.sun.tck.me.utils.Closables;
import com.sun.tck.me.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipFileSystem
implements FileSystem {
    private File source;
    private File destination;
    private LinkedHashMap<String, ByteArrayOutputStream> written = new LinkedHashMap();
    private LinkedHashMap<String, ZipEntry> read = new LinkedHashMap();
    private Closables manager = new Closables();
    private ZipFile zip;
    private boolean verbose = false;
    private String pwd = "/";

    public ZipFileSystem(File source, File desctination) throws IOException {
        this.source = source;
        this.destination = desctination;
        if (source != null) {
            this.zip = new ZipFile(source);
            Enumeration<? extends ZipEntry> e = this.zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                this.read.put(entry.getName(), entry);
            }
        }
    }

    private static boolean isIn(String path, String[] prefixes) {
        if (prefixes == null || prefixes.length == 0) {
            return true;
        }
        for (String current : prefixes) {
            if (!path.startsWith(current)) continue;
            return true;
        }
        return false;
    }

    public static void unzip(File zipFile, FileSystem fs, String ... prefixes) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String path = entry.getName();
            if (!ZipFileSystem.isIn(path, prefixes)) continue;
            OutputStream out = fs.openToWrite(path);
            Utils.copyData(zip.getInputStream(entry), out);
            out.close();
        }
        zip.close();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public InputStream openToRead(String path) throws IOException {
        if (this.written.containsKey(path = this.getAbsPath(path))) {
            return new ByteArrayInputStream(this.written.get(path).toByteArray());
        }
        if (this.read.containsKey(path)) {
            return this.manager.add(this.zip.getInputStream(this.read.get(path)));
        }
        throw new FileNotFoundException("No resource for: " + path);
    }

    @Override
    public OutputStream openToWrite(String path) throws IOException {
        path = this.getAbsPath(path);
        ByteArrayOutputStream retVal = new ByteArrayOutputStream();
        this.read.remove(path);
        this.written.put(path, retVal);
        return retVal;
    }

    private String getAbsPath(String path) {
        path = path.startsWith("/") ? path : this.pwd + path;
        return path.substring(1);
    }

    @Override
    public FileSystem.FileType getType(String path) {
        if (this.written.containsKey(path)) {
            return FileSystem.FileType.FILE;
        }
        ZipEntry e = this.read.get(path);
        if (e == null) {
            return FileSystem.FileType.DOES_NOT_EXIST;
        }
        return e.isDirectory() ? FileSystem.FileType.DIR : FileSystem.FileType.FILE;
    }

    @Override
    public String[] list(String path, FileSystem.Filter filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void log(String msg) {
        if (this.verbose) {
            System.out.println(msg);
        }
    }

    public List<String> listAllFiles() {
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.addAll(this.read.keySet());
        retVal.addAll(this.written.keySet());
        return retVal;
    }

    @Override
    public void close() throws IOException {
        Closables cls = new Closables();
        this.manager.close();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.destination));
        try {
            for (String path : this.read.keySet()) {
                byte[] data;
                if (this.written.containsKey(path)) {
                    data = this.written.get(path).toByteArray();
                    this.log("  -  Changed: " + path);
                    this.written.remove(path);
                } else {
                    data = Utils.readBytesFromStream(this.zip.getInputStream(this.read.get(path)));
                }
                this.addZipEntry(out, path, data);
            }
            for (String path : this.written.keySet()) {
                this.addZipEntry(out, path, this.written.get(path).toByteArray());
                this.log("  -  Added: " + path);
            }
            out.finish();
            out.close();
        }
        catch (Exception e) {
            throw new IOException("Can not update zip file:" + this.destination.getAbsolutePath());
        }
        finally {
            cls.close();
        }
    }

    private void addZipEntry(ZipOutputStream out, String path, byte[] data) throws IOException {
        ZipEntry entry = new ZipEntry(path);
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        entry.setSize(data.length);
        entry.setCrc(crc.getValue());
        out.putNextEntry(entry);
        out.write(data);
        out.closeEntry();
    }

    public Iterable<String> namesFromSource() {
        return this.read.keySet();
    }

    @Override
    public void switchTo(String path) {
        this.pwd = path.endsWith("/") ? path : path + "/";
    }
}

