/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.javatest.gui;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardServicesPool;
import com.sun.tck.bvtool.terminal.CardInsertionObserver;
import com.sun.tck.bvtool.terminal.CardRemovalObserver;
import com.sun.tck.bvtool.terminal.CardStore;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import com.sun.tck.jc.javatest.gui.ExceptionDialog;
import com.sun.tck.jc.javatest.gui.InsertCardDialog;
import com.sun.tck.jc.javatest.gui.KeysInputDialog;
import com.sun.tck.jc.javatest.gui.RemoveCardDialog;
import com.sun.tck.jc.javatest.ui.UserInteraction;
import java.awt.EventQueue;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JFrame;

public class GuiUserInteraction
implements UserInteraction {
    private static GuiUserInteraction instance = new GuiUserInteraction();

    private GuiUserInteraction() {
    }

    public static GuiUserInteraction getUserInteraction() {
        return instance;
    }

    @Override
    public StatefulCardTerminal askForCardInsertion(String terminalLabel, boolean replacement) {
        StatefulCardTerminal retValue = null;
        final InsertCardDialog dialog = new InsertCardDialog((Frame)new JFrame(), true);
        dialog.setTerminalName(terminalLabel);
        dialog.setReplacement(replacement);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog.setVisible(true);
            }
        });
        CardInsertionObserver observer = new CardInsertionObserver();
        for (StatefulCardTerminal terminal : CardServicesPool.getAvailableTerminals()) {
            terminal.addCardPresenceObserver(observer);
        }
        while (!observer.isInserted() && !dialog.isIdentificationCancelled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {}
        }
        dialog.setVisible(false);
        dialog.dispose();
        for (StatefulCardTerminal terminal : CardServicesPool.getAvailableTerminals()) {
            terminal.removeCardPresenceObserver(observer);
        }
        if (dialog.isIdentificationCancelled()) {
            return null;
        }
        retValue = observer.getSourceTerminal();
        return retValue;
    }

    @Override
    public boolean askForCardReplacement(StatefulCardTerminal terminal) {
        StatefulCardTerminal insertionTerminal;
        if (terminal.checkCardPresent()) {
            final RemoveCardDialog removalDialog = new RemoveCardDialog((Frame)new JFrame(), true);
            removalDialog.setMessage(I18n.getString("remove.card.message", terminal.getLabel()));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    removalDialog.setVisible(true);
                }
            });
            CardRemovalObserver removalObserver = new CardRemovalObserver();
            terminal.addCardPresenceObserver(removalObserver);
            while (!removalObserver.isRemoved()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
            }
            removalDialog.setVisible(false);
            removalDialog.dispose();
            terminal.removeCardPresenceObserver(removalObserver);
        }
        return (insertionTerminal = this.askForCardInsertion(terminal.getLabel(), true)) != null;
    }

    @Override
    public String showCardIDSelectDialog(String terminalLabel) {
        Set<String> idList = CardStore.getDefaultStore().getCardIDs();
        KeysInputDialog dialog = new KeysInputDialog((Frame)new JFrame(), true, idList);
        dialog.setTerminalName(terminalLabel);
        dialog.setVisible(true);
        String selectedCardID = dialog.getCardID();
        dialog.dispose();
        return selectedCardID;
    }

    @Override
    public boolean askForRetryAfterFailedConnection(String terminalLabel) {
        return ExceptionDialog.showMessage(terminalLabel, I18n.getString("connect.failed"));
    }

    @Override
    public boolean askForCardsRemoval() {
        ArrayList<CardRemovalObserver> observers = new ArrayList<CardRemovalObserver>();
        for (StatefulCardTerminal terminal : CardServicesPool.getAvailableTerminals()) {
            if (!terminal.checkCardPresent()) continue;
            CardRemovalObserver observer = new CardRemovalObserver();
            terminal.addCardPresenceObserver(observer);
            observers.add(observer);
        }
        final RemoveCardDialog removalDialog = new RemoveCardDialog((Frame)new JFrame(), true);
        removalDialog.setMessage(I18n.getString("remove.all.cards.message"));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                removalDialog.setVisible(true);
            }
        });
        while (true) {
            boolean allRemoved = true;
            for (CardRemovalObserver observer : observers) {
                allRemoved &= observer.isRemoved();
            }
            if (allRemoved) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {}
        }
        removalDialog.setVisible(false);
        removalDialog.dispose();
        return true;
    }
}

