/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.interview.lib;

import com.sun.interview.FileFilter;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.tck.jc.interview.lib.CompositeInterview;
import com.sun.tck.jc.interview.lib.FileListQuestion;
import com.sun.tck.jc.interview.lib.InterviewEntry;
import com.sun.tck.jc.interview.lib.Validator;
import com.sun.tck.jc.interview.lib.ValueSetListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public class PathQuestion
extends FileListQuestion {
    private String root_dir_name;
    private String root_dir_value;
    private CompositeInterview interview;
    public static final FileFilter[] allFilters = new FileFilter[]{new FileFilter(){

        public boolean accept(File f) {
            String name = f.getName().toLowerCase();
            return name.endsWith(".jar") || name.endsWith(".zip");
        }

        public boolean acceptsDirectories() {
            return false;
        }

        public String getDescription() {
            return "jar and zip files";
        }
    }, new FileFilter(){

        public boolean accept(File f) {
            return true;
        }

        public boolean acceptsDirectories() {
            return true;
        }

        public String getDescription() {
            return "All";
        }
    }};

    public PathQuestion(Interview parent, String tag, FileFilter[] filter, Validator validator, Map map, String root_dir_name) {
        super(parent, tag, validator, map);
        this.setFilters(filter);
        if (root_dir_name != null) {
            this.root_dir_name = root_dir_name;
            this.interview = (CompositeInterview)parent;
            Question root = this.interview.getQuestion(root_dir_name);
            this.root_dir_value = root.getStringValue();
            File baseDir = PathQuestion.getExistingFile(this.root_dir_value);
            if (baseDir != null) {
                this.setBaseDirectory(baseDir);
            }
            ((InterviewEntry)root).addListener(new ValueSetListener(){

                @Override
                public void valueSet(String newValue) {
                    PathQuestion.this.update(newValue);
                }
            });
        }
    }

    private static File getExistingFile(String value) {
        File retVal = null;
        return value != null && (retVal = new File(value)).exists() ? retVal : null;
    }

    public PathQuestion(Interview parent, String tag, FileFilter[] filter, Validator validator, Map map) {
        this(parent, tag, filter, validator, map, null);
    }

    public PathQuestion(Interview parent, String tag, FileFilter[] filter, Validator validator) {
        this(parent, tag, filter, validator, null, null);
    }

    public void update(String new_value) {
        if (this.root_dir_name != null && !PathQuestion.isEmpty(new_value)) {
            String value = this.getStringValue();
            this.root_dir_value = new_value;
            this.setValue(value);
        } else {
            this.root_dir_value = new_value;
        }
        File baseDir = PathQuestion.getExistingFile(new_value);
        if (baseDir != null) {
            this.setBaseDirectory(baseDir);
        }
    }

    public String getStringValue() {
        File[] list = this.getValue();
        File root = this.root_dir_value == null ? null : new File(this.root_dir_value);
        String strValue = "";
        if (list != null && list.length > 0) {
            StringBuffer data = new StringBuffer(this.convertToPath(list[0].getPath()));
            for (int i = 1; i < list.length; ++i) {
                data.append("$:");
                data.append(this.convertToPath(list[i].isAbsolute() && root != null ? list[i].getPath() : new File(root, list[i].getPath()).getPath()));
            }
            strValue = data.toString();
        }
        return strValue;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    public String convertFromPath(String path) {
        String prefix = "$" + this.root_dir_name;
        return path.startsWith(prefix) && !PathQuestion.isEmpty(this.root_dir_value) ? this.root_dir_value + PathQuestion.addSeparator(path.substring(prefix.length())) : path;
    }

    public String convertToPath(String path) {
        return !PathQuestion.isEmpty(this.root_dir_value) && path.startsWith(this.root_dir_value) ? "$" + this.root_dir_name + PathQuestion.addSeparator(path.substring(this.root_dir_value.length())) : path;
    }

    public static String addSeparator(String path) {
        return path.startsWith("$/") || path.startsWith(File.separator) ? path : File.separator + path;
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            super.setValue(value);
            return;
        }
        ArrayList list = PathQuestion.splitPath(value);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, new File(this.convertFromPath((String)list.get(i))));
        }
        this.setValue(list.toArray(new File[list.size()]));
    }

    public static ArrayList splitPath(String paths) {
        String delim = "$:";
        ArrayList list = new ArrayList();
        int offset = 0;
        int pos = 0;
        int step = delim.length();
        while ((pos = paths.indexOf(delim, offset)) >= 0) {
            PathQuestion.addIfNonNull(list, paths.substring(offset, pos));
            offset = pos + step;
        }
        PathQuestion.addIfNonNull(list, paths.substring(offset));
        return list;
    }

    private static void addIfNonNull(ArrayList list, String value) {
        if (value != null && !value.equals("")) {
            list.add(value);
        }
    }
}

