/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.interview.lib;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.tck.jc.interview.lib.InterviewEntry;
import com.sun.tck.jc.interview.lib.InterviewPathResolver;
import com.sun.tck.jc.interview.lib.Validator;
import com.sun.tck.jc.interview.lib.ValueSetListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FileListQuestion
extends com.sun.interview.FileListQuestion
implements InterviewEntry {
    private InterviewPathResolver resolver;
    private Validator validator;
    private Map map;
    private Object defaultValue;
    private ArrayList listeners = new ArrayList();
    protected String key;

    public FileListQuestion(Interview interview, String tag, Validator validator, Map map) {
        super(interview, tag);
        this.setValidator(validator);
        this.map = map == null ? new HashMap() : map;
        this.defaultValue = map.get(this.tag);
        this.clear();
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public void export(Map map) {
        if (this.key != null) {
            map.put(this.key, this.getStringValue());
        }
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public void setValue(String value) {
        if (this.validator.accept(this.tag, value, this.map)) {
            this.map.put(this.tag, value);
            Iterator e = this.listeners.iterator();
            while (e.hasNext()) {
                ((ValueSetListener)e.next()).valueSet(value);
            }
        }
        super.setValue(value);
    }

    public void setValue(File[] value) {
        String strValue = FileListQuestion.join((File[])value);
        if (this.validator.accept(this.tag, value, this.map)) {
            this.map.put(this.tag, strValue);
            Iterator e = this.listeners.iterator();
            while (e.hasNext()) {
                ((ValueSetListener)e.next()).valueSet(strValue);
            }
        }
        super.setValue(value);
    }

    public void clear() {
        if (this.map == null) {
            return;
        }
        if (this.defaultValue == null) {
            this.setValue((String)null);
        } else if (this.defaultValue instanceof File[]) {
            this.setValue((File[])this.defaultValue);
        } else if (this.defaultValue instanceof String[]) {
            this.setValue(this.createFileList((String[])this.defaultValue));
        } else if (this.defaultValue instanceof String) {
            this.setValue((String)this.defaultValue);
        } else {
            this.setValue((String)null);
        }
    }

    public File[] createFileList(String[] list) {
        ArrayList<File> retVal = new ArrayList<File>();
        for (int i = 0; i < list.length; ++i) {
            File current = new File(list[i]);
            if (!current.exists()) continue;
            retVal.add(current);
        }
        return retVal.toArray(new File[retVal.size()]);
    }

    @Override
    public void setResolver(InterviewPathResolver resolver) {
        this.resolver = resolver == null ? InterviewPathResolver.Null : resolver;
    }

    @Override
    public void setValidator(Validator validator) {
        this.validator = validator == null ? Validator.TrueValidator : validator;
    }

    public Question getNext() {
        return this.validator.accept(this.tag, this.getAbsoluteValue(), this.map) ? this.resolver.getNext(this.tag) : this.validator.getErrorQuestion(this.tag, this.getValue(), this.map);
    }

    public File[] getAbsoluteValue() {
        File[] list = this.getValue();
        File root = this.getBaseDirectory();
        if (root != null && list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isAbsolute()) continue;
                list[i] = new File(root, list[i].getPath());
            }
        }
        return list;
    }

    @Override
    public void addListener(ValueSetListener listener) {
        this.listeners.add(listener);
    }
}

