/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.internal;

import com.sun.tck.jc.internal.Source;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class MultiPartSource
implements Source {
    ArrayList names = new ArrayList();
    HashMap sections = new HashMap();
    Source last;
    Stack stack = new Stack();

    public MultiPartSource(String[] names) {
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.addPart(names[i++], new SequenceSection());
            }
        }
    }

    public void addPart(String name, Source section) {
        name = name.intern();
        this.names.add(name);
        this.sections.put(name, section);
    }

    public void write(PrintWriter out) throws IOException {
        Iterator e = this.names.iterator();
        while (e.hasNext()) {
            out.print(this.sections.get(e.next()).toString());
        }
    }

    public void print(String name, Object o) {
        ((Source)this.sections.get(name)).print(o);
    }

    @Override
    public void print(Object o) {
        this.last.print(o);
    }

    public void set(String name) throws IllegalArgumentException {
        Source s = (Source)this.sections.get(name);
        if (s == null) {
            throw new IllegalArgumentException("The section with name '" + name + "' doesnot exist.");
        }
        this.stack.push(this.last);
        this.last = s;
    }

    public void restore() {
        this.last = (Source)this.stack.pop();
    }

    public static class SequenceSection
    implements Source {
        StringBuffer buff = new StringBuffer();

        @Override
        public void print(Object o) {
            this.buff.append(o);
        }

        public String toString() {
            return this.buff.toString();
        }
    }
}

