/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.internal;

import com.sun.tck.jc.internal.BandI;
import com.sun.tgxml.tjtf.api.attributes.TestGroupAttributes;
import com.sun.tgxml.tjtf.api.code.CodeSet;
import com.sun.tgxml.tjtf.api.exceptions.TestFileException;
import com.sun.tgxml.tjtf.api.tests.TestCase;
import com.sun.tgxml.tjtf.api.tests.TestGroup;
import com.sun.tgxml.tjtf.api.tests.TestItem;
import com.sun.tgxml.tjtf.tools.BuildProperties;
import com.sun.tgxml.tools.testgen.api.TestDescriptionIR;
import com.sun.tgxml.tools.testgen.processors.emitter.ExternalEmitter;
import com.sun.tgxml.util.IR;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class JCExternalEmitter
extends ExternalEmitter {
    public static final String COPYRIGHT_SHORT_NAME = BuildProperties.getString((String)"copyright.name.short");
    public static final String TESTGEN_COPYRIGHT_LINK_PROP = "copyrightLink";
    protected String output_Dir;
    protected String group_name;
    protected String[] copyright_lines;
    protected Properties props;

    protected String createOutputDir(TestGroup tg) throws TestFileException {
        String output_Dir = IR.getAttrElem((String)"OutputDir", (TestItem)tg);
        File f = null;
        if (output_Dir == null || !(f = new File(output_Dir)).isDirectory() && !f.mkdirs()) {
            throw new TestFileException("Can not create " + output_Dir);
        }
        return output_Dir;
    }

    protected ArrayList getTestSources(CodeSet tgAttr) throws TestFileException {
        if (tgAttr == null) {
            return new ArrayList();
        }
        ArrayList retVal = BandI.getExternalSourcesNameList(tgAttr, new BandI.SingleFilter(){

            @Override
            public boolean accept(Object o) {
                return !"java".equals(o) && !"example".equals(o);
            }
        });
        return retVal;
    }

    protected ArrayList getClientTestSources(CodeSet tgAttr) throws TestFileException {
        if (tgAttr == null) {
            return new ArrayList();
        }
        ArrayList retVal = BandI.getExternalSourcesNameList(tgAttr, new BandI.SingleFilter(){

            @Override
            public boolean accept(Object o) {
                return "java".equals(o);
            }
        });
        return retVal;
    }

    public static void addIfNotNull(ArrayList data, Object value) {
        if (value != null) {
            if (value instanceof String[]) {
                String[] s = (String[])value;
                int i = 0;
                while (i < s.length) {
                    data.add(s[i++]);
                }
            } else {
                data.add(value);
            }
        }
    }

    protected TestDescriptionIR constructTestDescriptionIR(String id, String title, TestGroupAttributes tgAttr, CodeSet codeSet, TestCase tc, String context, String executeArgs) throws TestFileException {
        TestDescriptionIR retVal = super.constructTestDescriptionIR(id, title, tgAttr, codeSet, tc, context, executeArgs);
        retVal.set("source", (String)null);
        retVal.set("client_source", (String)null);
        retVal.addRef("source", this.getTestSources(codeSet));
        retVal.addRef("client_source", this.getClientTestSources(codeSet));
        return retVal;
    }

    public void setProperties(Properties props) {
        this.props = props;
        super.setProperties(props);
    }

    protected static Properties addCopyrightLink(Properties props, TestGroup tg) {
        String outDir = IR.getAttrElem((String)"OutputDir", (TestItem)tg);
        if (outDir != null) {
            boolean isPath = false;
            int count = 0;
            StringTokenizer e = new StringTokenizer(outDir, "/");
            while (e.hasMoreElements()) {
                String entry = (String)e.nextElement();
                if (entry.equals("tests")) {
                    count = 0;
                    isPath = true;
                }
                if (!isPath) continue;
                ++count;
            }
            StringBuffer retVal = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                retVal.append("../");
            }
            retVal.append(COPYRIGHT_SHORT_NAME);
            props.setProperty(TESTGEN_COPYRIGHT_LINK_PROP, retVal.toString());
        }
        return props;
    }
}

