/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.internal;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import com.sun.tck.jc.internal.AdapterInformationExtractorExtractor;
import com.sun.tck.jc.internal.RunTestCasesContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class ExceptionToStatusGenerator {
    private static HashSet<String> classesSet = ExceptionToStatusGenerator.createClassesSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processJava(File from, StringWriter out) throws IOException {
        String source = ExceptionToStatusGenerator.readTextFile(from);
        boolean retVal = false;
        try {
            File[] sources = new File[]{from};
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            JavacTask task = (JavacTask)compiler.getTask(null, fileManager, null, null, null, fileManager.getJavaFileObjectsFromFiles(Arrays.asList(sources)));
            Trees root = Trees.instance(task);
            SourcePositions positions = root.getSourcePositions();
            int pos = 0;
            for (CompilationUnitTree compilationUnitTree : task.parse()) {
                RunTestCasesContext context = new RunTestCasesContext(compilationUnitTree, positions, classesSet);
                new AdapterInformationExtractorExtractor().scan(compilationUnitTree, context);
                if (context.startPosition <= pos) continue;
                retVal = true;
                out.write(source, pos, context.startPosition - pos);
                out.write("\n");
                out.write("        javacard.framework.ISOException outOfMemory = new javacard.framework.ISOException((short)0x9c15);\n");
                out.write("        try {// Added by DoTestGenerator\n");
                out.write(source, context.startPosition, context.endPosition - context.startPosition);
                out.write("\n        } catch (javacard.framework.ISOException isoEx) {\n            throw isoEx;\n        } catch (javacard.framework.SystemException se) {\n            short exceptionReason = se.getReason();\n            if (exceptionReason == javacard.framework.SystemException.NO_RESOURCE) {\n                throw outOfMemory;\n            } else {\n                javacard.framework.ISOException.throwIt((short)((short)0x9c10 | (0x0f & exceptionReason)));\n            }\n        } catch (javacard.security.CryptoException ex) {\n            javacard.framework.ISOException.throwIt((short)((short)0x9c20 | (0x0f & ex.getReason())));\n        } catch (javacard.framework.APDUException ex) {\n            short reason = ex.getReason();\n            reason = (byte)((reason & (short)0x07) | (reason >> 9));\n            javacard.framework.ISOException.throwIt((short)((short)0x9c30 | (0x0f & reason)));\n        } catch (ArithmeticException ex) {\n            javacard.framework.ISOException.throwIt((short)0x9cf0);\n        } catch (ArrayIndexOutOfBoundsException ex) {\n            javacard.framework.ISOException.throwIt((short)0x9cf1);\n        } catch (ArrayStoreException ex) {\n            javacard.framework.ISOException.throwIt((short)0x9cf2);\n        } catch (ClassCastException ex) {\n            javacard.framework.ISOException.throwIt((short)0x9cf3);\n        } catch (IndexOutOfBoundsException ex) {\n            javacard.framework.ISOException.throwIt((short)0x9cf4);\n        } catch (NegativeArraySizeException ex) {\n            javacard.framework.ISOException.throwIt((short)0x9cf5);\n        } catch (NullPointerException ex) {\n            javacard.framework.ISOException.throwIt((short)0x9cf6);\n        } catch (SecurityException ex) {\n            javacard.framework.ISOException.throwIt((short)0x9cf7);\n        } catch (RuntimeException ex) {\n            javacard.framework.ISOException.throwIt((short)0x9cf8);\n        } catch (Exception ex) {\n            javacard.framework.ISOException.throwIt((short)0x9cf9);\n        } catch (Throwable ex) {\n            javacard.framework.ISOException.throwIt((short)0x9cfa);\n        }\n    ");
                pos = context.endPosition;
            }
            out.write(source, pos, source.length() - pos);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            out.flush();
        }
        return retVal;
    }

    public static void main(String[] args) throws IOException {
        for (String name : args) {
            File file = new File(name);
            StringWriter out = new StringWriter();
            if (ExceptionToStatusGenerator.processJava(file, out)) {
                ExceptionToStatusGenerator.writeTextFile(file, out.toString());
                System.out.println("Generated MultiTest methods in " + name);
                continue;
            }
            System.out.println("Skipped MultiTest methods generation for " + name);
        }
    }

    private static HashSet<String> createClassesSet() {
        HashSet<String> retVal = new HashSet<String>();
        retVal.add("com.sun.javacard.cjck.userinterface.APDU");
        retVal.add("javacard.framework.APDU");
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) throws IOException {
        BufferedReader reader = null;
        IOException e = null;
        char[] buf = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            int len = (int)file.length();
            buf = new char[len];
            int n = 0;
            for (int off = 0; off < len && (n = reader.read(buf, off, len - off)) > 0; off += n) {
            }
        }
        catch (IOException ioe) {
            e = ioe;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (e != null) {
            throw e;
        }
        return new String(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(File file, String text) throws IOException {
        IOException e = null;
        OutputStreamWriter writer = null;
        try {
            ExceptionToStatusGenerator.mkdirs(file.getParentFile());
            writer = new FileWriter(file);
            writer.write(text, 0, text.length());
        }
        catch (IOException ioe) {
            e = ioe;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public static boolean mkdirs(String dir) {
        return ExceptionToStatusGenerator.mkdirs(new File(dir));
    }

    public static boolean mkdirs(File dir) {
        if (dir.exists()) {
            return dir.isDirectory();
        }
        File f = dir.isAbsolute() ? dir : dir.getAbsoluteFile();
        File p = f.getParentFile();
        if (!ExceptionToStatusGenerator.mkdirs(p)) {
            return false;
        }
        return f.mkdir() || f.isDirectory();
    }
}

