/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.FatalException;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.terminal.CardPresenceNotifier;
import com.sun.tck.bvtool.terminal.CardStore;
import java.util.Observer;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;

public class StatefulCardTerminal
extends CardTerminal {
    private State state = State.CREATED;
    private CardTerminal terminal;
    private String label;
    private CardStore cards;
    private Card card;
    private CardPresenceNotifier cardPresenceNotifier;

    public StatefulCardTerminal(CardTerminal terminal) throws CardException {
        this(CardStore.getDefaultStore(), terminal);
    }

    public StatefulCardTerminal(CardStore cards, CardTerminal terminal) throws CardException {
        this.terminal = terminal;
        this.cards = cards;
        this.cardPresenceNotifier = new CardPresenceNotifier(this);
        new Thread(this.cardPresenceNotifier).start();
    }

    public boolean checkConnection() {
        try {
            this.terminal.connect("T=0");
            return true;
        }
        catch (CardException ex) {
            return false;
        }
    }

    public void addCardPresenceObserver(Observer observer) {
        this.cardPresenceNotifier.addObserver(observer);
    }

    public void removeCardPresenceObserver(Observer observer) {
        this.cardPresenceNotifier.deleteObserver(observer);
    }

    public void removeAllCardPresenceObservers() {
        this.cardPresenceNotifier.deleteObservers();
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setInsertedCardID(String cardID) throws FatalException {
        this.card = this.cards.findCard(cardID);
    }

    public Card getInsertedCard() {
        return this.card;
    }

    public State getState() {
        return this.state;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return I18n.getString("stateful.terminal.name", this.terminal.toString(), this.label, (Object)this.state);
    }

    @Override
    public javax.smartcardio.Card connect(String protocol) throws CardException {
        return this.terminal.connect(protocol);
    }

    public javax.smartcardio.Card connectToCard(String protocol) throws FatalException {
        try {
            return this.connect(protocol);
        }
        catch (CardNotPresentException ex) {
            throw new FatalException(FatalException.Scope.Card, I18n.getString("cardnopresent.exception.connect", ex));
        }
        catch (CardException ex) {
            try {
                if (!this.isCardPresent()) {
                    throw new FatalException(FatalException.Scope.Card, I18n.getString("card.exception.connect", ex));
                }
            }
            catch (CardException cardException) {
                // empty catch block
            }
            throw new FatalException(FatalException.Scope.CAD, I18n.getString("card.exception.connect", ex));
        }
    }

    @Override
    public String getName() {
        return this.terminal.getName();
    }

    @Override
    public boolean isCardPresent() throws CardException {
        return this.terminal.isCardPresent();
    }

    public boolean checkCardPresent() {
        try {
            return this.terminal.isCardPresent();
        }
        catch (CardException ex) {
            return false;
        }
    }

    @Override
    public boolean waitForCardAbsent(long timeout) throws CardException {
        return this.terminal.waitForCardAbsent(timeout);
    }

    @Override
    public boolean waitForCardPresent(long timeout) throws CardException {
        return this.terminal.waitForCardPresent(timeout);
    }

    public static enum State {
        CREATED,
        INVALID,
        VERIFIED,
        RECOVERED,
        REPLACEMENT_REQUIRED,
        CARD_IDENTIFICATION_REQUIRED;

    }
}

