/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.tlv;

import com.sun.tck.bvtool.etsi.data.CAPDUTLV;
import com.sun.tck.bvtool.etsi.data.CommandPacket;
import com.sun.tck.bvtool.etsi.data.CommandScriptingTemplate;
import com.sun.tck.bvtool.etsi.data.RAPDUTLV;
import com.sun.tck.bvtool.etsi.data.ResponsePacket;
import com.sun.tck.bvtool.etsi.data.ResponseScriptingTemplate;
import com.sun.tck.bvtool.etsi.data.SecuredPacketTLV;
import com.sun.tck.bvtool.etsi.gsm.ProactiveCommandTLV;
import com.sun.tck.bvtool.etsi.tlv.ConstantBundle;
import com.sun.tck.bvtool.etsi.tlv.ConstructedTLV;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.RawTLV;
import com.sun.tck.bvtool.etsi.tlv.TLV;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.terminal.Card;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class TLVPrototypeFactory {
    private Card card;
    private HashMap<Integer, Class> prototypes = new HashMap();

    public TLVPrototypeFactory() {
        this(null);
    }

    public TLVPrototypeFactory(Card card) {
        this.card = card;
        this.registerClass((byte)-86, CommandScriptingTemplate.class);
        this.registerClass((byte)1, CommandPacket.class);
        this.registerClass((byte)34, CAPDUTLV.class);
        this.registerClass((byte)35, RAPDUTLV.class);
        this.registerClass((byte)-85, ResponseScriptingTemplate.class);
        this.registerClass((byte)2, ResponsePacket.class);
        this.registerClass((byte)-48, ProactiveCommandTLV.class);
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public TLV create(Class cl) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        if (cl == null) {
            return null;
        }
        TLV tlv = (TLV)cl.newInstance();
        if (tlv instanceof SecuredPacketTLV) {
            ((SecuredPacketTLV)tlv).init(this.card);
        }
        return tlv;
    }

    public void registerClass(byte tag, Class cl) {
        this.prototypes.put(new Integer(0xFF & tag), cl);
    }

    public long readTag(TLVBuffer in) throws EncodingException {
        long l = 0L;
        int c = in.read();
        if ((c & 0x1F) == 31) {
            do {
                c = in.read();
                l <<= 7;
                l |= (long)(c & 0x7F);
            } while ((c & 0x80) != 0);
        } else {
            return c;
        }
        return l;
    }

    public TLV create(long tag) throws InstantiationException, InvocationTargetException, IllegalAccessException, EncodingException {
        return this.create(tag, null);
    }

    public TLV create(long tag, ConstantBundle constants) throws InstantiationException, InvocationTargetException, IllegalAccessException, EncodingException {
        TLV tlv = this.create(this.find((byte)tag));
        if (constants != null) {
            tlv.constants = constants;
        }
        tlv.setTag((byte)tag, null);
        if (tlv instanceof SecuredPacketTLV) {
            ((SecuredPacketTLV)tlv).init(this.card);
            ((SecuredPacketTLV)tlv).setCompactMode(false);
        }
        return tlv;
    }

    private Class find(byte tag) {
        Class retVal = this.prototypes.get(new Integer(0xFF & tag));
        if (retVal != null) {
            return retVal;
        }
        return (tag & 0x20) == 0 ? RawTLV.class : ConstructedTLV.class;
    }
}

