/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.tlv;

import com.sun.tck.bvtool.etsi.gsm.ETSITags;
import com.sun.tck.bvtool.etsi.tlv.ConstantBundle;
import com.sun.tck.bvtool.etsi.tlv.Encodable;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.bvtool.etsi.tlv.TreeNode;
import com.sun.tck.bvtool.etsi.tlv.TreeNodeImpl;
import com.sun.tck.me.utils.Utils;

public abstract class TLV
extends TreeNodeImpl
implements Encodable {
    public static final byte UNDEFINED = 0;
    private byte tag = 0;
    private TLVPrototypeFactory factory;
    protected String name;
    protected ConstantBundle constants = new ConstantBundle(false, ETSITags.class);

    public TLV() {
        super(null, "TLV");
    }

    public void addByte(String name, int byteValue) {
        this.add(name, new TreeNode.Data(name, byteValue));
    }

    protected void setTagInternal(byte tag, String name) {
        this.tag = tag;
        if (this.name == null && name == null) {
            this.name = this.constants.find(tag);
        } else if (name != null) {
            this.name = name + "(0x" + Integer.toHexString(tag & 0xFF) + ")";
        }
    }

    public void setTag(byte tag, String name) throws EncodingException {
        if (this.tag != 0 && this.tag != tag) {
            throw new EncodingException("Inconsistent. Expected tag: 0x" + Integer.toHexString(this.tag & 0xFF) + " Found 0x" + Integer.toHexString(tag & 0xFF));
        }
        this.setTagInternal(tag, name);
    }

    public TLVPrototypeFactory getFactory() {
        return this.factory;
    }

    public void setFactory(TLVPrototypeFactory factory) {
        this.factory = factory;
    }

    protected abstract void writeData(TLVBuffer var1) throws Exception;

    public byte getTag() {
        return this.tag;
    }

    @Override
    public void encode(TLVBuffer buff) throws EncodingException {
        try {
            buff.write(this.tag);
            TLVBuffer lengthPointer = buff.createChild(1);
            this.writeData(buff);
            TLVUtils.writeLength(lengthPointer, buff.getPos() - lengthPointer.end());
        }
        catch (EncodingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncodingException("Encoding problem:", e);
        }
    }

    public abstract void decodeData(TLVPrototypeFactory var1, TLVBuffer var2) throws Exception;

    public void decode(TLVPrototypeFactory processor, TLVBuffer in) throws EncodingException {
        try {
            this.tag = (byte)TLVUtils.readTag(in);
            int length = TLVUtils.readLength(in);
            String entry = Integer.toHexString(this.tag & 0xFF);
            this.decodeData(processor, in.createChild(length));
        }
        catch (EncodingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncodingException("Can not parse TLV.", e);
        }
    }

    public String getName() {
        return this.name == null ? Utils.findName(this.tag, ETSITags.class) : this.name;
    }

    public byte[] toByteArray() throws EncodingException {
        TLVBuffer buff = new TLVBuffer(256000);
        this.encode(buff);
        byte[] retVal = new byte[buff.getPos()];
        System.arraycopy(buff.getBuffer(), 0, retVal, 0, retVal.length);
        return retVal;
    }

    @Override
    protected StringBuffer toStringHeader() {
        return new StringBuffer(this.getClass().getSimpleName()).append("{Tag=").append(this.getName());
    }

    @Override
    public Object value() {
        return this;
    }
}

