/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.security;

import com.sun.tck.bvtool.etsi.security.Checksum;
import com.sun.tck.bvtool.etsi.security.CryptographicChecksum;
import com.sun.tck.bvtool.etsi.security.KeyType;
import com.sun.tck.me.utils.Utils;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public class KeyDescr {
    public KeyType type;
    public byte keyId;
    public Cipher cipher;
    public Cipher decipher;
    public Checksum checksum;
    private String password;
    public int blockSize = 8;

    public KeyDescr(KeyType type, int keyId, byte[] password) throws GeneralSecurityException {
        this(type, keyId, password, false);
    }

    public KeyDescr(KeyType type, int keyId, byte[] password, boolean doEncrypt) throws GeneralSecurityException {
        this.type = type;
        this.keyId = (byte)keyId;
        this.cipher = type.createCipher(1, password, doEncrypt);
        this.decipher = type.createCipher(2, password, doEncrypt);
        this.checksum = new CryptographicChecksum(this);
        this.password = Utils.canonize(password);
    }

    public int encodeKey() {
        return 0xFF & (this.keyId << 4 | this.type.getCode());
    }

    public String toString() {
        return "(type=" + (Object)((Object)this.type) + " id=" + this.keyId + " key=" + this.password + ")";
    }
}

