/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.gp;

import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.terminal.CardState;
import com.sun.tck.bvtool.terminal.CardStore;
import java.io.File;

public class GSMCardConfigurator {
    private String keyList;
    private String KID;
    private String KIC;
    private Integer securityLevel;
    private Integer counter;
    private String iccid;
    private Integer keyVersion;
    private Card card;
    private CardStore store;
    private File stateStorage;
    private int counterStep;
    private CardStore.Format format = CardStore.Format.LONG;

    public void setKeyListFormat(String name) {
        this.format = "short".equalsIgnoreCase(name) ? CardStore.Format.SHORT : CardStore.Format.LONG;
    }

    public void setKIC(String KIC) {
        this.KIC = KIC;
    }

    public void setKID(String KID) {
        this.KID = KID;
    }

    public void setCounter(int counter) {
        this.counter = new Integer(counter);
    }

    public void setKeyList(String keyList) {
        this.keyList = keyList;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = new Integer(securityLevel);
    }

    public void setCounterStep(int step) {
        this.counterStep = step;
    }

    public void setIccid(String iccid) {
        this.iccid = iccid;
    }

    public void setKeyVersion(int keyVersion) {
        this.keyVersion = new Integer(keyVersion);
    }

    public void setStorageDir(File dir) {
        dir.mkdirs();
        this.stateStorage = dir;
    }

    public void init() throws Exception {
        if (this.keyList != null && this.iccid != null) {
            this.store = new CardStore();
            this.store.setFormat(this.format);
            this.store.setStorageDir(this.stateStorage);
            this.store.setKeyList(this.keyList);
            this.store.init();
            this.card = this.store.findCard(this.iccid);
        } else {
            String id = this.iccid == null ? this.KID : this.iccid;
            this.iccid = this.iccid == null ? id : this.iccid;
            int key = this.keyVersion == null ? 1 : this.keyVersion;
            this.card = new Card(CardState.restore(this.stateStorage, id), this.iccid, key, this.KID, this.KIC);
        }
        if (this.keyVersion != null) {
            this.card.setKeyVersion(this.keyVersion);
        }
        if (this.counter != null) {
            this.card.setCounter(this.counter);
        }
        if (this.securityLevel != null) {
            this.card.setSecurityLevel(this.securityLevel);
        }
        if (this.counterStep > 0) {
            this.card.counterStep = this.counterStep;
        }
    }

    public Card getCard() {
        return this.card;
    }

    public void close() throws Exception {
        if (this.store != null) {
            this.store.close();
        }
    }
}

