/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.data;

import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.tck.bvtool.etsi.data.APDUUtils;
import com.sun.tck.bvtool.etsi.data.CommandHeader;
import com.sun.tck.bvtool.etsi.data.SecuredPacketTLV;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import java.util.ArrayList;

public class CompactApduPacket
extends SecuredPacketTLV {
    private CommandAPDU[] apdus;
    private static final byte[] empty = new byte[0];

    public CompactApduPacket() {
        this.setTagInternal((byte)1, "CommandPacket");
        this.setCompactMode(true);
    }

    public CompactApduPacket(CommandAPDU ... apdus) {
        this(true, apdus);
    }

    private CompactApduPacket(boolean isCompact, CommandAPDU ... apdus) {
        this();
        this.apdus = apdus;
        this.setCompactMode(isCompact);
    }

    private void addApdu(TLVBuffer out, CommandAPDU apdu, boolean isLast) throws EncodingException {
        byte[] data = apdu.getBytes();
        switch (apdu.getCase()) {
            case CASE_1: {
                out.write(data);
                out.write(0);
                break;
            }
            case CASE_2S: {
                this.checkLast(isLast);
                out.write(data);
                break;
            }
            case CASE_3S: {
                out.write(data);
                break;
            }
            case CASE_4S: {
                this.checkLast(isLast);
                out.write(data, 0, data.length - 1);
                this.addApdu(out, APDUUtils.createResponseApdu(apdu.getLe()), true);
                break;
            }
            default: {
                throw new EncodingException("Unsupported case:" + (Object)((Object)apdu.getCase()));
            }
        }
    }

    @Override
    protected SecuredPacketTLV.Header createHeader() {
        CommandHeader retVal = new CommandHeader();
        retVal.setTAR(0);
        return retVal;
    }

    private void checkLast(boolean isLast) throws EncodingException {
        if (!isLast) {
            throw new EncodingException("Case 2 or case 4 apdu must the last in the list");
        }
    }

    @Override
    public void decodeSecuredData(TLVPrototypeFactory processor, TLVBuffer securedData) throws EncodingException {
        ArrayList<CommandAPDU> list = new ArrayList<CommandAPDU>();
        while (securedData.available() > 0) {
            byte cla = (byte)securedData.read();
            byte ins = (byte)securedData.read();
            byte p1 = (byte)securedData.read();
            byte p2 = (byte)securedData.read();
            int p3 = securedData.read();
            if (p3 == 0) {
                list.add(new CommandAPDU(cla, ins, p1, p2, empty, 0));
                continue;
            }
            if (securedData.available() > 0) {
                byte[] data = securedData.readArray(p3);
                list.add(new CommandAPDU(cla, ins, p1, p2, data, 0));
                continue;
            }
            list.add(new CommandAPDU(cla, ins, p1, p2, empty, (byte)p3));
        }
        this.apdus = list.toArray(new CommandAPDU[list.size()]);
    }

    @Override
    protected void writeSecuredData(TLVBuffer buff) throws EncodingException {
        for (int i = 0; i < this.apdus.length; ++i) {
            this.addApdu(buff, this.apdus[i], i == this.apdus.length - 1);
        }
    }
}

