/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.Status;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.agent.AgentManager;
import com.sun.jck.lib.ExecJCKTestSameJVMCmd;
import com.sun.jck.lib.I18n;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

class RemoteManager {
    private Task[] tasks;
    private static Status OK = Status.passed((String)"OK");

    RemoteManager(String args, TestEnvironment env, TestResult tr) throws Fault {
        String[] remoteEntries = RemoteManager.splitIntoLines(args);
        this.tasks = new Task[remoteEntries.length];
        try {
            int i;
            for (i = 0; i < remoteEntries.length; ++i) {
                String remoteEntry = remoteEntries[i];
                String hostInfo = null;
                String remoteClassName = null;
                String[] remoteArgs = null;
                int tokenNo = 0;
                int remoteIndex = 0;
                while (remoteIndex < remoteEntry.length()) {
                    char ch = remoteEntry.charAt(remoteIndex);
                    if (ch == ' ') {
                        ++remoteIndex;
                        continue;
                    }
                    if ((tokenNo == 0 || tokenNo == 2) && Character.isJavaIdentifierStart(ch)) {
                        int start = remoteIndex++;
                        while (remoteIndex < remoteEntry.length() && (Character.isJavaIdentifierPart(ch = remoteEntry.charAt(remoteIndex)) || ch == '.')) {
                            ++remoteIndex;
                        }
                        String word = remoteEntry.substring(start, remoteIndex);
                        if (tokenNo == 0) {
                            hostInfo = word;
                        } else {
                            remoteClassName = word;
                        }
                        ++tokenNo;
                        continue;
                    }
                    if (tokenNo == 1 && ch == ':') {
                        ++tokenNo;
                        ++remoteIndex;
                        continue;
                    }
                    if (tokenNo == 3) {
                        try {
                            remoteArgs = env.resolve(remoteEntry.substring(remoteIndex));
                            break;
                        }
                        catch (TestEnvironment.Fault e) {
                            throw new Fault(I18n.getString("error.evaluating.args", hostInfo));
                        }
                    }
                    throw new Fault(I18n.getString("syntax.error.remote"));
                }
                if (hostInfo == null || remoteClassName == null) {
                    throw new Fault(I18n.getString("format.error.remote"));
                }
                TestResult.Section trs = tr.createSection("remote." + hostInfo);
                try {
                    String[] hostArgs = env.lookup("remote." + hostInfo);
                    if (hostArgs == null || hostArgs.length == 0) {
                        throw new Fault(I18n.getString("no.value.found", hostInfo));
                    }
                    this.tasks[i] = new Task(hostArgs, remoteClassName, remoteArgs, trs);
                    continue;
                }
                catch (TestEnvironment.Fault e) {
                    throw new Fault(I18n.getString("error.evaluating.host", hostInfo));
                }
            }
            for (i = 0; i < this.tasks.length; ++i) {
                Thread thrd = new Thread(this.tasks[i]);
                thrd.start();
            }
        }
        catch (Fault f) {
            this.dispose();
            throw f;
        }
        catch (RuntimeException any) {
            this.dispose();
            throw any;
        }
    }

    synchronized boolean waitUntilDone(int timeout) throws InterruptedException {
        long now = System.currentTimeMillis();
        long end = now + (long)(timeout * 1000);
        boolean allDone = this.isAllTasksDone();
        while (now < end && !allDone) {
            this.wait(end - now);
            now = System.currentTimeMillis();
            allDone = this.isAllTasksDone();
        }
        return allDone;
    }

    private boolean isAllTasksDone() {
        for (int i = 0; i < this.tasks.length; ++i) {
            if (this.tasks[i] == null || this.tasks[i].isDone()) continue;
            return false;
        }
        return true;
    }

    synchronized void dispose() {
        if (this.tasks == null) {
            return;
        }
        for (int i = 0; i < this.tasks.length; ++i) {
            Task t = this.tasks[i];
            if (t == null) continue;
            t.dispose();
            this.tasks[i] = null;
        }
        this.tasks = null;
    }

    synchronized Status getStatus() {
        if (this.tasks == null) {
            return Status.error((String)I18n.getString("initialization.error"));
        }
        Status s = OK;
        for (int i = 0; i < this.tasks.length; ++i) {
            Task t = this.tasks[i];
            if (t == null) continue;
            s = RemoteManager.mergeStatus(s, t.getStatus());
        }
        return s;
    }

    static Status mergeStatus(Status s1, Status s2) {
        return s1 == null ? s2 : (s2 == null ? s1 : (s1.getType() >= s2.getType() ? s1 : s2));
    }

    private static String[] splitIntoLines(String s) throws Fault {
        Vector<String> v = new Vector<String>();
        int start = 0;
        int end = 0;
        while ((end = s.indexOf("\n", start)) != -1) {
            v.addElement(s.substring(start, end));
            start = end + 1;
        }
        v.addElement(s.substring(start));
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    private class Task
    implements Runnable {
        private final AgentManager.Task amTask;
        private final TestResult.Section trs;
        private final String className;
        private final String[] args;
        private Status status;

        Task(String[] hostArgs, String className, String[] args, TestResult.Section trs) throws Fault {
            this.className = className;
            this.args = args;
            this.trs = trs;
            String host = null;
            int port = -1;
            String classPath = null;
            for (int i = 0; i < hostArgs.length && hostArgs[i].startsWith("-"); ++i) {
                if (hostArgs[i].equals("-classpath") && i + 1 < hostArgs.length) {
                    classPath = hostArgs[++i];
                    continue;
                }
                if (hostArgs[i].equals("-host") && i + 1 < hostArgs.length) {
                    host = hostArgs[++i];
                    continue;
                }
                if (hostArgs[i].equals("-port") && i + 1 < hostArgs.length) {
                    try {
                        port = Integer.parseInt(hostArgs[++i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new Fault(I18n.getString("bad.port", hostArgs[i]));
                    }
                }
                throw new Fault(I18n.getString("unrecognized.option", hostArgs[i]));
            }
            if (host == null) {
                throw new Fault(I18n.getString("no.host.specified"));
            }
            try {
                AgentManager mgr = AgentManager.access();
                this.amTask = port == -1 ? mgr.connectToPassiveAgent(host) : mgr.connectToPassiveAgent(host, port);
                if (classPath != null) {
                    this.amTask.setClassPath(classPath);
                }
            }
            catch (IOException e) {
                throw new Fault(I18n.getString("error.accessing.agent", e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PrintWriter mw = this.trs.getMessageWriter();
            PrintWriter log = this.trs.createOutput("log");
            PrintWriter ref = this.trs.createOutput("ref");
            try {
                mw.println(I18n.getString("remote.execute", this.amTask.getConnection().getName()));
                String xxClassName = ExecJCKTestSameJVMCmd.class.getName();
                String[] xxArgs = new String[this.args.length + 1];
                xxArgs[0] = this.className;
                System.arraycopy(this.args, 0, xxArgs, 1, this.args.length);
                this.status = this.amTask.executeCommand(this.trs.getTitle(), xxClassName, xxArgs, false, log, ref);
                this.trs.setStatus(this.status);
                RemoteManager remoteManager = RemoteManager.this;
                synchronized (remoteManager) {
                    RemoteManager.this.notifyAll();
                }
            }
            finally {
                mw.close();
                log.close();
                ref.close();
            }
        }

        Status getStatus() {
            return this.status;
        }

        boolean isDone() {
            return this.status != null;
        }

        void dispose() {
            if (this.status == null) {
                this.status = Status.error((String)I18n.getString("incomplete"));
                this.trs.setStatus(this.status);
            }
        }
    }

    public static class Fault
    extends Exception {
        private String[] msgs;

        public Fault(String msg) {
            super(msg);
            this.msgs = new String[1];
            this.msgs[0] = msg;
        }

        public Fault(String[] msgs) {
            super(msgs[0]);
            this.msgs = msgs;
        }

        public String[] getMessages() {
            return this.msgs;
        }
    }
}

