/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.JavaCommentStream;
import com.sun.javatest.finder.TagTestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import com.sun.jck.lib.JCKTestSuite;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class JCKTagTestFinder
extends TagTestFinder {
    private boolean verify;
    private Map validEntries = JCKTagTestFinder.initTable(JCKTestSuite.getValidEntries());
    private Map validKeywords = JCKTagTestFinder.initTable(JCKTestSuite.getValidKeywords());
    private static final String TESTSUITE_HTML = "testsuite.html";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JCKTagTestFinder.class);

    public JCKTagTestFinder() {
        this.addExtension(".jasm", JavaCommentStream.class);
        this.addExtension(".jcod", JavaCommentStream.class);
    }

    public void init(String[] args, File testSuiteRoot, TestEnvironment env) throws TestFinder.Fault {
        if (testSuiteRoot.isDirectory()) {
            File f = new File(testSuiteRoot, TESTSUITE_HTML);
            if (!f.exists() || f.isDirectory() || !f.canRead()) {
                throw new TestFinder.Fault(i18n, "jckFinder.badRootDir", new Object[]{TESTSUITE_HTML, testSuiteRoot.getPath()});
            }
        } else {
            String name = testSuiteRoot.getName();
            if (!name.equals(TESTSUITE_HTML)) {
                throw new TestFinder.Fault(i18n, "jckFinder.badRootFile");
            }
            testSuiteRoot = new File(testSuiteRoot.getParent());
        }
        super.init(args, testSuiteRoot, env);
    }

    protected int decodeArg(String[] args, int i) throws TestFinder.Fault {
        if (args[i].equals("-verify")) {
            this.verify = true;
            return 1;
        }
        if (args[i].equals("-allowEntry")) {
            String e = args[i + 1];
            this.validEntries.put(e.toLowerCase(), e);
            return 2;
        }
        if (args[i].equals("-allowKeyword")) {
            String k = args[i + 1];
            this.validKeywords.put(k.toLowerCase(), k);
            return 2;
        }
        return super.decodeArg(args, i);
    }

    protected void processEntry(Map entries, String name, String value) {
        boolean valid;
        boolean bl = valid = this.validEntries.get(name.toLowerCase()) != null;
        if (this.verify) {
            String[] keys;
            if (!valid) {
                this.error(i18n, "jckFinder.unknownEntry", new Object[]{name, this.getCurrentFile()});
            }
            if (name.equalsIgnoreCase("keywords") && (keys = StringArray.split((String)value)) != null) {
                for (int i = 0; i < keys.length; ++i) {
                    String key = keys[i];
                    if (this.validKeywords.get(key.toLowerCase()) != null) continue;
                    this.error(i18n, "jckFinder.unknownKeyword", new Object[]{key, this.getCurrentFile()});
                }
            }
        }
        if (valid) {
            super.processEntry(entries, name, value);
        }
    }

    private static Map initTable(String[] entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < entries.length; ++i) {
            map.put(entries[i].toLowerCase(), entries[i]);
        }
        return map;
    }
}

