/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.referenceimpl;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.referenceimpl.CJCRECardService;
import com.sun.javacard.referenceimpl.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;

public class ProcessManager {
    public static final long COLLECTOR_SLEEP_TIME = 200L;
    public static final long CHECKER_SLEEP_TIME = 100L;
    public static final long SLEEP_TIME = 2000L;
    public static final int STATE_ERROR = -1;
    private HashSet children = new HashSet();
    private HashSet closed = new HashSet();
    private Logger log;
    private static int checkerCounter = 0;
    private static int collectorCounter = 0;
    private Collector collector = new Collector();
    private static Status nullStatus = new Status("null", -1, "", "");

    public ProcessManager(Logger log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status execute(String processName, String[] prog, String[] env) {
        Descriptor current = null;
        try {
            current = this.start(processName, prog, env);
            return this.waitUntilDone(current);
        }
        catch (Throwable throwable) {
            return this.waitUntilDone(current);
        }
    }

    public Descriptor start(String processName, String[] prog, String[] env) throws CardProxyException {
        return this.start(processName, prog, env, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Descriptor start(String processName, String[] prog, String[] env, String work_dir) throws CardProxyException {
        Descriptor current = new Descriptor(processName, prog, env, work_dir);
        HashSet hashSet = this.children;
        synchronized (hashSet) {
            this.children.add(current);
        }
        if (!this.collector.isAlive()) {
            this.collector.start();
        }
        CJCRECardService.closeStream(current.process.getOutputStream());
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status waitUntilDone(Descriptor current) {
        if (current == null) {
            return nullStatus;
        }
        if (current.process == null) {
            return new Status(current.name, -1, "", "");
        }
        try {
            Status status = new Status(current.name, current.close(false), current.outBuffer, current.errBuffer);
            return status;
        }
        catch (RuntimeException ex) {
            Status status = nullStatus;
            return status;
        }
        finally {
            current.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllProcesses() {
        this.log.log(I18n.getString("start.closeallprocess"), 2);
        HashSet hashSet = this.children;
        synchronized (hashSet) {
            for (Descriptor current : this.children) {
                this.log.log(I18n.getString("some.process.is.not.closed", current.name), 2);
                current.close(true);
            }
            for (Descriptor current : this.closed) {
                if (current.process != null) {
                    current.process.destroy();
                }
                CJCRECardService.closeStream(current.out);
                CJCRECardService.closeStream(current.err);
            }
        }
        this.log.log(I18n.getString("finish.closeallprocess"), 2);
    }

    public String readAll(InputStream in) {
        int pos;
        if (in == null) {
            return "";
        }
        byte[] buff = new byte[]{};
        try {
            int length = in.available();
            if (length == 0) {
                return "";
            }
            buff = new byte[in.available()];
            int bytesRead = 0;
            for (pos = 0; (bytesRead = in.read(buff, pos, buff.length - pos)) > 0 && pos < buff.length; pos += bytesRead) {
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new String(buff, 0, pos);
    }

    private void readBuffers(Descriptor item) {
        String data;
        if (item == null || !item.isActive) {
            return;
        }
        if (item.err != null) {
            item.errData = data = this.readAll(item.err);
            if (item.errBuffer != null) {
                item.errBuffer.append(data);
            }
        }
        if (item.out != null) {
            data = this.readAll(item.out);
            if (item.outBuffer != null) {
                item.outBuffer.append(data);
            }
        }
    }

    public static class Status {
        public String name;
        public int status;
        public String out;
        public String err;

        public Status(String name, int status, StringBuffer out, StringBuffer err) {
            this(name, status, out.toString(), err.toString());
        }

        public Status(String name, int status, String out, String err) {
            this.name = name;
            this.status = status;
            this.out = out;
            this.err = err;
        }
    }

    public class Collector
    extends Thread {
        private boolean isExecuting;

        public Collector() {
            super("CollectorThread_" + ++collectorCounter);
            this.isExecuting = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    HashSet hashSet = ProcessManager.this.children;
                    synchronized (hashSet) {
                        HashSet new_set = new HashSet();
                        for (Descriptor current : ProcessManager.this.children) {
                            (current.isActive ? new_set : ProcessManager.this.closed).add(current);
                            Descriptor descriptor = current;
                            synchronized (descriptor) {
                                ProcessManager.this.readBuffers(current);
                            }
                        }
                        ProcessManager.this.children = new_set;
                    }
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException e) {
                ProcessManager.this.log.log(I18n.getString("collector.interrupted"), 2);
                return;
            }
        }
    }

    public class Descriptor {
        private boolean isActive = true;
        public String name;
        public File work_dir;
        public Process process;
        public InputStream out;
        public InputStream err;
        public StringBuffer outBuffer;
        public StringBuffer errBuffer;
        public int state;
        String errData;

        public Descriptor(String name, String[] prog, String[] env, String work_dir) throws CardProxyException {
            this.work_dir = work_dir == null ? null : new File(work_dir);
            this.name = name;
            this.outBuffer = new StringBuffer();
            this.errBuffer = new StringBuffer();
            while (true) {
                try {
                    if (ProcessManager.this.log.isTraceEnabled()) {
                        StringBuffer progCmd = new StringBuffer();
                        for (int i = 0; i < prog.length; ++i) {
                            progCmd.append('\"').append(prog[i]).append('\"').append(' ');
                        }
                        ProcessManager.this.log.log("Trying to start process command: " + progCmd.toString(), 0);
                    }
                    this.process = Runtime.getRuntime().exec(prog, env, this.work_dir);
                    this.err = this.process.getErrorStream();
                    this.out = this.process.getInputStream();
                    this.checkProcess(100L);
                    ProcessManager.this.log.log(I18n.getString("descriptor.name", this, name), 2);
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        Runtime run = Runtime.getRuntime();
                        run.gc();
                        run.runFinalization();
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        if (this.process != null) {
                            this.close(true);
                        }
                        this.state = -1;
                        return;
                    }
                }
            }
        }

        public void checkProcess(long waitTime) throws CardProxyException {
            ProcessChecker checker = new ProcessChecker(this.process);
            checker.start();
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!checker.isInterrupted()) {
                checker.interrupt();
            }
            if (!checker.isProcessAlive()) {
                String errMessage = ProcessManager.this.readAll(this.err);
                if (errMessage == null || errMessage.length() == 0) {
                    errMessage = this.errData;
                }
                int exitCode = this.process.exitValue();
                this.process.destroy();
                checker = null;
                this.close(true);
                this.state = -1;
                ProcessManager.this.log.log("checkProcess() - Process is dead", 1);
                throw new CardProxyException("Process ends with status '" + exitCode + "'.\nError message: " + errMessage);
            }
            ProcessManager.this.log.log("checkProcess() - Process isn't dead", 1);
            checker = null;
        }

        /*
         * Exception decompiling
         */
        public int close(boolean isDestroy) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private class ProcessChecker
        extends Thread {
            Process process;
            boolean isProcessAlive;

            public ProcessChecker(Process process) {
                super("ProcessCheckerThread_" + ++checkerCounter);
                this.isProcessAlive = true;
                this.process = process;
            }

            @Override
            public void run() {
                try {
                    this.process.waitFor();
                    this.isProcessAlive = false;
                }
                catch (InterruptedException ex) {
                    return;
                }
            }

            public boolean isProcessAlive() {
                return this.isProcessAlive;
            }
        }
    }
}

