/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.referenceimpl;

import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.FrameworkException;
import com.sun.javacard.referenceimpl.CJCRECardService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class LoadClassFileCardService
extends CJCRECardService {
    long packageCount = new Random().nextInt();
    byte[] defaultRID = new byte[]{-96, 2, 0, 0, 98, 0, 0, 0, 0, 0, 0, 0, 0};

    public LoadClassFileCardService() {
    }

    public LoadClassFileCardService(int port) throws IOException {
        super(port);
    }

    @Override
    public String convertPackage(String packageName, AppletID packageAid, int majorVersion, int minorVersion, String classRootDir, String exportRootDir, boolean isExportMap, String outputDir, AppletProperties[] apa) throws FrameworkException {
        throw new FrameworkException("Conversion is unsupported");
    }

    @Override
    public boolean loadClassFileApplets(String[] packages, AppletProperties[] apa, String classDir, String outputDir) throws DeploymentException {
        String exportPath = this.serviceProperties.getProperty("RI") + File.separator + "api_export_files" + File.pathSeparator + outputDir;
        try {
            this.powerUp();
            for (int i = 0; i < packages.length; ++i) {
                AppletProperties[] applets = this.getAppletProperties(packages[i], apa);
                String capFile = super.convertPackage(packages[i], this.getPackageAid(packages[i], applets), 0, 1, classDir, exportPath, false, outputDir, applets);
                if (capFile == null) {
                    return false;
                }
                if (super.installCAPFile(i == packages.length - 1 ? apa : new AppletProperties[]{}, capFile, outputDir)) continue;
                return false;
            }
            return true;
        }
        catch (FrameworkException ex) {
            throw new DeploymentException(ex.getMessage());
        }
    }

    private AppletProperties[] getAppletProperties(String packName, AppletProperties[] applets) throws DeploymentException {
        ArrayList<AppletProperties> retVal = new ArrayList<AppletProperties>();
        for (int i = 0; i < applets.length; ++i) {
            if (!applets[i].getPackageName().equals(packName)) continue;
            retVal.add(applets[i]);
        }
        return retVal.toArray(new AppletProperties[retVal.size()]);
    }

    private AppletID getPackageAid(String packName, AppletProperties[] applets) throws DeploymentException {
        byte[] retVal = new byte[13];
        byte[] rid = applets == null || applets.length == 0 ? this.defaultRID : applets[0].getAID().getBytes();
        for (int i = 0; i < 5; ++i) {
            retVal[i] = rid[i];
        }
        do {
            ++this.packageCount;
            for (int i = 5; i < 13; ++i) {
                long count;
                retVal[i] = (byte)count;
                count >>= 8;
            }
        } while (this.isIncluded(retVal, applets));
        StringBuffer message = new StringBuffer("Created package AID for package:");
        message.append(packName);
        message.append(" -");
        for (int i = 0; i < retVal.length; ++i) {
            message.append(" 0x");
            message.append(Integer.toHexString(0xFF & retVal[i]));
        }
        this.log.log(message.toString(), 2);
        return new AppletID(retVal);
    }

    private boolean isIncluded(byte[] retVal, AppletProperties[] applets) {
        if (applets == null) {
            return false;
        }
        for (int i = 0; i < applets.length; ++i) {
            if (!LoadClassFileCardService.equals(retVal, applets[i].getAID().getBytes())) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(byte[] left, byte[] right) {
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean loadCapFileApplets(String[] capfiles, AppletProperties[] apa, String outputDir) throws DeploymentException {
        throw new DeploymentException("Loading of the cap files is unsupported");
    }

    @Override
    public boolean installCAPFile(AppletProperties[] appletPropertiesArray, String aCAPFileName, String outputDir) throws DeploymentException {
        throw new DeploymentException("Installation is unsupported.");
    }
}

