/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.referenceimpl;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClient;
import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.apdutool.ParseException;
import com.sun.javacard.apdutool.ScriptCommand;
import com.sun.javacard.apdutool.ScriptParser;
import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.CommunicationService;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.FrameworkException;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.javacard.referenceimpl.ContactlessService;
import com.sun.javacard.referenceimpl.Logger;
import com.sun.javacard.referenceimpl.ProcessManager;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class CJCRECardService
implements CJCKCardService {
    protected boolean crefRunning = false;
    protected int basePort = 0;
    protected boolean isMainCommunicationService = false;
    public static final String OPT_DEBUG_LEVEL = "DEBUG_LEVEL";
    public static final String OPT_RI = "RI";
    public static final String OPT_RI_RUN = "RI_RUN";
    public static final String OPT_COMVERTER_PREFIX = "-PC";
    public static final String OPT_CREF_PREFIX = "-PV";
    public static final String OPT_APDUTOOL_PREFIX = "-PA";
    public static final String OPT_SCRIPTGEN_PREFIX = "-PS";
    public static final String OPT_TRANSPORT_PROTOCOL = "TP";
    public static final String T0_PROTOCOL_OPTION = "t0";
    public static final String T1_PROTOCOL_OPTION = "tdual";
    public static final Boolean INT_SUPPORT = new Boolean("true");
    public static final Integer MAJOR_VERSION = new Integer(2);
    public static final Integer MAX_NVRAM = new Integer(4096);
    public static final Integer MAX_STACK = new Integer(256);
    public static final Integer MAX_TRANSIENT_RAM = new Integer(128);
    public static final Integer MINOR_VERSION = new Integer(2);
    public static final String API_VERSION = "2.2.1";
    public static final String BUILD_DATE = "10/08/03";
    public static final String BUILD_VERSION = "@(#)";
    public static final String MYNAME = "CJCRECardService";
    public static final String PROXY_NAME = "CJCRECardService";
    public static final String PROXY_VERSION = "2.2.1";
    public static final String RELEASE_VERSION = "2.2.1";
    public static final long SLEEP_TIME = 50L;
    protected String classpath = "";
    protected static final String CONVERTER_CLASSNAME = "com.sun.javacard.converter.Converter";
    protected static final String DEFAULT_CONFIG_FILE_NAME = "cjcretemp.cfg";
    protected static final String DEFAULT_HOST_NAME = "localhost";
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static final String JAVA_HOME = System.getProperty("java.home");
    protected static ArrayList JAVA_COMMAND = new ArrayList();
    protected static final String JAVA_VERSION;
    protected static final String JCRE_OPTION_RESTART = "-i";
    protected static final String JCRE_OPTION_SAVE = "-o";
    protected static final String JCRE_STATE_FILENAME = "JCRE-EEPROM-SAVE-";
    protected static final String JCRE_STATE_FILENAME_SUFFIX = ".dat";
    protected static final String REFIMPL_NAME = "C-JCRE";
    protected static final String SCRIPTGEN_CLASSNAME = "com.sun.javacard.scriptgen.Main";
    protected static final String SCRIPT_COMMENT = "//";
    protected static final String SCRIPT_FILE_SUFFIX = ".script.txt";
    protected static final int DEFAULT_DEBUG_LEVEL = 2;
    protected static final int DEFAULT_PORT = 9025;
    protected static final int MAX_ATTEMP = 2000;
    protected static final int CREF_CONNECT_ATTEMPTS = 100;
    protected static final int CREF_RESTART_ATTEMPTS = 10;
    protected static final int SW_RETURN = 36864;
    protected static String[] EXEC_ENVIRONMENT;
    protected boolean isCleanTempFiles = true;
    protected static final byte[] SELECT_INSTALLER_APDU;
    protected BufferedInputStream bin;
    protected BufferedOutputStream bos;
    protected Socket sock;
    protected String workingDir;
    protected int port = 0;
    protected boolean poweredUp = false;
    protected int recvApduNum;
    protected int sendApduNum;
    protected ArrayList converter_options = new ArrayList();
    protected ArrayList cref_options = new ArrayList();
    protected ArrayList apdutool_options = new ArrayList();
    protected ArrayList scriptgen_options = new ArrayList();
    protected CadClient cad;
    protected Logger log;
    protected ProcessManager manager;
    protected Properties serviceProperties = new Properties();
    protected int proxyStartCount = 0;
    protected long taskTimeout = 0L;
    protected ProcessManager.Descriptor currentProcDescriptor;
    protected byte transportProtocol;
    protected String transportProtocolName = "T0";
    protected String[] args;
    protected PrintWriter out;
    protected PrintWriter ref;
    protected CJCRECardService contactlessService;
    protected HashSet tempFiles = new HashSet();
    private PrintWriter script_file;

    public CJCRECardService() {
    }

    public CJCRECardService(int port) throws IOException {
        this.port = port;
    }

    @Override
    public void startTest(String workingDir, int numberOfExecutions) throws FrameworkException {
        this.workingDir = workingDir;
        this.log.log(I18n.getString("start.test", workingDir), 1);
        if (this.contactlessService != null) {
            this.contactlessService.workingDir = workingDir;
        }
        this.cleanupWorkingDir();
    }

    @Override
    public void stopTest() throws FrameworkException {
        Iterator e;
        this.log.log(I18n.getString("stop.test"), 1);
        if (this.script_file != null) {
            this.script_file.close();
        }
        if (this.isCleanTempFiles) {
            e = this.tempFiles.iterator();
            while (e.hasNext()) {
                try {
                    new File((String)e.next()).delete();
                }
                catch (Throwable t) {}
            }
        }
        e = this.tempFiles.iterator();
        while (e.hasNext()) {
            try {
                new File((String)e.next()).delete();
            }
            catch (Throwable throwable) {}
        }
        if (this.getCurrentProcDescriptor() != null) {
            this.getCurrentProcDescriptor().close(true);
        }
        this.manager.closeAllProcesses();
    }

    @Override
    public void powerUp() throws FrameworkException {
        if (this.poweredUp) {
            this.log.log(I18n.getString("already.power.up"), 1);
            return;
        }
        if (this.script_file != null) {
            this.script_file.println(I18n.getString("power.up"));
        }
        this.log.log(I18n.getString("powerup.up.start"), 0);
        this.startProxy();
        if (this.cad == null) {
            return;
        }
    }

    @Override
    public void powerDown() throws FrameworkException {
        this.log.log(I18n.getString("power.down"), 1);
        if (!this.poweredUp) {
            this.log.log(I18n.getString("not.powered.up.yet"), 1);
            return;
        }
        if (this.script_file != null) {
            this.script_file.println(I18n.getString("power.down.1"));
        }
        if (this.sendApduNum > this.recvApduNum) {
            this.log.log(I18n.getString("proxy.hung.failed", new Integer(this.sendApduNum)), 1);
            this.recvApduNum = this.sendApduNum;
        }
        if (this.cad == null) {
            return;
        }
        try {
            if (this.cad != null) {
                this.powerDownCad();
            }
        }
        catch (TLP224Exception e) {
            this.log.log(I18n.getString("power.down.exception", (Object)e), 1);
        }
        catch (IOException e) {
            try {
                this.powerDownCad();
            }
            catch (TLP224Exception e1) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.log.log(I18n.getString("power.down.exception", e), 1);
        }
        this.stopCref();
        this.log.log(I18n.getString("proxy.has.powered.down"), 1);
        this.poweredUp = false;
    }

    public void stopCref() throws FrameworkException {
        this.closeSocket(this.sock);
        this.stopProxy();
    }

    @Override
    public void reset() throws FrameworkException {
        this.log.log(I18n.getString("reset.cjcre.process"), 1);
        this.powerDown();
        this.powerUp();
    }

    @Override
    public String convertPackage(String packageName, AppletID packageAid, int majorVersion, int minorVersion, String classRootDir, String exportRootDir, boolean isExportMap, String outputDir, AppletProperties[] apa) throws FrameworkException {
        this.log.log(I18n.getString("convert.package"), 0);
        this.log.log(I18n.getString("preparing.convert.package", new Object[]{packageName, new Integer(majorVersion), new Integer(minorVersion), this.converter_options}), 0);
        this.log.log(I18n.getString("convert.package.info", new Object[]{classRootDir, exportRootDir, isExportMap ? Boolean.TRUE : Boolean.FALSE, outputDir}), 0);
        ArrayList cmd = (ArrayList)JAVA_COMMAND.clone();
        cmd.add(this.classpath);
        cmd.add(CONVERTER_CLASSNAME);
        cmd.add("-exportpath");
        cmd.add(exportRootDir);
        if (isExportMap) {
            cmd.add("-exportmap");
        }
        cmd.add("-classdir");
        cmd.add(classRootDir);
        for (int i = 0; i < apa.length; ++i) {
            AppletProperties ap = apa[i];
            cmd.add("-applet");
            cmd.add(this.convertAID(ap.getAID(), "0x", ":"));
            cmd.add(ap.getClassName());
        }
        cmd.add("-d");
        cmd.add(outputDir);
        cmd.add("-out");
        cmd.add("JCA");
        cmd.add("EXP");
        cmd.add("CAP");
        cmd.addAll(this.converter_options);
        cmd.add(packageName);
        cmd.add(this.convertAID(packageAid, "0x", ":"));
        cmd.add(Integer.toString(majorVersion) + "." + Integer.toString(minorVersion));
        this.doExec("Converter", cmd, this.taskTimeout, 0);
        String capFile = outputDir + FILE_SEPARATOR + packageName.replace('.', File.separatorChar) + FILE_SEPARATOR + "javacard" + FILE_SEPARATOR + packageName.substring(packageName.lastIndexOf(".") + 1, packageName.length()) + ".cap";
        if (!new File(capFile).exists()) {
            throw new FrameworkException(I18n.getString("capfile.creation.exception"));
        }
        return capFile;
    }

    String convertAID(AppletID aid, String prefix, String suffix) throws FrameworkException {
        StringBuffer newAID = new StringBuffer();
        byte[] aidba = aid.getBytes();
        if (aidba.length > 0) {
            newAID.append(prefix);
            newAID.append(Integer.toHexString(aidba[0] & 0xFF));
        }
        for (int i = 1; i < aidba.length; ++i) {
            newAID.append(suffix);
            newAID.append(prefix);
            newAID.append(Integer.toHexString(aidba[i] & 0xFF));
        }
        return newAID.toString();
    }

    @Override
    public boolean loadClassFileApplets(String[] packages, AppletProperties[] apa, String classDir, String outputDir) throws DeploymentException {
        throw new DeploymentException(I18n.getString("loadclassfileapplet.not.applicable"));
    }

    @Override
    public boolean loadCapFileApplets(String[] capfiles, AppletProperties[] apa, String outputDir) throws DeploymentException {
        throw new DeploymentException(I18n.getString("loadcapfileapplet.not.applicable"));
    }

    @Override
    public boolean installCAPFile(AppletProperties[] appletPropertiesArray, String aCAPFileName, String outputDir) throws DeploymentException {
        try {
            String scriptFileName = outputDir + FILE_SEPARATOR + aCAPFileName.substring(aCAPFileName.lastIndexOf(FILE_SEPARATOR)) + SCRIPT_FILE_SUFFIX;
            this.tempFiles.add(scriptFileName);
            ArrayList cmd = (ArrayList)JAVA_COMMAND.clone();
            cmd.add(this.getClassPath());
            cmd.add(SCRIPTGEN_CLASSNAME);
            cmd.addAll(this.scriptgen_options);
            cmd.add(JCRE_OPTION_SAVE);
            cmd.add(scriptFileName);
            cmd.add(aCAPFileName);
            this.doExec("scriptgen", cmd, this.taskTimeout, 1);
            if (!this.poweredUp) {
                throw new DeploymentException(I18n.getString("invoke.installcapfile.before.powerup"));
            }
            boolean retVal = true;
            Apdu selectInstallerApdu = this.convertToApdu(new CommandAPDU(SELECT_INSTALLER_APDU));
            try {
                this.sendInternalAPDU(selectInstallerApdu, 36864);
                this.log.log(I18n.getString("send.create.applet.command"), 0);
                this.processScriptFile(scriptFileName);
            }
            catch (ScriptFailException e) {
                this.log.log(e.toString(), 3);
                return false;
            }
            for (int i = 0; i < appletPropertiesArray.length; ++i) {
                try {
                    this.log.log(I18n.getString("try.install.capfile.name", appletPropertiesArray[i].getClassName()), 1);
                    this.sendInternalAPDU(selectInstallerApdu, 36864);
                    byte[] aid = appletPropertiesArray[i].getAID().getBytes();
                    byte[] command = new byte[aid.length + 8];
                    command[0] = -128;
                    command[1] = -72;
                    command[2] = 0;
                    command[3] = 0;
                    command[4] = (byte)(aid.length + 2);
                    command[5] = (byte)aid.length;
                    System.arraycopy(aid, 0, command, 6, aid.length);
                    command[command.length - 2] = 0;
                    command[command.length - 1] = 127;
                    Apdu cApdu = this.convertToApdu(new CommandAPDU(command));
                    retVal = this.sendInternalAPDU(cApdu).sw() != 36864 ? false : retVal;
                    continue;
                }
                catch (ScriptFailException e) {
                    this.log.log(e.toString(), 3);
                    retVal = false;
                }
            }
            this.sendInternalAPDU(selectInstallerApdu, 36864);
            return retVal;
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace(this.out);
            throw new DeploymentException("Unknown");
        }
    }

    public void processScriptFile(String scriptFileName) throws FrameworkException, DeploymentException, ScriptFailException {
        ScriptParser parser;
        BufferedInputStream inputStream;
        boolean apduCount = false;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(scriptFileName));
            parser = new ScriptParser((InputStream)inputStream);
        }
        catch (IOException e) {
            this.log.log(e.toString(), 3);
            throw new FrameworkException(I18n.getString("open.script.file.exception", e));
        }
        try {
            ScriptCommand cmd;
            block21: while ((cmd = parser.getScriptCommand()) != null) {
                switch (cmd.getType()) {
                    case 1: {
                        this.powerUp();
                        continue block21;
                    }
                    case 2: {
                        this.powerDown();
                        continue block21;
                    }
                    case 3: {
                        try {
                            Thread.sleep(((Integer)cmd.getData()).intValue());
                        }
                        catch (InterruptedException e) {}
                        continue block21;
                    }
                    case 5: {
                        this.log.log(SCRIPT_COMMENT + cmd.getData(), 2);
                        continue block21;
                    }
                    case 4: {
                        this.sendInternalAPDU((Apdu)cmd.getData(), 36864);
                        continue block21;
                    }
                }
                throw new ParseException(I18n.getString("unknown.script.command"));
            }
        }
        catch (ScriptFailException e) {
            throw e;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            e1.printStackTrace(this.out);
            this.log.log(I18n.getString("install.failed.with.exception", e1), 3);
            throw new DeploymentException(e1.toString());
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {}
        }
    }

    protected void startCref() throws FrameworkException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getRunCommand());
        command.addAll(this.cref_options);
        if (this.proxyStartCount > 1) {
            command.add(JCRE_OPTION_RESTART);
            command.add(this.getSaveFileName(this.proxyStartCount - 1));
        }
        if (this.log.isTraceEnabled()) {
            command.add("-z");
        }
        command.add(JCRE_OPTION_SAVE);
        command.add(this.getSaveFileName(this.proxyStartCount));
        this.setCrefBasePort(command);
        this.tempFiles.add(this.workingDir + File.separator + this.getSaveFileName(this.proxyStartCount));
        this.log.log(I18n.getString("start.proxy.command", command), 0);
        String processName = "C-JCRE(#" + this.proxyStartCount + ")";
        Throwable t = null;
        for (int i = 0; i < 10; ++i) {
            try {
                this.currentProcDescriptor = this.manager.start(processName, command.toArray(new String[command.size()]), EXEC_ENVIRONMENT, this.workingDir);
                this.crefRunning = true;
                return;
            }
            catch (Throwable th) {
                this.log.log(I18n.getString("cref.start.failed", th), 0);
                t = th;
                this.setCrefBasePort(command);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new FrameworkException(I18n.getString("cref.start.failed", t));
    }

    public ProcessManager.Descriptor getCurrentProcDescriptor() {
        return this.currentProcDescriptor;
    }

    public boolean isCrefRunning() {
        return this.crefRunning;
    }

    public CadClient getCad() throws FrameworkException {
        if (this.cad == null) {
            this.cad = this.createCadClient(DEFAULT_HOST_NAME, this.getPort());
        }
        return this.cad;
    }

    public void powerDownCad() throws TLP224Exception, IOException {
        this.log.log("powerDownCad()", 0);
        this.cad.powerDown();
    }

    protected void startProxy() throws FrameworkException {
        ++this.proxyStartCount;
        this.log.log(I18n.getString("start.proxy", new Integer(this.proxyStartCount)), 0);
        Throwable t = null;
        for (int i = 0; i < 10; ++i) {
            if (!this.isCrefRunning()) {
                this.startCref();
                this.log.log(I18n.getString("refimpl.started.separate.process"), 0);
            }
            try {
                this.cad = this.getCad();
            }
            catch (FrameworkException ex) {
                if (!this.isCrefRunning()) continue;
                this.stopProxy();
                continue;
            }
            this.log.log("Attempt #" + i, 0);
            try {
                this.cad.powerUp();
                this.log.log(I18n.getString("proxy.has.powered.up"), 1);
                this.poweredUp = true;
                return;
            }
            catch (Throwable e) {
                t = e;
                this.log.log(I18n.getString("cjcre.powerup.exception", e), 1);
                if (e instanceof SocketException) {
                    this.crefRunning = false;
                    this.cad = null;
                }
                try {
                    this.currentProcDescriptor.checkProcess(50L);
                    continue;
                }
                catch (CardProxyException ex) {
                    t = ex;
                    this.crefRunning = false;
                    this.cad = null;
                }
            }
        }
        throw new FrameworkException(I18n.getString("cref.start.failed", t));
    }

    void doExec(String pName, ArrayList prog, long timeOut, int maxErrors) throws FrameworkException {
        this.log.log(I18n.getString("doexec.exec", prog), 0);
        this.reportProcess(this.manager.execute(pName, prog.toArray(new String[prog.size()]), EXEC_ENVIRONMENT));
    }

    String getSaveFileName(int n) {
        return JCRE_STATE_FILENAME + n + JCRE_STATE_FILENAME_SUFFIX;
    }

    protected void stopProxy() throws FrameworkException {
        this.log.log(I18n.getString("start.stop.proxy"), 0);
        if (this.getCurrentProcDescriptor() != null) {
            this.log.log(I18n.getString("start.terminate.proxy"), 0);
            this.reportProcess(this.manager.waitUntilDone(this.getCurrentProcDescriptor()));
            this.log.log(I18n.getString("terminate.proxy.done"), 0);
        } else {
            this.log.log(I18n.getString("proxy.already.terminated"), 0);
        }
        this.cad = null;
        if (this.contactlessService != null) {
            this.contactlessService.cad = null;
        }
        this.log.log(I18n.getString("proxy.stopped"), 0);
        CJCRECardService.closeStream(this.bin);
        CJCRECardService.closeStream(this.bos);
        this.crefRunning = false;
    }

    public static void closeStream(Object in) {
        if (in == null) {
            return;
        }
        try {
            if (in instanceof InputStream) {
                ((InputStream)in).close();
            } else if (in instanceof OutputStream) {
                ((OutputStream)in).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void reportProcess(ProcessManager.Status status) {
        this.log.log(I18n.getString("process.end.with.status", new Object[]{status.name, new Integer(status.status), status.out, status.err}), 2);
    }

    private void cleanupWorkingDir() throws FrameworkException {
        this.log.log(I18n.getString("clean.work.dir"), 0);
        File dir = new File(this.workingDir);
        String[] list = dir.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i].startsWith(JCRE_STATE_FILENAME)) {
                    try {
                        File f = new File(dir, list[i]);
                        if (!f.exists() || !f.delete()) continue;
                        this.log.log(I18n.getString("deleted.eeprom.save.file", list[i]), 1);
                    }
                    catch (Exception e) {
                        this.log.log(I18n.getString("unable.delete.eeprom.save.file", list[i], e), 1);
                    }
                    continue;
                }
                this.log.log(I18n.getString("do.not.delete.file", list[i]), 1);
            }
        }
        this.proxyStartCount = 0;
    }

    @Override
    public ResponseAPDU sendAPDU(CommandAPDU capdu) throws FrameworkException {
        if (!this.poweredUp) {
            throw new FrameworkException(I18n.getString("invoke.sendapdu.before.powerup"));
        }
        return this.sendCommandAPDU(capdu);
    }

    private Apdu convertToApdu(CommandAPDU capdu) {
        Apdu apdu = new Apdu();
        apdu.command = new byte[]{capdu.getCLA(), capdu.getINS(), capdu.getP1(), capdu.getP2()};
        apdu.Lc = capdu.getLc();
        apdu.setDataIn(capdu.getDataIn());
        apdu.Le = capdu.getLe();
        return apdu;
    }

    public ResponseAPDU sendCommandAPDU(CommandAPDU capdu) throws FrameworkException {
        return this.sendInternalAPDU(this.convertToApdu(capdu));
    }

    public void sendInternalAPDU(Apdu capdu, int sw) throws FrameworkException {
        ResponseAPDU resp = this.sendInternalAPDU(capdu);
        if (resp.sw() != sw) {
            throw new ScriptFailException(I18n.getString("incorrect.sw.answer", Integer.toHexString(sw), Integer.toHexString(resp.sw())));
        }
    }

    private void addApduToScript(byte[] buffer) {
        if (this.script_file != null && buffer != null) {
            StringBuffer line = new StringBuffer();
            for (int i = 0; i < buffer.length; ++i) {
                line.append(" 0x");
                line.append(Integer.toHexString(0xFF & buffer[i]));
            }
            line.append(";");
            this.script_file.println(line.toString());
        }
    }

    public ResponseAPDU sendInternalAPDU(Apdu apdu) throws FrameworkException {
        byte[] dataOut;
        this.log.log(I18n.getString("sending.apdu", new Integer(++this.sendApduNum), apdu.toString()), 1);
        this.addApduToScript(apdu.getCommandApduBytes());
        try {
            this.cad.exchangeApdu(apdu);
        }
        catch (TLP224Exception e) {
            e.printStackTrace();
            try {
                this.cad.powerDown();
            }
            catch (TLP224Exception e1) {
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new FrameworkException(I18n.getString("cjcre.responseapdu.cad.powerdown", e.getMessage()));
        }
        catch (IOException e) {
            this.log.log(e.toString(), 3);
            try {
                this.cad.powerDown();
            }
            catch (TLP224Exception e1) {
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new FrameworkException(I18n.getString("cjcre.responseapdu.cad.powerdown", e.getMessage()));
        }
        this.log.log(I18n.getString("receive.apdu", new Integer(++this.recvApduNum), apdu), 2);
        int le = apdu.getLe();
        byte[] respByte = new byte[le + 2];
        if (le > 0 && (dataOut = apdu.getDataOut()) != null) {
            System.arraycopy(dataOut, 0, respByte, 0, le);
        }
        respByte[respByte.length - 2] = apdu.sw1sw2[0];
        respByte[respByte.length - 1] = apdu.sw1sw2[1];
        return new ResponseAPDU(respByte);
    }

    CadClient createCadClient(String hostName, int port) throws FrameworkException {
        CadClient cad;
        this.log.log(I18n.getString("createcadclient.open.connection", hostName, new Integer(port)), 1);
        try {
            this.closeSocket(this.sock);
            this.log.log(I18n.getString("createcadclient.try.create.cadclient"), 0);
            this.sock = this.openSocket(hostName, port);
            this.log.log(I18n.getString("createcadclient.opened.socket", this.sock), 0);
            this.bin = new BufferedInputStream(this.sock.getInputStream());
            this.bos = new BufferedOutputStream(this.sock.getOutputStream());
            cad = new CadClient((InputStream)this.bin, (OutputStream)this.bos);
        }
        catch (IOException e) {
            throw new FrameworkException(I18n.getString("socket.connection.failed.exception", new Integer(port), e.getMessage()));
        }
        this.log.log(I18n.getString("createcadclient.created"), 0);
        return cad;
    }

    private Socket openSocket(String hostName, int port) throws FrameworkException {
        Socket socket = new Socket();
        InetSocketAddress crefAddr = new InetSocketAddress(DEFAULT_HOST_NAME, port);
        Exception t = null;
        InetSocketAddress cadLocalAddr = new InetSocketAddress(DEFAULT_HOST_NAME, this.getCadLocalPort());
        for (int i = 0; i < 100; ++i) {
            try {
                socket = new Socket();
                try {
                    this.log.log("Trying to bind socket to " + cadLocalAddr, 0);
                    socket.bind(cadLocalAddr);
                }
                catch (BindException e) {
                    this.log.log("Failed to bind socket to " + cadLocalAddr + " BindException: " + e.getMessage(), 0);
                    cadLocalAddr = new InetSocketAddress(DEFAULT_HOST_NAME, this.getCadLocalPort());
                    t = e;
                    continue;
                }
                this.log.log("Trying to connect socket to " + crefAddr, 0);
                socket.connect(crefAddr);
                socket.setTcpNoDelay(true);
                this.log.log(I18n.getString("opensocket.open.socket.on.port", new Integer(port)), 1);
                return socket;
            }
            catch (UnknownHostException e) {
                this.log.log(I18n.getString("opensocket.unknown.host.name", hostName), 0);
                t = e;
            }
            catch (ConnectException ex) {
                this.log.log("Failed to connect socket to " + crefAddr + " ConnectException: " + ex.getMessage(), 0);
                t = ex;
            }
            catch (IOException e) {
                this.log.log(I18n.getString("open.socket.exception", e), 0);
                t = e;
            }
            try {
                this.getCurrentProcDescriptor().checkProcess(50L);
                continue;
            }
            catch (CardProxyException ex) {
                t = ex;
                this.crefRunning = false;
                break;
            }
        }
        throw new FrameworkException(I18n.getString("can.not.open.socket.on.port", new Integer(port), t));
    }

    void closeSocket(Socket sock) {
        if (sock != null && !sock.isClosed()) {
            String socketName = sock.toString();
            try {
                sock.shutdownOutput();
                sock.close();
            }
            catch (Exception e) {
                this.log.log(I18n.getString("closesocket.got.exception", e), 1);
            }
            sock = null;
            this.log.log(I18n.getString("socket.closed") + " " + socketName, 0);
        } else {
            this.log.log(I18n.getString("socket.already.closed"), 0);
        }
    }

    @Override
    public Hashtable getProperties() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("Proxy Name", "CJCRECardService");
        ht.put("Proxy Version", "2.2.1");
        ht.put("API Version", "2.2.1");
        ht.put("Max Stack", MAX_STACK);
        ht.put("Max Transient RAM", MAX_TRANSIENT_RAM);
        ht.put("Max NVRAM", MAX_NVRAM);
        ht.put("int support", INT_SUPPORT);
        return ht;
    }

    protected void banner() {
        this.log.log(I18n.getString("release.info", new Object[]{"2.2.1", MAJOR_VERSION, MINOR_VERSION, BUILD_VERSION, BUILD_DATE}), 1);
        this.log.log(I18n.getString("java.info", JAVA_VERSION), 1);
        this.log.log(I18n.getString("cjckcardservice.release.info", "2.2.1", "Version:1.20"), 1);
    }

    public String getClassPath() {
        String ri = this.serviceProperties.getProperty(OPT_RI);
        this.log.log(I18n.getString("cjcrecardservice.classpath", ri), 1);
        return this.classpath + (ri == null ? "" : File.pathSeparator + ri + File.separator + "lib" + File.separator + "scriptgen.jar");
    }

    public String getRunCommand() throws FrameworkException {
        String command = null;
        if (this.serviceProperties != null && (command = this.serviceProperties.getProperty(OPT_RI_RUN)) == null && (command = this.serviceProperties.getProperty(OPT_RI)) != null) {
            command = command + File.separator + "bin" + File.separator;
            command = this.getExecutableName(command);
        }
        if (command == null) {
            throw new IllegalArgumentException(I18n.getString("undefined.cref"));
        }
        this.checkExecutable(command);
        return command;
    }

    private void checkExecutable(String name) {
        if (new File(name).exists()) {
            return;
        }
        if (File.separatorChar == '\\' && (new File(name + ".exe").exists() || new File(name + ".bat").exists())) {
            return;
        }
        throw new IllegalArgumentException(I18n.getString("name.not.exist", name));
    }

    @Override
    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        this.args = args;
        this.out = out;
        this.ref = ref;
        this.log = new Logger(0, out, ref);
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(OPT_COMVERTER_PREFIX)) {
                this.converter_options.add(args[i].substring(OPT_COMVERTER_PREFIX.length()));
                continue;
            }
            if (args[i].startsWith(OPT_CREF_PREFIX)) {
                this.cref_options.add(args[i].substring(OPT_CREF_PREFIX.length()));
                continue;
            }
            if (args[i].startsWith(OPT_APDUTOOL_PREFIX)) {
                this.apdutool_options.add(args[i].substring(OPT_APDUTOOL_PREFIX.length()));
                continue;
            }
            if (args[i].startsWith(OPT_SCRIPTGEN_PREFIX)) {
                this.scriptgen_options.add(args[i].substring(OPT_SCRIPTGEN_PREFIX.length()));
                continue;
            }
            if (args[i].equals("-classpath") && i < args.length - 1) {
                this.classpath = args[++i];
                continue;
            }
            if (args[i].equals("-script_file") && i < args.length - 1) {
                try {
                    this.script_file = new PrintWriter(new BufferedOutputStream(new FileOutputStream(args[++i])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!args[i].startsWith("-") || i >= args.length - 1) continue;
            this.serviceProperties.setProperty(args[i].length() > 1 ? args[i].substring(1) : "", args[++i]);
        }
        String s = (String)this.serviceProperties.get(OPT_DEBUG_LEVEL);
        int level = 2;
        try {
            if (s != null) {
                level = Integer.parseInt(s);
            }
        }
        catch (Exception e) {
            this.log.log(e.toString(), 2);
        }
        this.log.setDebugLevel(level);
        this.manager = new ProcessManager(this.log);
        this.banner();
    }

    @Override
    public boolean deleteAppletInstances(AppletProperties[] applets) throws DeploymentException {
        this.log.log(I18n.getString("delete.applet.ins.log"), 0);
        for (int i = 0; i < applets.length; ++i) {
            this.log.log(I18n.getString("deleting.applet", applets[i].getClassName()), 1);
        }
        if (applets.length > 7) {
            this.log.log(I18n.getString("allowed.applet.deletion.per.one.request"), 2);
            return false;
        }
        int size = 6;
        for (int i = 0; i < applets.length; ++i) {
            size += 1 + applets[i].getAID().getBytes().length;
        }
        byte[] data = new byte[size];
        data[0] = -128;
        data[1] = -60;
        data[2] = (byte)applets.length;
        data[3] = 0;
        data[4] = (byte)(size - 6);
        int pos = 5;
        for (int aidNumber = 0; aidNumber < applets.length; ++aidNumber) {
            byte[] aid = applets[aidNumber].getAID().getBytes();
            data[pos++] = (byte)aid.length;
            for (int i = 0; i < aid.length; ++i) {
                data[pos++] = aid[i];
            }
        }
        data[pos] = 127;
        this.selectInstaller();
        try {
            ResponseAPDU answer = this.sendAPDU(new CommandAPDU(data));
            int sw = answer.sw();
            return sw == 36864;
        }
        catch (FrameworkException ex) {
            throw new DeploymentException(ex.getMessage());
        }
    }

    @Override
    public boolean deletePackage(AppletID packageID, String packageName) throws DeploymentException {
        this.log.log(I18n.getString("package.deletion.log"), 0);
        return this.deletePackageInternal(packageID, packageName, false);
    }

    private boolean deletePackageInternal(AppletID packageID, String packageName, boolean isInstance) throws DeploymentException {
        try {
            this.log.log(I18n.getString("deletion.package.name", packageName), 1);
            byte[] aid_bytes = packageID.getBytes();
            byte[] data = new byte[7 + aid_bytes.length];
            data[0] = -128;
            data[1] = (byte)(isInstance ? 194 : 192);
            data[2] = 0;
            data[3] = 0;
            data[4] = (byte)(aid_bytes.length + 1);
            data[5] = (byte)aid_bytes.length;
            System.arraycopy(aid_bytes, 0, data, 6, aid_bytes.length);
            data[data.length - 1] = 127;
            this.selectInstaller();
            ResponseAPDU answer = this.sendAPDU(new CommandAPDU(data));
            int sw = answer.sw();
            if (sw == 28416) {
                throw new DeploymentException(I18n.getString("unknown.answer"));
            }
            return sw == 36864;
        }
        catch (FrameworkException ex) {
            throw new DeploymentException(ex.getMessage());
        }
    }

    protected void selectInstaller() throws DeploymentException {
        try {
            ResponseAPDU answer = this.sendAPDU(new CommandAPDU(SELECT_INSTALLER_APDU));
            if (answer.sw() != 36864) {
                throw new DeploymentException(I18n.getString("can.not.select.installer"));
            }
        }
        catch (FrameworkException ex) {
            throw new DeploymentException(ex.getMessage());
        }
    }

    @Override
    public boolean deletePackageAndInstances(AppletID packageID, String packageName) throws DeploymentException {
        this.log.log(I18n.getString("package.ins.deletion.log"), 0);
        return this.deletePackageInternal(packageID, packageName, true);
    }

    protected synchronized int getCadLocalPort() {
        int freePort = 0;
        for (int i = 0; i < 2000; ++i) {
            try {
                ServerSocket cadTmpSocket = new ServerSocket(0);
                freePort = cadTmpSocket.getLocalPort();
                if (freePort % 4 != 0) {
                    try {
                        cadTmpSocket.close();
                        cadTmpSocket = null;
                    }
                    catch (IOException ex) {}
                    continue;
                }
                try {
                    cadTmpSocket.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.log.log("getCadLocalPort() returned port #" + freePort, 0);
                return freePort;
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        return 9024;
    }

    protected synchronized void setCrefBasePort(ArrayList crefCommand) throws FrameworkException {
        if (crefCommand.contains("-p")) {
            crefCommand.remove("-p");
            crefCommand.remove(Integer.toString(this.basePort));
        }
        crefCommand.add("-p");
        for (int i = 0; i < 2000; ++i) {
            ServerSocket baseSocket;
            try {
                baseSocket = new ServerSocket(0);
            }
            catch (IOException ex) {
                continue;
            }
            this.basePort = baseSocket.getLocalPort();
            if (this.basePort % 4 != 1) {
                try {
                    baseSocket.close();
                }
                catch (IOException ex) {}
                continue;
            }
            if (this.transportProtocolName != T0_PROTOCOL_OPTION) {
                ServerSocket nextSocket;
                try {
                    nextSocket = new ServerSocket(this.basePort + 1);
                    this.log.log("Base port: " + this.basePort + ", next port: " + nextSocket.getLocalPort(), 0);
                }
                catch (IOException ex) {
                    this.log.log(I18n.getString("io.exception", ex.getMessage()), 0);
                    try {
                        baseSocket.close();
                    }
                    catch (IOException iex) {}
                    continue;
                }
                try {
                    nextSocket.close();
                }
                catch (IOException ex) {
                    this.log.log(I18n.getString("socket.next.close.failed", nextSocket), 0);
                }
            }
            try {
                baseSocket.close();
            }
            catch (IOException ex) {
                this.log.log(I18n.getString("socket.base.close.failed", baseSocket), 0);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.log.log("CREF will be started on port #" + this.basePort, 0);
            crefCommand.add(Integer.toString(this.basePort));
            return;
        }
        throw new FrameworkException(I18n.getString("no.free.ports"));
    }

    protected String getExecutableName(String dir) throws FrameworkException {
        String[] guess = new String[]{dir + "cref_" + System.getProperty("os.arch") + "_" + this.transportProtocolName, dir + "cref_" + this.transportProtocolName, dir + "cref_" + this.transportProtocolName + ".exe", dir + "cref", dir + "cref.exe"};
        for (int i = 0; i < guess.length; ++i) {
            if (!new File(guess[i]).exists()) continue;
            return guess[i];
        }
        throw new FrameworkException("Cref implementation does not exist.");
    }

    @Override
    public CommunicationService getCommunicationService(int iface) throws FrameworkException {
        if (iface == 1) {
            if (this.contactlessService == null) {
                this.isMainCommunicationService = true;
            }
            return this;
        }
        if (iface == 2) {
            if (this.contactlessService == null) {
                ContactlessService clessService = new ContactlessService();
                clessService.isMainCommunicationService = !this.isMainCommunicationService;
                clessService.setContactedService(this);
                clessService.init(this.args, this.out, this.ref);
                this.contactlessService = clessService;
            }
            return this.contactlessService;
        }
        throw new FrameworkException(I18n.getString("unsupported.io.interface", new Integer(iface)));
    }

    int getPort() {
        return this.basePort;
    }

    @Override
    public void setCardTerminal(StatefulCardTerminal terminal) {
    }

    static {
        JAVA_COMMAND.add(JAVA_HOME + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "java");
        JAVA_COMMAND.add("-classpath");
        JAVA_VERSION = System.getProperty("java.version");
        SELECT_INSTALLER_APDU = new byte[]{0, -92, 4, 0, 9, -96, 0, 0, 0, 98, 3, 1, 8, 1, 127};
    }
}

