/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.userinterface;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.APDU;
import com.sun.tck.me.utils.Utils;

public class CommandAPDU
extends APDU {
    private byte[] dataIn;
    public static final int MAX_DATA_LENGTH = Short.MAX_VALUE;
    private int le = -1;
    private int lc = -1;
    private APDU_CASE type;

    public CommandAPDU(byte cla, byte ins, byte p1, byte p2, byte[] data, byte le) {
        this(CommandAPDU.createData(cla, ins, p1, p2, data, le));
    }

    public CommandAPDU(byte cla, byte ins, byte p1, byte p2, byte[] data, int le) {
        this.initializeAPDU(cla, ins, p1, p2, data, le);
    }

    public CommandAPDU(byte[] data) {
        super(data);
        this.calculate();
    }

    public APDU_CASE getCase() {
        return this.type;
    }

    public byte getCLA() {
        return this.data[0];
    }

    public byte getINS() {
        return this.data[1];
    }

    public byte getP1() {
        return this.data[2];
    }

    public byte getP2() {
        return this.data[3];
    }

    public int getLc() {
        return this.lc;
    }

    public int getLe() {
        return this.le;
    }

    public int getData(int index) {
        if (index < this.getLc() && index >= 0) {
            int offset = this.getDataOffset();
            return offset < 0 ? -1 : this.data[offset + index] & 0xFF;
        }
        return -1;
    }

    private int getDataOffset() {
        if (this.type.order < APDU_CASE.CASE_2E.order && this.type.order > 0) {
            return 5;
        }
        if (this.type.order <= APDU_CASE.CASE_4E.order && this.type.order > 0) {
            return 7;
        }
        return -1;
    }

    public void calculate() {
        if (this.data.length < 4) {
            return;
        }
        if (this.data.length == 4) {
            this.le = 0;
            this.lc = 0;
            this.type = APDU_CASE.CASE_1;
            this.dataIn = new byte[0];
            return;
        }
        if (this.data.length == 5) {
            this.lc = 0;
            this.le = this.data[4] & 0xFF;
            this.type = APDU_CASE.CASE_2S;
            this.dataIn = new byte[0];
            return;
        }
        int b1 = this.data[4] & 0xFF;
        if (b1 != 0 && b1 + 5 == this.data.length) {
            this.lc = b1;
            this.le = 0;
            this.type = APDU_CASE.CASE_3S;
            this.dataIn = new byte[this.lc];
            System.arraycopy(this.data, 5, this.dataIn, 0, this.lc);
            return;
        }
        if (b1 != 0 && b1 + 6 == this.data.length) {
            this.lc = b1;
            this.le = this.data[this.data.length - 1] & 0xFF;
            this.type = APDU_CASE.CASE_4S;
            this.dataIn = new byte[this.lc];
            System.arraycopy(this.data, 5, this.dataIn, 0, this.lc);
            return;
        }
        if (this.data.length < 7 || this.data[4] != 0) {
            return;
        }
        int lc = (this.data[5] << 8 | this.data[6] & 0xFF) & 0xFFFF;
        if (this.data.length == 7) {
            this.lc = 0;
            this.le = lc;
            this.type = APDU_CASE.CASE_2E;
            this.dataIn = new byte[0];
            return;
        }
        if (this.data.length == lc + 7) {
            this.lc = lc;
            this.le = 0;
            this.type = APDU_CASE.CASE_3E;
            this.dataIn = new byte[this.lc];
            System.arraycopy(this.data, 7, this.dataIn, 0, this.lc);
            return;
        }
        if (this.data.length != lc + 9) {
            return;
        }
        this.lc = lc;
        this.le = (this.data[this.data.length - 2] << 8 | this.data[this.data.length - 1] & 0xFF) & 0xFFFF;
        this.type = APDU_CASE.CASE_4E;
        this.dataIn = new byte[this.lc];
        System.arraycopy(this.data, 7, this.dataIn, 0, this.lc);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("Command APDU (CLA:");
        buff.append(this.byteToHex(this.getCLA()));
        buff.append(", INS:");
        buff.append(this.byteToHex(this.getINS()));
        buff.append(", P1:");
        buff.append(this.byteToHex(this.getP1()));
        buff.append(", P2:");
        buff.append(this.byteToHex(this.getP2()));
        buff.append(", Lc:");
        buff.append(this.byteToHex(this.getLc()));
        if (this.getLc() > 0) {
            buff.append(", Data:0x");
            buff.append(Utils.canonize(this.data, this.getDataOffset(), this.getLc()));
        }
        buff.append(", Le:");
        buff.append(this.byteToHex(this.getLe()));
        buff.append(")");
        return buff.toString();
    }

    private void initializeAPDU(byte cla, byte ins, byte p1, byte p2, byte[] data, int le) {
        if (data.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException(I18n.getString("data.too.long", new Integer(data.length)));
        }
        if (le < 0 || le > Short.MAX_VALUE) {
            throw new IllegalArgumentException(I18n.getString("incorrect.le.value", new Integer(le), new Integer(Short.MAX_VALUE)));
        }
        this.le = le;
        this.lc = data.length;
        this.dataIn = new byte[this.lc];
        if (this.lc != 0) {
            System.arraycopy(data, 0, this.dataIn, 0, this.lc);
        }
        this.type = this.lc == 0 && le == 0 ? APDU_CASE.CASE_1 : (this.lc == 0 ? (le < 256 ? APDU_CASE.CASE_2S : APDU_CASE.CASE_2E) : (le == 0 ? (this.lc < 256 ? APDU_CASE.CASE_3S : APDU_CASE.CASE_3E) : (le < 256 && this.lc < 256 ? APDU_CASE.CASE_4S : APDU_CASE.CASE_4E)));
        this.data = CommandAPDU.createAPDUByType(cla, ins, p1, p2, data, le, this.type);
    }

    public static byte[] createData(byte cla, byte ins, byte p1, byte p2, byte[] data, byte le) {
        if (data.length > 255) {
            throw new IllegalArgumentException(I18n.getString("data.too.long", new Integer(data.length)));
        }
        int length = 4 + data.length + (data.length == 0 ? 0 : 1) + (le == 0 ? 0 : 1);
        byte[] retVal = new byte[length];
        retVal[0] = cla;
        retVal[1] = ins;
        retVal[2] = p1;
        retVal[3] = p2;
        if (data.length != 0) {
            retVal[4] = (byte)data.length;
            System.arraycopy(data, 0, retVal, 5, data.length);
        }
        if (le != 0) {
            retVal[retVal.length - 1] = le;
        }
        return retVal;
    }

    private static byte[] createAPDUByType(byte cla, byte ins, byte p1, byte p2, byte[] data, int le, APDU_CASE type) {
        byte[] apdu = null;
        int lcLength = 0;
        switch (type) {
            case CASE_1: {
                return new byte[]{cla, ins, p1, p2};
            }
            case CASE_2S: {
                return new byte[]{cla, ins, p1, p2, (byte)le};
            }
            case CASE_2E: {
                return new byte[]{cla, ins, p1, p2, 0, (byte)(le >> 8), (byte)(le & 0xFF)};
            }
            case CASE_3S: {
                apdu = new byte[5 + data.length];
                apdu[4] = (byte)data.length;
                lcLength = 1;
                break;
            }
            case CASE_3E: {
                apdu = new byte[7 + data.length];
                apdu[4] = 0;
                apdu[5] = (byte)(data.length >> 8);
                apdu[6] = (byte)(data.length & 0xFF);
                lcLength = 3;
                break;
            }
            case CASE_4S: {
                apdu = new byte[6 + data.length];
                apdu[4] = (byte)data.length;
                apdu[5 + data.length] = (byte)le;
                lcLength = 1;
                break;
            }
            case CASE_4E: {
                apdu = new byte[9 + data.length];
                apdu[4] = 0;
                apdu[5] = (byte)(data.length >> 8);
                apdu[6] = (byte)(data.length & 0xFF);
                apdu[7 + data.length] = (byte)(le >> 8);
                apdu[8 + data.length] = (byte)(le & 0xFF);
                lcLength = 3;
            }
        }
        apdu[0] = cla;
        apdu[1] = ins;
        apdu[2] = p1;
        apdu[3] = p2;
        System.arraycopy(data, 0, apdu, 4 + lcLength, data.length);
        return apdu;
    }

    public byte[] getDataIn() {
        if (this.dataIn == null) {
            return null;
        }
        byte[] result = new byte[this.dataIn.length];
        System.arraycopy(this.dataIn, 0, result, 0, this.dataIn.length);
        return result;
    }

    public static enum APDU_CASE {
        UNDEFINED(0),
        CASE_1(1),
        CASE_2S(2),
        CASE_3S(3),
        CASE_4S(4),
        CASE_2E(5),
        CASE_3E(6),
        CASE_4E(7);

        int order;

        private APDU_CASE(int order) {
            this.order = order;
        }
    }
}

