/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.userinterface;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CardService;

public class CardServiceFactory {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 0;
    public static final String DEFAULT_CARD_SERVICE = "CJCKCardService";

    public static CardService getCardService() throws CardProxyException {
        return CardServiceFactory.getCardService(DEFAULT_CARD_SERVICE);
    }

    public static CardService getCardService(String proxyClassName, ClassLoader loader) throws CardProxyException {
        Object cs = null;
        try {
            cs = Class.forName(proxyClassName, true, loader).newInstance();
            return cs;
        }
        catch (Exception e) {
            throw new CardProxyException(I18n.getString("cardservicefactory.exception", proxyClassName, e));
        }
    }

    public static CardService getCardService(String proxyClassName) throws CardProxyException {
        CardService ccs;
        try {
            ccs = (CardService)Class.forName(proxyClassName).newInstance();
        }
        catch (Exception e) {
            throw new CardProxyException(I18n.getString("cardservicefactory.exception", proxyClassName, e));
        }
        return ccs;
    }
}

