/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardProxyArguments;
import com.sun.javacard.cjck.invoke.CustomizableScript;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.scripts.StdScript;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.javatest.Status;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class ResourceScript
extends StdScript
implements CustomizableScript {
    public static final int MAX_RESOURCE = Short.MAX_VALUE;
    public static final short SW_TEST_PASSED = -25856;
    private static final int CHUNK_SIZE = 32;
    private static final byte CLA_JCRE_TEST = -128;
    private static final byte INS_DO_TESTS = 32;
    private static final byte INS_DATA_TO_CARD = 64;
    private static final byte INS_DATA_FROM_CARD = 48;
    private static final byte START = 1;
    private static final byte PROGRESS = 2;
    private static final byte END = 4;
    private String fileName;
    private String goldenFileName;
    private CardProxyArguments args;

    public Status sendResourceToCard(InputStream in, byte id) throws ScriptFailException, CardProxyException {
        int len;
        byte[] data;
        try {
            data = this.loadData(in);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Status.error((String)I18n.getString("can.not.load.resource"));
        }
        this.sendAPDU(new CommandAPDU(new byte[]{-128, 64, 1, 0, 2, (byte)(data.length >> 8), (byte)(data.length & 0xFF), 127}), (short)-25856);
        for (int offset = 0; offset < data.length; offset += len) {
            len = data.length - offset;
            len = len > 32 ? 32 : len;
            byte[] sent = new byte[len + 5];
            sent[0] = -128;
            sent[1] = 64;
            sent[2] = 2;
            sent[3] = 0;
            sent[4] = (byte)len;
            System.arraycopy(data, offset, sent, 5, len);
            this.sendAPDU(new CommandAPDU(sent), (short)-25856);
        }
        this.sendAPDU(new CommandAPDU(new byte[]{-128, 64, 4, id}), (short)-25856);
        return Status.passed((String)"");
    }

    public byte[] receiveResourceFromCard(byte id) throws ScriptFailException, CardProxyException {
        int len;
        CommandAPDU apdu = new CommandAPDU(new byte[]{-128, 48, 1, id, 2});
        ResponseAPDU answer = this.sendAPDU(apdu);
        byte[] resp = answer.getBytes();
        if (answer.sw() != 39680 || resp.length != 4) {
            this.log(I18n.getString("receive.resource.from.card.answer", Integer.toHexString(answer.sw())));
            this.log(I18n.getString("receive.resource.from.card.res.length", Integer.toHexString(resp.length)));
            throw new ScriptFailException(I18n.getString("error.communication"));
        }
        byte[] data = new byte[resp[0] << 8 & 0xFF00 | resp[1] & 0xFF];
        for (int offset = 0; offset < data.length; offset += len) {
            apdu = new CommandAPDU(new byte[]{-128, 48, 2, 0, 127});
            answer = this.sendAPDU(apdu);
            resp = answer.getBytes();
            len = resp.length - 2;
            if (answer.sw() != 39680 || offset + len > data.length) {
                throw new ScriptFailException(I18n.getString("error.communication"));
            }
            System.arraycopy(resp, 0, data, offset, len);
        }
        this.sendAPDU(new CommandAPDU(new byte[]{-128, 48, 4, id}), (short)-25856);
        return data;
    }

    protected byte[] loadData(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer buff = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            int pos = line.indexOf("//");
            if (pos >= 0) {
                line = line.substring(0, pos);
            }
            buff.append("\n");
            buff.append(line);
        }
        StringTokenizer bytes = new StringTokenizer(buff.toString(), "\n\t ");
        int length = bytes.countTokens();
        if (length > Short.MAX_VALUE) {
            throw new IllegalArgumentException(I18n.getString("invalid.length", Integer.toHexString(Short.MAX_VALUE)));
        }
        byte[] data = new byte[length];
        for (int i = 0; i < data.length; ++i) {
            String token = bytes.nextToken();
            if (token.charAt(0) != '0' && (token.charAt(1) != 'x' || token.charAt(1) != 'X')) {
                throw new ScriptFailException(Status.error((String)I18n.getString("incorrect.format", token)));
            }
            data[i] = (byte)Integer.parseInt(token.substring(2), 16);
        }
        return data;
    }

    @Override
    public void setArguments(String[] args) {
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equalsIgnoreCase("-in")) {
                this.fileName = args[++i];
                continue;
            }
            if (!args[i].equalsIgnoreCase("-out")) continue;
            this.goldenFileName = args[++i];
        }
    }

    @Override
    public Status runScript() throws CardProxyException {
        try {
            byte[] golden;
            this.select(this.args.getExecuteClass());
            FileInputStream in = new FileInputStream(new File(this.args.getTestDir(), this.fileName));
            FileInputStream out = new FileInputStream(new File(this.args.getTestDir(), this.goldenFileName));
            Status status = this.sendResourceToCard(in, (byte)0);
            if (!status.isPassed()) {
                return status;
            }
            byte[] result = this.receiveResourceFromCard((byte)0);
            if (result.length != (golden = this.loadData(out)).length) {
                this.log(I18n.getString("incorrect.return.length", Integer.toHexString(golden.length), Integer.toHexString(result.length)));
                return Status.failed((String)I18n.getString("incorrect.return.length.1"));
            }
            status = Status.passed((String)"");
            for (int i = 0; i < result.length; ++i) {
                if (result[i] == golden[i]) continue;
                this.log(I18n.getString("incorrect.result", Integer.toHexString(i), new Byte(golden[i]), new Byte(result[i])));
                status = Status.failed((String)I18n.getString("incorrect.result.1", Integer.toHexString(i)));
            }
            return status;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Status.error((String)e.toString());
        }
    }

    public void compareResults(byte[] result, int resultOffset, byte[] expected, int expectedOffset, int length) {
        if (resultOffset + length > result.length || expectedOffset + length > expected.length) {
            throw new ScriptFailException(I18n.getString("inconsistent.length"));
        }
        Status status = Status.passed((String)"");
        for (int i = 0; i < length; ++i) {
            if (result[resultOffset + i] == expected[expectedOffset + i]) continue;
            this.log(I18n.getString("incorrect.result", Integer.toHexString(resultOffset + i), new Byte(expected[expectedOffset + i]), new Byte(result[resultOffset + i])));
            status = Status.failed((String)I18n.getString("incorrect.result.1", Integer.toHexString(resultOffset + i)));
        }
        if (!status.isPassed()) {
            throw new ScriptFailException(status);
        }
    }

    public void compareResults(byte[] result, int resultOffset, int length, String goldenFileName) throws IOException {
        byte[] expec = this.loadData(new FileInputStream(new File(this.args.getTestDir(), goldenFileName)));
        this.compareResults(result, resultOffset, expec, 0, length);
    }

    public void compareResults(byte[] result, String goldenFileName) throws IOException {
        byte[] data = this.loadData(new FileInputStream(new File(this.args.getTestDir(), goldenFileName)));
        if (data.length != result.length) {
            throw new ScriptFailException(I18n.getString("incorrect.length", Integer.toHexString(result.length), Integer.toHexString(data.length)));
        }
        this.compareResults(result, 0, result.length, goldenFileName);
    }

    @Override
    public void setCardProxyArguments(CardProxyArguments arguments) {
        this.args = arguments;
    }
}

