/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.scripts.LCScript;
import com.sun.javacard.cjck.scripts.RemoteMethod;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.scripts.TLV;
import com.sun.javacard.cjck.scripts.UnexpectedSWException;
import com.sun.javacard.cjck.scripts.rmi.Parameter;
import com.sun.javacard.cjck.scripts.rmi.RemoteRef;
import com.sun.javacard.cjck.scripts.rmi.RemoteRefWithClass;
import com.sun.javacard.cjck.scripts.rmi.RemoteRefWithInterfaces;
import com.sun.javacard.cjck.scripts.rmi.ResponseException;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.javatest.Status;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RMIScript
extends LCScript {
    public static final int JC_RMI_MAJOR_VERSION = 2;
    public static final int JC_RMI_MINOR_VERSION = 2;
    public static final int FCI_TAG = 111;
    public static final int APPLICATION_DATA_TAG = 110;
    public static final int JC_RMI_DATA_TAG = 94;
    public static final int ERROR_TAG = 153;
    public static final int EXCEPTION_SUBCLASS_TAG = 131;
    public static final int EXCEPTION_TAG = 130;
    public static final int NORMAL_TAG = 129;
    public static final int RMI_NORMAL_RESPONSE = 36864;
    public static final int RMI_SELECTION_SUCCESS = 36864;
    public static final int JC_RMI_ERROR_LENGTH = 6;
    public static final int JC_RMI_DATA_OFFSET = 3;
    public static final int VOID = 1;
    public static final int BOOLEAN = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int REMOTE_REF = 6;
    public static final int ARRAY = 16;
    public static final int BOOLEAN_ARRAY = 18;
    public static final int BYTE_ARRAY = 19;
    public static final int SHORT_ARRAY = 20;
    public static final int INT_ARRAY = 21;
    public static final byte NULL_TAG = -1;
    public static final int INTERFACE_MASK = 16;
    public byte DEFAULT_RMI_LE = (byte)127;
    public int SECURE_MASK = 0;
    private byte partialSelectionByte = 0;
    private boolean isClass;
    private byte invoke_ins;
    private int version;

    public RemoteRef selectWithRMI(String name, int channel, boolean isClass) throws CardProxyException, UnexpectedSWException {
        return this.selectWithRMI(this.findApplet(name), channel, isClass);
    }

    public RemoteRef selectWithRMI(AppletProperties applet, int channel, boolean isClass) throws CardProxyException, UnexpectedSWException {
        this.log(I18n.getString("start.select.rmi", applet.getClassName(), new Integer(channel), isClass ? Boolean.TRUE : Boolean.FALSE));
        RMIScript.checkChannel(channel);
        byte CLA = RMIScript.getInterindustryChannelCLA(channel);
        byte p2 = (byte)(this.partialSelectionByte | (isClass ? 0 : 16));
        CommandAPDU apdu = new CommandAPDU(CLA, -92, 4, p2, applet.getAID().getBytes(), this.DEFAULT_RMI_LE);
        this.isClass = isClass;
        ResponseAPDU res = this.sendAPDU(apdu);
        if (res.sw() != 36864) {
            throw new UnexpectedSWException(res);
        }
        return this.parseInitialRemoteRef(res);
    }

    public byte getInvokeInstruction() {
        return this.invoke_ins;
    }

    public Parameter invokeRemoteMethod(RemoteMethod method, int channel, int expected_type) throws CardProxyException {
        return this.invokeRemoteMethod(method, channel, this.invoke_ins, expected_type);
    }

    public Parameter invokeRemoteMethod(RemoteMethod method, int channel, int invoke_ins, int expected_type) throws CardProxyException {
        return this.invokeRemoteMethod(method, channel, invoke_ins, expected_type, this.DEFAULT_RMI_LE);
    }

    public Parameter invokeRemoteMethod(RemoteMethod method, int channel, int invoke_ins, int expected_type, byte expected_le) throws CardProxyException {
        this.log(I18n.getString("start.invoke.remote.method", new Object[]{method, new Integer(channel), Integer.toHexString(invoke_ins), Integer.toHexString(expected_type)}));
        RMIScript.checkChannel(channel);
        byte CLA = RMIScript.getSecureProprietaryChannelCLA(channel, true, this.SECURE_MASK);
        CommandAPDU apdu = new CommandAPDU(CLA, (byte)invoke_ins, 2, 2, method.getData(), expected_le);
        ResponseAPDU resp = this.sendAPDU(apdu);
        if (resp.sw() != 36864) {
            throw new UnexpectedSWException(resp);
        }
        TLV answer = new TLV(resp, 0, 0, resp.getLe());
        if (!this.parseErrorOrException(answer, 0)) {
            if (expected_type == 6) {
                RMIScript.check(answer.getData(0) == 129, I18n.getString("unknown.tag.in.response"));
                return this.parseRemoteRefInternal(answer, 1);
            }
            RMIScript.check(resp.getLe() > 0, I18n.getString("response.should.contain.onebyte"));
            byte[] data = new byte[resp.getLe() - 1];
            System.arraycopy(resp.getBytes(), 1, data, 0, data.length);
            return Parameter.parseReturnData(data, expected_type);
        }
        return null;
    }

    private RemoteRef parseInitialRemoteRef(ResponseAPDU apdu) throws CardProxyException {
        TLV rmi = TLV.findTLV(94, TLV.findTLV(110, TLV.findTLV(111, apdu, 0, apdu.getLe(), "FCI"), "APPLICATION_DATA"), "JC_RMI_DATA_TAG");
        RMIScript.check(rmi.offset + rmi.length == apdu.getLe(), I18n.getString("response.incorrectly.extended"));
        this.invoke_ins = (byte)rmi.getData(2);
        this.version = 0xFF00 & rmi.getData(0) << 8 | rmi.getData(1);
        if (this.parseErrorOrException(rmi, 3)) {
            this.log(I18n.getString("rmi.protocal.error"));
            return null;
        }
        return this.parseRemoteRefInternal(rmi, 4);
    }

    private RemoteRef parseRemoteRefInternal(TLV rmi, int offset) throws CardProxyException {
        try {
            if (RMIScript.isNullResponse(rmi, offset)) {
                return new RemoteRef();
            }
            int id = RMIScript.makeInt((byte)rmi.getData(offset), (byte)rmi.getData(offset + 1));
            String hash = new String(RMIScript.copyBytes(rmi, (offset += 2) + 1, rmi.getData(offset)), "UTF-8");
            offset += 1 + rmi.getData(offset);
            if (this.isClass) {
                String pack = new String(RMIScript.copyBytes(rmi, offset + 1, rmi.getData(offset)), "UTF-8");
                offset += 1 + rmi.getData(offset);
                String name = new String(RMIScript.copyBytes(rmi, offset + 1, rmi.getData(offset)), "UTF-8");
                RMIScript.check((offset += 1 + rmi.getData(offset)) == rmi.length, I18n.getString("response.incorrectly.extended"));
                return new RemoteRefWithClass(id, hash, pack, name);
            }
            int count = rmi.getData(offset++);
            String[][] interfaces = new String[count][2];
            for (int i = 0; i < count; ++i) {
                interfaces[i][0] = new String(RMIScript.copyBytes(rmi, offset + 1, rmi.getData(offset)), "UTF-8");
                offset += 1 + rmi.getData(offset);
                interfaces[i][1] = new String(RMIScript.copyBytes(rmi, offset + 1, rmi.getData(offset)), "UTF-8");
                offset += 1 + rmi.getData(offset);
            }
            return new RemoteRefWithInterfaces(id, hash, interfaces);
        }
        catch (UnsupportedEncodingException e) {
            throw new ScriptFailException(Status.error((String)I18n.getString("unsupported.utf.encoding")));
        }
    }

    private boolean parseErrorOrException(TLV rmi, int offset) throws CardProxyException {
        int type = rmi.getData(offset);
        switch (type) {
            case 129: {
                return false;
            }
            case 130: 
            case 131: {
                RMIScript.check(rmi.length == offset + 4, I18n.getString("invalid.exception.structure"));
                throw new ResponseException(type, rmi.getData(offset + 1), RMIScript.makeInt((byte)rmi.getData(offset + 2), (byte)rmi.getData(offset + 3)));
            }
            case 153: {
                RMIScript.check(rmi.length == offset + 3, I18n.getString("invalid.error.structure"));
                throw new ResponseException(153, 0, RMIScript.makeInt((byte)rmi.getData(offset + 1), (byte)rmi.getData(offset + 2)));
            }
        }
        RMIScript.check(false, I18n.getString("unknown.tag"));
        return false;
    }

    public static void check(boolean status, String mes) throws CardProxyException {
        if (!status) {
            throw new CardProxyException(mes);
        }
    }

    private static byte[] copyBytes(TLV rmi, int offset, int length) {
        RMIScript.debug(I18n.getString("tlv.tag.debug.info", new Object[]{Integer.toHexString(rmi.tag), Integer.toHexString(rmi.length), Integer.toHexString(offset), Integer.toHexString(length)}));
        byte[] dest = new byte[length];
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = (byte)rmi.getData(offset + i);
        }
        return dest;
    }

    private static boolean isNullResponse(TLV rmi, int offset) {
        return rmi.length == offset + 2 && rmi.getData(offset) == 255 && rmi.getData(offset + 1) == 255;
    }

    public static void debug(Object o) {
        Logger.global.log(Level.FINEST, "" + o);
    }
}

