/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.MultiTestScript;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.scripts.StdScript;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javatest.Status;
import java.io.PrintWriter;

public abstract class MultiStdScript
extends StdScript
implements MultiTestScript {
    public static final short SW_SELECT_PASSED = -28672;
    protected String[] cases;

    public abstract Status runTestCase(int var1, String var2) throws CardProxyException;

    @Override
    public int getTestCaseCount() {
        return this.cases == null ? 0 : this.cases.length;
    }

    public MultiStdScript(String[] cases) {
        this.cases = cases;
    }

    @Override
    public Status runScript() throws CardProxyException {
        Status retVal = Status.passed((String)"");
        for (int id = 1; id <= this.getTestCaseCount(); ++id) {
            Status current;
            String name = this.cases[id - 1];
            if (!this.checkTestCase(name)) continue;
            try {
                this.log(I18n.getString("start.testcase", name));
                current = this.runTestCase(id, this.cardService, this.out, this.ref);
            }
            catch (ScriptFailException e) {
                current = e.getStatus();
            }
            this.log(I18n.getString("testcase.id", new Integer(id), current));
            retVal = current.isPassed() ? retVal : current;
        }
        return retVal;
    }

    protected void startTestCase() throws CardProxyException {
        this.select(this.args.getExecuteClass(), (short)-28672);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status runTestCase(int index, CJCKCardService cardService, PrintWriter out, PrintWriter ref) throws CardProxyException {
        this.init(cardService, out, ref);
        String name = this.cases[index - 1];
        if (!this.checkTestCase(name)) {
            return Status.passed((String)I18n.getString("test.been.excluded"));
        }
        cardService.powerUp();
        try {
            Status current;
            this.startTestCase();
            try {
                this.log(I18n.getString("start.testcase", name));
                current = this.runTestCase(index, name);
            }
            catch (ScriptFailException e) {
                current = e.getStatus();
            }
            this.log(I18n.getString("testcase.id", Integer.toHexString(index), current));
            Status status = current;
            return status;
        }
        finally {
            cardService.powerDown();
        }
    }
}

