/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.I18n;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LoggingClient {
    public static final String MESSAGES_RESOURCE = "com/sun/tck/logging/messages.properties";
    public static final String MESSAGE_PREFIX = "Message.value.";
    public static final String FILE_PREFIX = "File.";
    public static final String EXCEPTION_PREFIX = "Exception.";
    public static final String UNKNOWN = "UNKNOWN";
    public static final byte CLA_JCRE_TEST = -128;
    public static final byte INS_DO_TESTS = 32;
    public static final byte NULL_TAG = 0;
    public static final byte BYTE_TAG = 1;
    public static final byte BOOLEAN_TAG = 2;
    public static final byte SHORT_TAG = 3;
    public static final byte EXCEPTION_TAG = 5;
    public static final byte REF_TAG = 6;
    public static final byte VALUE_TAG = 7;
    public static final byte ARRAY_MASK = -128;
    public static final short EXCEPTION = 5;
    public static final short CARD_EXCEPTION = 33;
    public static final short CARD_RUNTIME_EXCEPTION = 34;
    public Properties messages = new Properties();
    private boolean isDebug = true;
    private PrintWriter out;
    private PrintWriter ref;
    private static HashMap exceptions = new HashMap();

    public LoggingClient(PrintWriter out, PrintWriter ref) {
        this.out = out;
        this.ref = ref;
        ClassLoader loader = this.getClass().getClassLoader();
        loader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
        try {
            this.messages.load(loader.getResourceAsStream(MESSAGES_RESOURCE));
        }
        catch (IOException e) {
            this.ref(I18n.getString("can.not.load.messages", MESSAGES_RESOURCE, e));
        }
    }

    public void setDebugMode(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void ref(String message) {
        this.out.println(message);
        this.ref.println(message);
    }

    private String getMessageHeader(int id) {
        return id == 0 ? UNKNOWN : this.messages.getProperty(MESSAGE_PREFIX + id);
    }

    public void parseLog(byte[] data) {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ArrayList<Message> messages = new ArrayList<Message>();
        HashMap<Integer, Object> values = new HashMap<Integer, Object>();
        try {
            while (in.available() > 0) {
                int message_id = this.readShort(in);
                if (message_id == 65535) {
                    values.put(new Integer(in.read()), this.readParam(in));
                    continue;
                }
                int argCount = in.read();
                Object[] args = new Object[argCount];
                Message msg = new Message(this.getDebugHeader(message_id), this.getMessageHeader(message_id), args);
                messages.add(msg);
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this.readParam(in);
                }
            }
            for (Message current : messages) {
                current.resolve(values);
                this.ref("  " + current.toString().replaceAll("\n", "\n  "));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ref(I18n.getString("can.not.parse.log", e));
        }
    }

    private String getDebugHeader(int message_id) {
        StringBuffer retVal = new StringBuffer("Message");
        if (this.isDebug) {
            retVal.append(" from ");
            retVal.append(this.messages.getProperty("Message.file." + message_id));
            retVal.append(':');
            retVal.append(this.messages.getProperty("Message.line." + message_id));
            retVal.append(":\n");
        } else {
            retVal.append(": ");
        }
        return retVal.toString();
    }

    private Object readParam(ByteArrayInputStream in) throws IOException {
        int tag = in.read();
        boolean len = false;
        switch (tag & 0xFF) {
            case 0: {
                return null;
            }
            case 1: {
                return new Byte((byte)in.read());
            }
            case 2: {
                return new Boolean(in.read() != 0);
            }
            case 3: {
                return new Short((short)this.readShort(in));
            }
            case 5: {
                return this.createException((short)this.readShort(in), (short)this.readShort(in), (short)this.readShort(in), (short)this.readShort(in));
            }
            case 129: {
                return this.readByteArray(in, this.readShort(in), true);
            }
            case 130: {
                return this.readBooleanArray(in, this.readShort(in));
            }
            case 131: {
                return this.readShortArray(in, this.readShort(in), true);
            }
            case 6: {
                return new Reference(in.read());
            }
        }
        return null;
    }

    private String readBooleanArray(InputStream in, int len) throws IOException {
        StringBuffer retVal = new StringBuffer("boolean[");
        retVal.append(Integer.toString(len));
        retVal.append("] {");
        for (int pos = 0; pos < len; ++pos) {
            retVal.append(in.read() == 0 ? "false" : "true");
            if (pos >= len - 1) continue;
            retVal.append(", ");
        }
        retVal.append('}');
        return retVal.toString();
    }

    private String readByteArray(InputStream in, int len, boolean isHex) throws IOException {
        StringBuffer retVal = new StringBuffer("byte[");
        retVal.append(Integer.toString(len));
        retVal.append("] {");
        for (int pos = 0; pos < len; ++pos) {
            if (isHex) {
                retVal.append("0x");
                retVal.append(Integer.toHexString(in.read()));
            } else {
                retVal.append(Integer.toString(in.read()));
            }
            if (pos >= len - 1) continue;
            retVal.append(", ");
        }
        retVal.append('}');
        return retVal.toString();
    }

    private String readShortArray(InputStream in, int len, boolean isHex) throws IOException {
        StringBuffer retVal = new StringBuffer("short[] {");
        for (int pos = 0; pos < len; ++pos) {
            if (isHex) {
                retVal.append("0x");
                retVal.append(Integer.toHexString(this.readShort(in)));
            } else {
                retVal.append(Integer.toString(this.readShort(in)));
            }
            if (pos >= len - 1) continue;
            retVal.append(", ");
        }
        retVal.append('}');
        return retVal.toString();
    }

    private int readShort(InputStream in) throws IOException {
        return in.read() << 8 | in.read();
    }

    private String createException(short excpType, short reason, short file, short line) {
        return this.getExceptionName(excpType) + "(reason=0x" + Integer.toHexString(reason & 0xFFFF) + ", in " + this.getFileName(file) + " at line " + (line & 0xFFFF) + ")";
    }

    private String getFileName(short id) {
        return id == 0 ? UNKNOWN : (String)this.messages.get(FILE_PREFIX + (id & 0xFFFF));
    }

    private String getExceptionName(int excpType) {
        String retVal = (String)exceptions.get(new Integer(excpType &= 0xFFFF));
        if (retVal == null) {
            retVal = this.messages.getProperty(EXCEPTION_PREFIX + excpType);
        }
        return retVal;
    }

    static {
        exceptions.put(new Integer(1), "java.lang.ArithmeticException");
        exceptions.put(new Integer(2), "java.lang.ArrayIndexOutOfBoundsException");
        exceptions.put(new Integer(3), "java.lang.ArrayStoreException");
        exceptions.put(new Integer(4), "java.lang.ClassCastException");
        exceptions.put(new Integer(6), "java.lang.IndexOutOfBoundsException");
        exceptions.put(new Integer(7), "java.lang.NegativeArraySizeException");
        exceptions.put(new Integer(8), "java.lang.NullPointerException");
        exceptions.put(new Integer(10), "java.lang.SecurityException");
        exceptions.put(new Integer(11), "java.io.IOException");
        exceptions.put(new Integer(12), "java.rmi.RemoteException");
        exceptions.put(new Integer(32), "javacard.framework.APDUException");
        exceptions.put(new Integer(35), "javacard.framework.ISOException");
        exceptions.put(new Integer(36), "javacard.framework.PINException");
        exceptions.put(new Integer(37), "javacard.framework.SystemException");
        exceptions.put(new Integer(38), "javacard.framework.TransactionException");
        exceptions.put(new Integer(39), "javacard.framework.UserException");
        exceptions.put(new Integer(48), "javacard.security.CryptoException");
        exceptions.put(new Integer(64), "javacard.framework.service.ServiceException");
        exceptions.put(new Integer(33), "javacard.framework.CardException");
        exceptions.put(new Integer(34), "javacard.framework.CardRuntimeException");
        exceptions.put(new Integer(9), "java.lang.RuntimeException");
        exceptions.put(new Integer(5), "java.lang.Exception");
        exceptions.put(new Integer(255), "java.lang.Throwable");
        exceptions.put(new Integer(254), UNKNOWN);
    }

    private static class Reference {
        int ref;

        public Reference(int ref) {
            this.ref = ref;
        }

        int getRef() {
            return this.ref;
        }
    }

    private static class Message {
        private String debugHeader;
        private String format;
        private Object[] args;

        public Message(String debugHeader, String message, Object[] args) {
            this.format = message;
            this.args = args;
            this.debugHeader = debugHeader;
        }

        public void resolve(Map values) {
            for (int i = 0; i < this.args.length; ++i) {
                if (!(this.args[i] instanceof Reference)) continue;
                Reference ref = (Reference)this.args[i];
                this.args[i] = values.get(new Integer(ref.getRef()));
            }
        }

        public String toString() {
            try {
                return this.format == LoggingClient.UNKNOWN ? this.getInternalRepresentation("") : this.debugHeader + MessageFormat.format(this.format, this.args);
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.getInternalRepresentation("Broken message:");
            }
        }

        private String getInternalRepresentation(String type) {
            StringBuffer retVal = new StringBuffer(this.debugHeader);
            retVal.append(type);
            retVal.append("Format=");
            retVal.append(this.format);
            retVal.append(" Args(");
            retVal.append(this.args.length);
            retVal.append(")=(");
            for (int i = 0; i < this.args.length; ++i) {
                retVal.append(" \"");
                retVal.append(this.args[i].toString());
                retVal.append('\"');
            }
            retVal.append(" )");
            return retVal.toString();
        }
    }
}

