/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.MultiTestScript;
import com.sun.javacard.cjck.scripts.StdScript;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javatest.Status;
import java.io.PrintWriter;

public class LegacyDoTestScript
extends StdScript
implements MultiTestScript {
    public static final short SW_DO_TEST_PASSED = -25856;
    public static final short SW_SELECT_PASSED = -28672;
    protected int testCount;
    private boolean[] status;
    private String executeClass;
    private int[][] cases;

    public LegacyDoTestScript() {
    }

    public LegacyDoTestScript(int testCount, ConfigFileReader configFile, String executeClass) {
        this.setConfigFileReader(configFile);
        this.testCount = testCount;
        this.executeClass = executeClass;
        this.status = new boolean[testCount];
    }

    @Override
    public void setArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (i + 1 >= args.length) continue;
            if (args[i].equals("-testCount")) {
                this.testCount = Integer.parseInt(args[++i]);
                continue;
            }
            if (!args[i].equals("-executeClass")) continue;
            this.executeClass = args[++i];
        }
        this.status = this.status == null ? new boolean[this.testCount] : this.status;
    }

    @Override
    public String getName() {
        return I18n.getString("legacydotest.script.count", new Integer(this.testCount));
    }

    @Override
    public Status runScript() throws CardProxyException {
        this.log(I18n.getString("process.default.script"));
        Status retVal = Status.passed((String)"");
        for (int i = 0; i < this.getTestCaseCount(); ++i) {
            Status current = this.runTestCase(i, this.cardService, this.out, this.ref);
            retVal = current.isPassed() ? retVal : current;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status runTestCase(int index, CJCKCardService cardService, PrintWriter out, PrintWriter ref) throws CardProxyException {
        this.init(cardService, out, ref);
        byte[] cleanUp = new byte[]{-128, 32, 0, 0, 1, 0, 1};
        if (this.status[index - 1]) {
            return Status.passed((String)I18n.getString("status.excluded"));
        }
        cardService.powerUp();
        this.log(I18n.getString("script.auto.generated"));
        this.select(this.executeClass, (short)-28672);
        try {
            this.executeTestCase(index);
        }
        finally {
            this.sendAPDU(new CommandAPDU(cleanUp), (short)-25856);
            cardService.powerDown();
        }
        return Status.passed((String)"");
    }

    @Override
    public int getTestCaseCount() {
        return this.testCount;
    }

    @Override
    public void setExcludeEntries(String[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].length() <= 0 || !Character.isDigit(entries[i].charAt(0))) continue;
            this.addExcludedNumber(this.parseInt(entries[i], "-exclude"));
        }
    }

    private int parseInt(String value, String name) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(I18n.getString("not.valid.integer", name, value, e));
        }
    }

    private void addExcludedNumber(int pos) {
        if (pos < 0 || pos > this.status.length) {
            throw new IllegalArgumentException(I18n.getString("invalid.excluded.test", new Integer(pos)));
        }
        this.status[pos - 1] = true;
    }

    protected void executeTestCase(int testcase) throws CardProxyException {
        byte[] data = new byte[]{-128, 32, 0, 0, 1, (byte)testcase, 1};
        this.sendAPDU(new CommandAPDU(data), (short)-25856);
    }
}

