/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.scripts.Channel;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.scripts.StdScript;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class LCScript
extends StdScript {
    public static final int MAX_CHANNEL_NUMBER = 19;
    public static final int TYPE16_MASK = 64;
    public static final int PROPRIETARY_MASK = 128;
    public static final int NOT_LAST_MASK = 16;
    public static final byte MANAGE_CHANNEL_INS = 112;
    public static final byte SELECT_INS = -92;
    public static final byte SELECTION_BY_DF_NAME_P1 = 4;
    public static final byte CHANNEL_OPEN_P1 = 0;
    public static final byte CHANNEL_CLOSE_P1 = -128;
    protected static final short SW_PASSED = -25856;
    private int currentChannel;

    public ResponseAPDU manageChannelClose(int from, int to) throws CardProxyException {
        return this.manageChannelClose(from, to, 0);
    }

    public ResponseAPDU manageChannelClose(int from, int to, int le) throws CardProxyException {
        this.log(I18n.getString("start.managechannelclose", Integer.toHexString(from), Integer.toHexString(to), new Integer(le)));
        byte CLA = LCScript.getInterindustryChannelCLA(from);
        LCScript.checkChannel(to);
        CommandAPDU capdu = new CommandAPDU(CLA, 112, -128, (byte)to, new byte[0], le);
        return this.sendAPDU(capdu);
    }

    public Channel manageChannelOpen(int from, int to) throws CardProxyException {
        return this.manageChannelOpen(from, to, to == 0 ? 1 : 0);
    }

    public Channel manageChannelOpen(int from, int to, int le) throws CardProxyException {
        this.log(I18n.getString("start.managechannelopen", Integer.toHexString(from), Integer.toHexString(to), new Integer(le)));
        byte CLA = LCScript.getInterindustryChannelCLA(from);
        LCScript.checkChannel(to);
        CommandAPDU capdu = new CommandAPDU(CLA, 112, 0, (byte)to, new byte[0], le);
        ResponseAPDU answer = this.sendAPDU(capdu);
        int id = -1;
        if ((answer.sw() & 0xFFFF) == 36864) {
            if (to != 0) {
                id = to;
            } else if (answer.getLe() > 0) {
                id = answer.getData(0);
            } else {
                throw new ScriptFailException(I18n.getString("managechannel.open.no.data"));
            }
        }
        return new Channel(id, answer);
    }

    public Channel selectFile(String name, byte channel, byte le) throws CardProxyException {
        return this.selectFile(this.findApplet(name), channel, le);
    }

    public Channel selectFile(String name, byte channel) throws CardProxyException {
        return this.selectFile(this.findApplet(name), channel, this.DEFAULT_LE);
    }

    private Channel selectFile(AppletProperties applet, byte channel, byte le) throws CardProxyException {
        this.log(I18n.getString("start.select.file", applet.getClassName(), new Byte(channel)));
        byte CLA = LCScript.getInterindustryChannelCLA(channel);
        CommandAPDU capdu = new CommandAPDU(CLA, -92, 4, 0, applet.getAID().getBytes(), le);
        return new Channel(channel, this.sendAPDU(capdu));
    }

    public static byte getInterindustryChannelCLA(int channel) {
        LCScript.checkChannel(channel);
        if (channel < 4) {
            return (byte)channel;
        }
        return (byte)(0x40 | channel - 4);
    }

    protected static byte getInterindustryChannelCLA(int channel, boolean lastCommandInChain) {
        LCScript.checkChannel(channel);
        if (channel < 4) {
            return (byte)(lastCommandInChain ? 0 : 0x10 | channel);
        }
        return (byte)(0x40 | (lastCommandInChain ? 0 : 16) | channel - 4);
    }

    protected static byte getSecureInterindustryChannelCLA(int channel, boolean lastCommandInChain, int securityMask) {
        LCScript.checkChannel(channel);
        if (channel < 4) {
            if ((securityMask & 0xC) != securityMask) {
                throw new IllegalArgumentException(I18n.getString("incorrect.secure.mask.type4", Integer.toHexString(securityMask)));
            }
            return (byte)((lastCommandInChain ? 0 : 16) | securityMask | channel);
        }
        if ((securityMask & 0x20) != securityMask) {
            throw new IllegalArgumentException(I18n.getString("incorrect.secure.mask.type16", Integer.toHexString(securityMask)));
        }
        return (byte)(0x40 | (lastCommandInChain ? 0 : 16) | securityMask | channel - 4);
    }

    protected static byte getProprietaryChannelCLA(int channel) {
        LCScript.checkChannel(channel);
        if (channel < 4) {
            return (byte)(0x80 | channel);
        }
        return (byte)(0xC0 | channel - 4);
    }

    protected static byte getProprietaryChannelCLA(int channel, boolean lastCommandInChain) {
        LCScript.checkChannel(channel);
        if (channel < 4) {
            return (byte)(0x80 | (lastCommandInChain ? 0 : 16) | channel);
        }
        return (byte)(0xC0 | (lastCommandInChain ? 0 : 16) | channel - 4);
    }

    protected static byte getSecureProprietaryChannelCLA(int channel, boolean lastCommandInChain, int securityMask) {
        LCScript.checkChannel(channel);
        if (channel < 4) {
            if ((securityMask & 0xC) != securityMask) {
                throw new IllegalArgumentException(I18n.getString("incorrect.secure.mask.type4", Integer.toHexString(securityMask)));
            }
            return (byte)(0x80 | (lastCommandInChain ? 0 : 16) | securityMask | channel);
        }
        if ((securityMask & 0x20) != securityMask) {
            throw new IllegalArgumentException(I18n.getString("incorrect.secure.mask.type16", Integer.toHexString(securityMask)));
        }
        return (byte)(0xC0 | (lastCommandInChain ? 0 : 16) | securityMask | channel - 4);
    }

    protected static void checkChannel(int channel) {
        if (channel > 19 || channel < 0) {
            throw new IllegalArgumentException(I18n.getString("incorrect.channel.number", new Integer(channel), new Integer(19)));
        }
    }

    protected byte[] getAvailableChannels(String appletName) throws CardProxyException {
        ArrayList<Byte> channels = new ArrayList<Byte>(20);
        for (int channel = 0; channel <= 19; ++channel) {
            short status = this.selectFile(appletName, (byte)channel, (byte)0).getSWStatus();
            if (status == 26753) {
                this.log("Logical channel number: " + channel + " is not supported by JCRE");
                continue;
            }
            if (status != -28672) {
                this.log("Failed to open logical channel number: " + channel);
                this.logIncorrectResponse("SELECT FILE", -28672, status);
                continue;
            }
            channels.add(new Byte((byte)channel));
        }
        byte[] retValue = new byte[channels.size()];
        for (int i = 0; i < retValue.length; ++i) {
            retValue[i] = (Byte)channels.get(i);
        }
        this.log("JCRE supports following logical channels: " + Arrays.toString(retValue));
        return retValue;
    }

    protected void sendManageChannelOpen(int fromChannel, int toChannel) throws CardProxyException {
        this.sendManageChannelOpen(fromChannel, toChannel, (short)-28672);
    }

    protected void sendManageChannelOpen(int fromChannel, int toChannel, short expectedStatus) throws CardProxyException {
        Channel result = this.manageChannelOpen(fromChannel, toChannel, toChannel == 0 ? 1 : 0);
        short status = result.getSWStatus();
        if (status != expectedStatus) {
            String msg = I18n.getString("lcscript.openchannel.fail", Integer.toString(toChannel), Integer.toHexString(0xFFFF & expectedStatus), Integer.toHexString(0xFFFF & status));
            this.log(msg);
            throw new ScriptFailException(msg);
        }
    }

    protected void sendSelectFile(String name, byte channel) throws CardProxyException {
        this.sendSelectFile(name, channel, (short)-28672, this.DEFAULT_LE);
    }

    protected void sendSelectFile(String name, byte channel, short expectedStatus, byte le) throws CardProxyException {
        Channel result = this.selectFile(this.findApplet(name), channel, le);
        short status = result.getSWStatus();
        if (status != expectedStatus) {
            String msg = I18n.getString("lcscript.selectchannel.fail", Integer.toString(channel), Integer.toHexString(0xFFFF & expectedStatus), Integer.toHexString(0xFFFF & status));
            this.log(msg);
            throw new ScriptFailException(msg);
        }
    }

    protected void sendSelectFile(String name, byte channel, short expectedStatus) throws CardProxyException {
        this.sendSelectFile(name, channel, expectedStatus, this.DEFAULT_LE);
    }

    protected void sendManageChannelClose(int fromChannel, int toChannel) throws CardProxyException {
        this.sendManageChannelClose(fromChannel, toChannel, (short)-28672);
    }

    protected void sendManageChannelClose(int fromChannel, int toChannel, short expectedStatus) throws CardProxyException {
        ResponseAPDU result = this.manageChannelClose(fromChannel, toChannel, 0);
        short status = (short)result.sw();
        if (status != expectedStatus) {
            String msg = I18n.getString("lcscript.closechannel.fail", Integer.toString(toChannel), Integer.toHexString(0xFFFF & expectedStatus), Integer.toHexString(0xFFFF & status));
            this.log(msg);
            throw new ScriptFailException(msg);
        }
    }

    protected void logIncorrectResponse(String command, int expectedStatus, int receivedStatus) {
        this.log(I18n.getString("lcscript.incorrect.response", command, Integer.toHexString(0xFFFF & expectedStatus), Integer.toHexString(0xFFFF & receivedStatus)));
    }
}

