/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardProxyArguments;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.scripts.StdScript;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.CommunicationService;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class DualInterfaceScript
extends StdScript {
    public static final byte CLA_JCRE_TEST = -128;
    public static final byte INS_DO_TEST = 32;
    public static final short SW_OK = -25856;
    public static final short SW_SELECT_PASSED = -28672;
    protected CommunicationService contactedService;
    protected CommunicationService contactlessService;
    protected static byte GET_RESPONSE_CLA_BYTE_CONTACTLESS = 0;

    @Override
    protected void init(CJCKCardService cardService, PrintWriter out, PrintWriter ref) {
        super.init(cardService, out, ref);
        this.contactedService = cardService;
        try {
            this.contactlessService = cardService.getCommunicationService(2);
        }
        catch (CardProxyException e) {
            throw new ScriptFailException(I18n.getString("no.contactless.interface"));
        }
    }

    public void sendAPDUContactless(CommandAPDU apdu, short expectedResponse) throws CardProxyException {
        ++this.apduCount;
        ResponseAPDU answer = this.sendAPDUContactless(apdu);
        int sw = answer.sw();
        if ((sw & 0xFFFF) != (0xFFFF & expectedResponse)) {
            this.logContactless(I18n.getString("incorrect.response", new Integer(this.apduCount), Integer.toHexString(0xFFFF & expectedResponse), Integer.toHexString(0xFFFF & sw)));
            throw new ScriptFailException(I18n.getString("incorrect.response.1", new Integer(this.apduCount)));
        }
    }

    public ResponseAPDU sendAPDUContactless(CommandAPDU apdu) throws CardProxyException {
        ++this.apduCount;
        ResponseAPDU answer2 = this.contactlessService.sendAPDU(apdu);
        int sw = answer2.sw();
        if ((sw & 0xFF00) != 24832) {
            return answer2;
        }
        ArrayList<ResponseAPDU> list = new ArrayList<ResponseAPDU>();
        int length = 0;
        while ((sw & 0xFF00) == 24832 || (sw & 0xFF00) == 25088) {
            list.add(answer2);
            length += answer2.getLe();
            answer2 = this.contactlessService.sendAPDU(this.getGetResponseAPDUContactless(apdu.getCLA(), sw));
            sw = answer2.sw();
        }
        list.add(answer2);
        byte[] data = new byte[(length += answer2.getLe()) + 2];
        int offset = 0;
        for (ResponseAPDU answer2 : list) {
            for (int i = 0; i < answer2.getLe(); ++i) {
                data[offset++] = (byte)answer2.getData(i);
            }
        }
        data[offset++] = (byte)(sw >> 8);
        data[offset++] = (byte)sw;
        return new ResponseAPDU(data);
    }

    public void select(AppletProperties applet, short expected) throws CardProxyException {
        this.log(I18n.getString("start.select.applet", applet.getClassName(), Integer.toHexString(expected)));
        this.sendAPDU(new CommandAPDU(0, -92, 4, 0, applet.getAID().getBytes(), this.DEFAULT_LE), expected);
    }

    public void selectContactless(String name, short expected) throws CardProxyException {
        this.selectContactless(this.findApplet(name), expected);
    }

    public void selectContactless(String name) throws CardProxyException {
        this.logContactless(I18n.getString("try.select.applet", name));
        this.selectContactless(this.findApplet(name), (short)-25856);
    }

    public void selectContactless(AppletProperties applet, short expected) throws CardProxyException {
        this.logContactless(I18n.getString("start.select.applet", applet.getClassName(), Integer.toHexString(expected)));
        this.sendAPDUContactless(new CommandAPDU(0, -92, 4, 0, applet.getAID().getBytes(), this.DEFAULT_LE), expected);
    }

    @Override
    public void setCardProxyArguments(CardProxyArguments arguments) {
        this.args = arguments;
        GET_RESPONSE_CLA_BYTE_CONTACTLESS = arguments.getGET_RESPONSE_CLA_BYTE();
    }

    private CommandAPDU getGetResponseAPDUContactless(byte original_cla, int sw) {
        return new CommandAPDU(new byte[]{(byte)(GET_RESPONSE_CLA_BYTE_CONTACTLESS & 0xF0 | original_cla & 0xF), -64, 0, 0, (byte)sw});
    }

    protected void logContactless(Object o) {
        this.out.print("CONTACTLESS: ");
        super.log(o);
    }

    public void sendDoTest(int testCase) throws CardProxyException {
        this.sendDoTest(testCase, (byte)0);
    }

    public void sendDoTest(int testCase, byte channel) throws CardProxyException {
        this.sendDoTest(testCase, channel, (short)-25856);
    }

    public void sendDoTest(int testCase, byte channel, short expected) throws CardProxyException {
        this.sendAPDU(this.getDoTestAPDU(testCase, channel), expected);
    }

    public void sendDoTestContactless(int testCase) throws CardProxyException {
        this.sendDoTestContactless(testCase, (byte)0);
    }

    public void sendDoTestContactless(int testCase, byte channel, short expected) throws CardProxyException {
        this.sendAPDUContactless(this.getDoTestAPDU(testCase, channel), expected);
    }

    public void sendDoTestContactless(int testCase, byte channel) throws CardProxyException {
        this.sendDoTestContactless(testCase, channel, (short)-25856);
    }

    public CommandAPDU getDoTestAPDU(int testCase) {
        return this.getDoTestAPDU(testCase, (byte)0);
    }

    public CommandAPDU getDoTestAPDU(int testCase, byte channel) {
        byte cla = (byte)(this.getChannelCLA(channel) | 0xFFFFFF80);
        return new CommandAPDU(cla, 32, 0, 0, new byte[]{(byte)testCase}, 127);
    }

    public void select(AppletProperties applet, byte channel, short expectedSW) throws CardProxyException {
        this.log(I18n.getString("start.select.applet", applet.getClassName(), Integer.toHexString(expectedSW)));
        this.sendAPDU(this.getSelectAPDU(applet, channel), expectedSW);
    }

    public void selectContactless(AppletProperties applet, byte channel, short expectedSW) throws CardProxyException {
        this.log(I18n.getString("start.select.applet", applet.getClassName(), Integer.toHexString(expectedSW)));
        this.sendAPDUContactless(this.getSelectAPDU(applet, channel), expectedSW);
    }

    public byte getChannelCLA(byte channel) {
        if (channel < 0) {
            throw new IllegalArgumentException(I18n.getString("negative.channel.exception"));
        }
        if (channel > 19) {
            throw new IllegalArgumentException(I18n.getString("notsupported.channel.number"));
        }
        if (channel < 4) {
            return channel;
        }
        return (byte)(0x40 & (byte)(channel - 4));
    }

    public CommandAPDU getSelectAPDU(AppletProperties applet, byte channel) {
        return new CommandAPDU(this.getChannelCLA(channel), -92, 4, 0, applet.getAID().getBytes(), this.DEFAULT_LE);
    }

    public void manageChannelClose(byte from, byte to) throws CardProxyException {
        this.log(I18n.getString("start.managechannelclose", Integer.toHexString(from), Integer.toHexString(to), new Byte(0)));
        this.sendAPDU(this.getManageChannelCloseAPDU(from, to), (short)-28672);
    }

    public void manageChannelCloseContactless(byte from, byte to) throws CardProxyException {
        this.logContactless(I18n.getString("start.managechannelclose", Integer.toHexString(from), Integer.toHexString(to), new Byte(0)));
        this.sendAPDUContactless(this.getManageChannelCloseAPDU(from, to), (short)-28672);
    }

    public CommandAPDU getManageChannelCloseAPDU(byte from, byte to) {
        byte cla = this.getChannelCLA(from);
        return new CommandAPDU(new byte[]{cla, 112, -128, to});
    }
}

