/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.ArgumentParser;
import com.sun.javacard.cjck.invoke.CardProxyArguments;
import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.RunMode;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javatest.Status;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConvertMode
extends RunMode {
    @Override
    public String getName() {
        return "ConvertMode";
    }

    @Override
    public Status run(CardProxyArguments args, ConfigFileReader configFile) throws CardProxyException {
        this.log(I18n.getString("call.convertpackage", this.getName()));
        Enumeration e = configFile.getPackages();
        while (e.hasMoreElements()) {
            String packageName = (String)e.nextElement();
            if (args.doConversion(packageName)) {
                AppletID packageAID = configFile.getPackageAID(packageName);
                AppletProperties[] uniq = this.getUnig(configFile.getApplets(packageName));
                this.log(I18n.getString("start.convert.package", this.getName(), packageName, packageAID));
                String version = configFile.getPackageVersion(packageName);
                int majorversion = args.getMajorVersion();
                int minorversion = args.getMinorVersion();
                if (version != null) {
                    majorversion = ConvertMode.parseMajorVersion(version);
                    minorversion = ConvertMode.parseMinorVersion(version);
                }
                String capFile = this.cardService.convertPackage(packageName, packageAID, majorversion, minorversion, args.getClassDir(), args.getExportDir(), configFile.isExportMap(packageName), args.getOutputDir(), configFile.getApplets(packageName));
                this.log(I18n.getString("convert.create.capfile", this.getName(), capFile));
                if (capFile == null) {
                    return Status.failed((String)I18n.getString("convert.return.null"));
                }
                if (!new File(capFile).exists()) {
                    return Status.failed((String)I18n.getString("convert.return.nonexist.file", capFile));
                }
                this.storeCapFile(capFile, args.getCapFileDir());
                this.log(I18n.getString("back.cardproxytest.run", this.getName(), capFile));
                continue;
            }
            this.log(I18n.getString("conversion.skipped", this.getName(), packageName));
        }
        return Status.passed((String)"");
    }

    private void storeCapFile(String capFileName, String path) throws CardProxyException {
        File oldDir;
        String base = ArgumentParser.getBasename(capFileName);
        String newName = path == null ? "" : path;
        File newDir = new File(newName);
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
        if (!newDir.equals(oldDir = new File(ArgumentParser.getBasename(capFileName)))) {
            File newFile = new File(newDir + File.separator + base);
            newFile.delete();
            this.log(I18n.getString("movecapfile.from.to", this.getName(), capFileName, newDir + File.separator + base));
            if (!new File(capFileName).renameTo(newFile)) {
                this.log(I18n.getString("can.not.move.generated.capfile", this.getName()));
                throw new CardProxyException(I18n.getString("exception.can.not.move.capfile"));
            }
            this.log(I18n.getString("capfile.moved", this.getName()));
        }
    }

    private AppletProperties[] getUnig(AppletProperties[] apa) {
        Vector<AppletProperties> h = new Vector<AppletProperties>();
        Hashtable<String, String> names = new Hashtable<String, String>();
        if (apa == null) {
            return null;
        }
        for (int i = 0; i < apa.length; ++i) {
            String name = apa[i].getClassName();
            if (names.get(name) != null) continue;
            names.put(name, "ok");
            h.addElement(apa[i]);
        }
        return h.toArray(new AppletProperties[h.size()]);
    }

    private static int parseMajorVersion(String version) {
        String s = version.trim();
        int pos = s.indexOf(".");
        if (pos < 1) {
            throw new IllegalArgumentException(I18n.getString("can.not.parse.version"));
        }
        return Integer.parseInt(s.substring(0, pos));
    }

    private static int parseMinorVersion(String version) {
        String s = version.trim();
        int pos = s.indexOf(".");
        if (pos < 0 || pos > s.length() - 2) {
            throw new IllegalArgumentException(I18n.getString("can.not.parse.version"));
        }
        return Integer.parseInt(s.substring(pos + 1));
    }
}

