/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.BinaryToolService;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardService;
import com.sun.javacard.cjck.userinterface.CardSystemException;
import com.sun.javacard.cjck.userinterface.FatalException;
import com.sun.javacard.globalimpl.GPCardService;
import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.tck.bvtool.terminal.CardPresenceNotifier;
import com.sun.tck.bvtool.terminal.CardPresenceObserver;
import com.sun.tck.bvtool.terminal.CardTerminalFactory;
import com.sun.tck.bvtool.terminal.PCSCTerminalFactory;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import com.sun.tck.bvtool.terminal.TestTerminalFactory;
import com.sun.tck.jc.javatest.cmdui.CmdUserInteraction;
import com.sun.tck.jc.javatest.gui.GuiUserInteraction;
import com.sun.tck.jc.javatest.ui.UserInteraction;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;

public class CardServicesPool {
    public static final int TIMEOUT = 300;
    public static final int MAX_CONNECTION_ATTEMPTS = 3;
    private static final String DEFAULT_TERMINALS_FACTORY = "com.sun.tck.bvtool.terminal.PCSCTerminalFactory";
    private static int capacity = 0;
    private static State state = State.NON_INITIALIZED;
    private static String reason = null;
    private static final LinkedBlockingQueue<StatefulCardTerminal> terminalsQueue = new LinkedBlockingQueue();
    private static Vector<String> terminalLabels = new Vector();
    private static List<StatefulCardTerminal> availableTerminals = new ArrayList<StatefulCardTerminal>();
    private static UserInteraction ui;
    private static boolean isObserverRegistered;
    private static boolean testRunStarted;
    private static Harness.Observer testRunObserver;

    private static boolean initTerminals() {
        try {
            String factoryName = CardServicesPool.getTerminalFactoryName();
            if (factoryName == null) {
                factoryName = DEFAULT_TERMINALS_FACTORY;
            }
            CardTerminalFactory factory = null;
            if (!DEFAULT_TERMINALS_FACTORY.equals(factoryName)) {
                ui = CmdUserInteraction.getUserInteraction();
                factory = new TestTerminalFactory();
            } else {
                ui = GuiUserInteraction.getUserInteraction();
                factory = new PCSCTerminalFactory();
            }
            List<CardTerminal> terminalsList = factory.terminals().list();
            if (terminalsList == null || terminalsList.isEmpty()) {
                state = State.NO_TERMINALS;
            } else {
                capacity = terminalsList.size();
                int i = 1;
                for (CardTerminal cad : terminalsList) {
                    terminalLabels.add(String.valueOf(i++));
                    availableTerminals.add(new StatefulCardTerminal(cad));
                }
                state = State.INITIALIZED;
            }
        }
        catch (CardException ex) {
            state = State.INITIALIZE_ERROR;
            reason = ex.toString();
        }
        return true;
    }

    public static int getCapacity() {
        return capacity;
    }

    public static Harness.Observer getTestRunObserver() {
        isObserverRegistered = true;
        return testRunObserver;
    }

    public static boolean isObserverRegistered() {
        return isObserverRegistered;
    }

    private static void releaseTerminals() {
        for (StatefulCardTerminal terminal : CardServicesPool.getAvailableTerminals()) {
            if (terminal.getLabel() == null) continue;
            CardServicesPool.releaseTerminal(terminal);
        }
        capacity = terminalsQueue.size();
    }

    private static void startIdleTerminalsMonitoring() {
        CardPresenceObserver observer = new CardPresenceObserver(){

            @Override
            public void notified(CardPresenceNotifier.CardEvent event) {
                StatefulCardTerminal srcTerminal = this.getSourceTerminal();
                if (event.equals((Object)CardPresenceNotifier.CardEvent.CARD_INSERTED)) {
                    srcTerminal.setState(StatefulCardTerminal.State.CARD_IDENTIFICATION_REQUIRED);
                } else if (event.equals((Object)CardPresenceNotifier.CardEvent.CARD_REMOVED)) {
                    srcTerminal.setState(StatefulCardTerminal.State.CREATED);
                }
            }
        };
        for (StatefulCardTerminal terminal : terminalsQueue) {
            terminal.addCardPresenceObserver(observer);
        }
    }

    private static void checkIdleTerminalsMonitoring() {
        for (StatefulCardTerminal terminal : terminalsQueue) {
            terminal.removeAllCardPresenceObservers();
            if (terminal.getState().equals((Object)StatefulCardTerminal.State.REPLACEMENT_REQUIRED)) {
                try {
                    CardServicesPool.requireReplacement(terminal, null);
                }
                catch (CardSystemException ex) {
                    terminal.setState(StatefulCardTerminal.State.INVALID);
                    terminalsQueue.remove(terminal);
                }
                continue;
            }
            if (!terminal.getState().equals((Object)StatefulCardTerminal.State.CARD_IDENTIFICATION_REQUIRED)) continue;
            terminalsQueue.remove(terminal);
            CardServicesPool.addTerminalToQueue(terminal);
            terminal.setState(StatefulCardTerminal.State.CREATED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinaryToolService getCardService(CardService realService, String[] args, PrintWriter log, PrintWriter ref) throws CardSystemException {
        GPCardService cardService = null;
        int count = 0;
        while (count++ < capacity) {
            try {
                StatefulCardTerminal terminal = null;
                LinkedBlockingQueue<StatefulCardTerminal> linkedBlockingQueue = terminalsQueue;
                synchronized (linkedBlockingQueue) {
                    terminal = terminalsQueue.poll(300L, TimeUnit.SECONDS);
                    if (terminal == null) {
                        throw new CardSystemException(I18n.getString("pool.waiting.timeout"));
                    }
                    cardService = new GPCardService();
                    cardService.setRealCardService((CJCKCardService)realService);
                    cardService.setCardTerminal(terminal);
                    cardService.init(args, log, ref);
                    CardServicesPool.checkCardServiceState(cardService);
                }
                if (cardService.getState() == StatefulCardTerminal.State.VERIFIED || cardService.getState() == StatefulCardTerminal.State.RECOVERED) break;
                cardService = null;
            }
            catch (InterruptedException ex) {
                throw new CardSystemException(I18n.getString("pool.waiting.interrupted", ex));
            }
        }
        if (cardService == null) {
            throw new CardSystemException("no.more.terminals.available");
        }
        return cardService;
    }

    public static void releaseTerminal(StatefulCardTerminal terminal) {
        if (terminal.getState() != StatefulCardTerminal.State.INVALID && !terminalsQueue.contains(terminal)) {
            terminalsQueue.offer(terminal);
        } else {
            --capacity;
        }
    }

    public static void checkState() throws CardSystemException {
        if (state == State.READY) {
            return;
        }
        if (state == State.INITIALIZED) {
            if (!CardServicesPool.identifyCardTerminals()) {
                throw new CardSystemException(I18n.getString("pool.not.identified"));
            }
        } else {
            if (state == State.NO_TERMINALS) {
                throw new CardSystemException(I18n.getString("pool.no.terminals"));
            }
            if (state == State.INITIALIZE_ERROR) {
                throw new CardSystemException(I18n.getString("pool.initialization.error", reason));
            }
            throw new CardSystemException(I18n.getString("pool.not.initialized"));
        }
        state = State.READY;
    }

    public static void requireReplacement(StatefulCardTerminal terminal, BinaryToolService cardService) throws CardSystemException {
        if (testRunStarted) {
            if (!ui.askForCardReplacement(terminal)) {
                if (cardService != null) {
                    CardServicesPool.replaceTerminal(terminal, cardService);
                }
            } else if (CardServicesPool.checkConnection(terminal)) {
                CardServicesPool.setCardID(terminal);
            } else if (cardService != null) {
                CardServicesPool.replaceTerminal(terminal, cardService);
            }
            terminal.setState(StatefulCardTerminal.State.CREATED);
            if (cardService != null) {
                CardServicesPool.checkCardServiceState(cardService);
            }
        } else {
            terminal.setState(StatefulCardTerminal.State.REPLACEMENT_REQUIRED);
        }
    }

    private static void replaceTerminal(StatefulCardTerminal terminal, BinaryToolService cardService) throws CardSystemException {
        terminal.setState(StatefulCardTerminal.State.INVALID);
        if (--capacity == 0) {
            throw new CardSystemException("no.more.terminals.available");
        }
        try {
            StatefulCardTerminal anotherTerminal = terminalsQueue.poll(300L, TimeUnit.SECONDS);
            if (anotherTerminal == null) {
                throw new FatalException(FatalException.Scope.CAD_SYSTEM, "no.more.terminals.available");
            }
            cardService.setCardTerminal(anotherTerminal);
        }
        catch (InterruptedException ex) {
            throw new CardSystemException(I18n.getString("pool.waiting.interrupted", ex));
        }
    }

    private static void checkCardServiceState(BinaryToolService cardService) throws CardSystemException {
        StatefulCardTerminal terminal = cardService.getCardTerminal();
        if (terminal.getState() == StatefulCardTerminal.State.CREATED) {
            if (cardService.initializeCardService() && cardService.validateCardService()) {
                terminal.setState(StatefulCardTerminal.State.VERIFIED);
            } else {
                terminal.setState(StatefulCardTerminal.State.REPLACEMENT_REQUIRED);
                CardServicesPool.requireReplacement(cardService.getCardTerminal(), cardService);
            }
        } else if (terminal.getState() == StatefulCardTerminal.State.VERIFIED) {
            try {
                if (!terminal.checkCardPresent()) {
                    CardServicesPool.requireReplacement(terminal, cardService);
                }
            }
            catch (CardSystemException ex) {
                terminal.setState(StatefulCardTerminal.State.REPLACEMENT_REQUIRED);
                CardServicesPool.requireReplacement(terminal, cardService);
            }
        }
    }

    private static void addTerminalToQueue(StatefulCardTerminal terminal) {
        try {
            if (CardServicesPool.checkConnection(terminal)) {
                CardServicesPool.setCardID(terminal);
                terminalsQueue.offer(terminal);
            } else {
                --capacity;
            }
        }
        catch (CardSystemException ex) {
            --capacity;
        }
    }

    private static void setCardID(StatefulCardTerminal terminal) throws CardSystemException {
        String cardID = ui.showCardIDSelectDialog(terminal.getLabel());
        if (!CardServicesPool.checkCardID(cardID)) {
            throw new CardSystemException(I18n.getString("card.id.incorrect", cardID));
        }
        terminal.setInsertedCardID(cardID);
    }

    public static List<StatefulCardTerminal> getAvailableTerminals() {
        return availableTerminals;
    }

    private static boolean identifyCardTerminals() throws CardSystemException {
        String terminalLabel;
        if (capacity == 1) {
            StatefulCardTerminal terminal = availableTerminals.get(0);
            terminalLabel = terminalLabels.elementAt(0);
            try {
                if (!terminal.isCardPresent()) {
                    ui.askForCardInsertion(terminalLabel, false);
                }
            }
            catch (CardException ex) {
                throw new CardSystemException(I18n.getString("pool.not.initialized"));
            }
            terminal.setLabel(terminalLabel);
            CardServicesPool.addTerminalToQueue(terminal);
        } else {
            StatefulCardTerminal identifiedTerminal;
            for (StatefulCardTerminal terminal : availableTerminals) {
                try {
                    if (!terminal.isCardPresent()) continue;
                    ui.askForCardsRemoval();
                }
                catch (CardException ex) {
                    throw new CardSystemException(I18n.getString("pool.initialization.error", ex.getMessage()));
                }
            }
            for (int i = 0; i < capacity && (identifiedTerminal = ui.askForCardInsertion(terminalLabel = terminalLabels.remove(0), false)) != null; ++i) {
                identifiedTerminal.setLabel(terminalLabel);
                CardServicesPool.addTerminalToQueue(identifiedTerminal);
            }
        }
        capacity = terminalsQueue.size();
        if (capacity < 1) {
            state = State.INITIALIZE_ERROR;
            return false;
        }
        for (StatefulCardTerminal terminal : terminalsQueue) {
            if (terminal.getLabel() != null && terminal.getInsertedCard() != null) continue;
            state = State.INITIALIZE_ERROR;
            return false;
        }
        return true;
    }

    private static boolean checkConnection(StatefulCardTerminal terminal) throws CardSystemException {
        int connectionAttempts = 0;
        boolean connectOK = false;
        while (!(connectOK = terminal.checkConnection()) && ++connectionAttempts < 3) {
            if (ui.askForRetryAfterFailedConnection(terminal.getLabel())) {
                if (ui.askForCardReplacement(terminal)) continue;
                throw new CardSystemException(I18n.getString("card.reinsertion.failed"));
            }
            return false;
        }
        return connectOK;
    }

    private static boolean checkCardID(String cardID) {
        return cardID != null;
    }

    private static String getTerminalFactoryName() {
        String root = CardServicesPool.getRootDir();
        if (root == null) {
            return DEFAULT_TERMINALS_FACTORY;
        }
        try {
            File file = new File(root + "/config.properties");
            if (!file.exists()) {
                return DEFAULT_TERMINALS_FACTORY;
            }
            Properties config = new Properties();
            config.load(new FileInputStream(file));
            return config.getProperty("TerminalFactoryClass");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getRootDir() {
        String classPath = System.getProperty("java.class.path");
        String[] elements = classPath.split(File.pathSeparator);
        String jarLocation = null;
        for (String element : elements) {
            if (element.indexOf(".jar") == -1) continue;
            jarLocation = (element = element.replace('/', File.separatorChar)).indexOf(File.separator) != -1 ? element.substring(0, element.lastIndexOf(File.separator)) : ".";
        }
        return jarLocation;
    }

    static {
        CardServicesPool.initTerminals();
        testRunObserver = new Harness.Observer(){

            public void startingTestRun(Parameters params) {
                testRunStarted = true;
                CardServicesPool.checkIdleTerminalsMonitoring();
            }

            public void startingTest(TestResult tr) {
            }

            public void finishedTest(TestResult tr) {
            }

            public void stoppingTestRun() {
                testRunStarted = false;
            }

            public void finishedTesting() {
            }

            public void finishedTestRun(boolean allOK) {
                testRunStarted = false;
                CardServicesPool.releaseTerminals();
                CardServicesPool.startIdleTerminalsMonitoring();
            }

            public void error(String string) {
            }
        };
    }

    public static enum State {
        NON_INITIALIZED,
        INITIALIZED,
        READY,
        NO_TERMINALS,
        INITIALIZE_ERROR;

    }
}

