/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardTest;
import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.Test;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import com.sun.jck.lib.Expr;
import com.sun.tck.jc.javatest.QueueTestRunner;
import com.sun.tck.jc.javatest.RerunnableTestDescription;
import java.io.PrintWriter;
import java.util.Set;

public class JCScript
extends Script {
    private static final String SCRIPT_ARGS_KEY = "ScriptArgs";
    private static final String SIGNATURE_TEST_KEYWORD = "signaturetest";
    private boolean install = false;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Script.class);
    private static final String DEFAULT_CONVERT_COMMAND = "convert";
    private static final String DEFAULT_INSTALL_COMMAND = "install";
    protected boolean negativeKey;

    public Status run(String[] arguments, TestDescription td, TestEnvironment env) {
        boolean checkErrors = false;
        boolean expectFail = false;
        boolean convert = false;
        boolean convertIndividually = false;
        String[] args = null;
        try {
            args = env.lookup(SCRIPT_ARGS_KEY);
            args = args == null ? new String[]{} : args;
        }
        catch (TestEnvironment.Fault e) {
            args = new String[]{};
            e.printStackTrace();
        }
        if (!this.isSelected(td, env)) {
            return Status.passed((String)I18n.getString("test.have.not.been.selected"));
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-convert") || arg.equals("-convertOnly")) {
                convert = true;
                continue;
            }
            if (arg.equals("-install")) {
                this.install = true;
                continue;
            }
            if (arg.equals("-expectFail")) {
                expectFail = true;
                continue;
            }
            if (arg.equals("-checkErrors")) {
                checkErrors = true;
                continue;
            }
            return Status.failed((String)I18n.getString("bad.arg.for.script.1", arg));
        }
        Set keys = td.getKeywordTable();
        this.negativeKey = keys.contains("negative");
        if (keys.contains(SIGNATURE_TEST_KEYWORD)) {
            return this.runSignatureTest(arguments, td, env);
        }
        if (convert) {
            String executeClass = td.getParameter("executeClass");
            Status convertStatus = this.convert(executeClass, td.getParameter("executeArgs"));
            if (!convertStatus.isPassed() && !convertStatus.isFailed()) {
                return convertStatus;
            }
            if (this.negativeKey) {
                switch (convertStatus.getType()) {
                    case 0: {
                        return Status.failed((String)I18n.getString("converter.passed.negative.test"));
                    }
                    case 1: {
                        return Status.passed((String)I18n.getString("converter.failed.as.expected"));
                    }
                }
            }
            if (!this.hasInstallKeyword(keys)) {
                return convertStatus;
            }
            if (!this.install) {
                if (expectFail) {
                    if (convertStatus.getType() == 1) {
                        if (checkErrors) {
                            return error_compFailUnexp.augment(convertStatus);
                        }
                        return pass_compFailExp.augment(convertStatus);
                    }
                    return fail_compSuccUnexp.augment(convertStatus);
                }
                return convertStatus;
            }
            if (convertStatus.getType() == 1) {
                return fail_compFailUnexp.augment(convertStatus);
            }
        }
        if (this.install) {
            String executeClass = td.getParameter("executeClass");
            if (executeClass == null) {
                return error_noExecuteClass;
            }
            Status executeStatus = this.install(executeClass, td.getParameter("executeArgs"));
            if (expectFail) {
                if (executeStatus.getType() == 1) {
                    return pass_execFailExp.augment(executeStatus);
                }
                return fail_execSuccUnexp.augment(executeStatus);
            }
            return executeStatus;
        }
        return error_noActionSpecified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runSignatureTest(String[] arguments, TestDescription td, TestEnvironment env) {
        String name = td.getParameter("executeClass");
        String args = td.getParameter("executeArgs");
        PrintWriter out = null;
        PrintWriter ref = null;
        TestResult.Section section = this.getTestResult().createSection("execute");
        try {
            String[] list = env.resolve(args);
            section.getMessageWriter().println(I18n.getString("script.command", new Object[]{name, StringArray.join((String[])list)}));
            out = section.createOutput(this.cmdOut1Name);
            ref = section.createOutput(this.cmdOut2Name);
            Test sigTest = (Test)Class.forName(name).newInstance();
            Status retVal = sigTest.run(list, out, ref);
            section.setStatus(retVal);
            Status status = retVal;
            return status;
        }
        catch (Exception e) {
            e.printStackTrace(this.trOut);
            Status retVal = Status.error((String)("Unexpected exception:" + e));
            section.setStatus(retVal);
            Status status = retVal;
            return status;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ref != null) {
                ref.close();
            }
        }
    }

    public Status convert(String executeClass, String executeArgs) {
        return this.execute(DEFAULT_CONVERT_COMMAND, executeClass, executeArgs);
    }

    public Status install(String executeClass, String executeArgs) {
        return this.execute(DEFAULT_INSTALL_COMMAND, executeClass, executeArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status invokeCommand(String key) {
        Status s = null;
        try {
            String[] command = this.env.lookup("command." + key);
            if (command.length == 0) {
                return Status.error((String)i18n.getString("script.noCommand", new Object[]{this.env.getName(), key}));
            }
            String className = command[0];
            String[] args = new String[command.length - 1];
            System.arraycopy(command, 1, args, 0, args.length);
            TestResult testResult = this.getTestResult();
            TestResult.Section section = testResult.createSection(key);
            section.getMessageWriter().println(i18n.getString("script.command", new Object[]{className, StringArray.join((String[])args)}));
            PrintWriter out1 = null;
            PrintWriter out2 = null;
            try {
                out1 = section.createOutput(this.cmdOut1Name);
                out2 = section.createOutput(this.cmdOut2Name);
                QueueTestRunner testRunner = QueueTestRunner.getTestRunner();
                testRunner.testStarted();
                boolean rerun = ((RerunnableTestDescription)this.td).isRerun();
                CardTest test = new CardTest(rerun, this);
                s = test.run(args, out1, out2);
                if (!s.isPassed() && test.getState() == CardTest.State.WAITING_FOR_RERUN) {
                    testRunner.returnToQueue(this.td);
                }
                if (rerun) {
                    ((RerunnableTestDescription)this.td).setRerunCompleted();
                }
                testRunner.testCompleted();
                out1.close();
                out2.close();
            }
            finally {
                if (out2 != null) {
                    out2.close();
                }
                if (out1 != null) {
                    out1.close();
                }
            }
            section.setStatus(s);
            return s;
        }
        catch (TestEnvironment.Fault e) {
            return Status.error((String)i18n.getString("script.badCommand", new Object[]{this.env.getName(), key}));
        }
    }

    public boolean isSelected(TestDescription td, TestEnvironment env) {
        try {
            String s = td.getParameter("selectIf");
            if (s == null || s.length() == 0) {
                return true;
            }
            Expr e = Expr.parse(s);
            return e.evalBoolean(env);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public boolean hasInstallKeyword(Set keys) {
        return keys.contains(DEFAULT_INSTALL_COMMAND) || keys.contains("runtime");
    }

    public void resetTimeout() {
        this.setAlarm(0);
        int delayMs = this.getTestTimeout() * 1000;
        this.setAlarm(delayMs);
    }

    public void cancelTimeout() {
        this.setAlarm(0);
    }
}

