/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.ant.tasks;

import com.sun.javacard.ant.tasks.JavacardTaskBase;
import com.sun.javacard.ant.types.JCAInputFile;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;

public class MaskgenTask
extends JavacardTaskBase {
    protected static final String className = "com.sun.javacard.jcasm.mask.Main";
    protected String configFileName;
    protected boolean mem32BitFlag = true;
    protected String outFileName;
    protected String generator;
    protected boolean debugInfo;
    protected ArrayList inputJCAs = new ArrayList();

    public void setConfigFile(String configName) {
        this.configFileName = configName;
    }

    public void setOutFile(String outFileName) {
        this.outFileName = outFileName;
    }

    public void setMemRefSize(int memRefSize) {
        this.mem32BitFlag = memRefSize == 32;
    }

    public void setDebugInfo(boolean on) {
        this.debugInfo = on;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public void addJCAInputFile(JCAInputFile inputFile) {
        if (inputFile != null) {
            this.inputJCAs.add(inputFile);
        }
    }

    public void execute() throws BuildException {
        Commandline.Argument memRefSizeArg;
        this.printDisclaimer();
        if (this.configFileName != null) {
            Commandline.Argument configFileFlag = this.createArg();
            configFileFlag.setValue("-c");
            Commandline.Argument configFileArg = this.createArg();
            configFileArg.setValue(this.configFileName);
        }
        if (this.debugInfo) {
            Commandline.Argument debugInfoFlag = this.createArg();
            debugInfoFlag.setValue("-debuginfo");
        }
        if (this.mem32BitFlag) {
            memRefSizeArg = this.createArg();
            memRefSizeArg.setValue("-32bit");
        } else {
            memRefSizeArg = this.createArg();
            memRefSizeArg.setValue("-16bit");
        }
        if (this.outFileName != null) {
            Commandline.Argument outFileNameFlag = this.createArg();
            outFileNameFlag.setValue("-o");
            Commandline.Argument outFileNameArg = this.createArg();
            outFileNameArg.setValue(this.outFileName);
        }
        if (this.generator == null) {
            throw new BuildException(messages.getString("maskgen.nogenerator"));
        }
        Commandline.Argument generatorArg = this.createArg();
        generatorArg.setValue(this.generator);
        if (this.inputJCAs.size() == 0) {
            throw new BuildException(messages.getString("maskgen.nojcas"));
        }
        ListIterator jcasItr = this.inputJCAs.listIterator();
        while (jcasItr.hasNext()) {
            JCAInputFile jcaInputName = (JCAInputFile)jcasItr.next();
            Commandline.Argument jcaInputFileArg = this.createArg();
            jcaInputFileArg.setValue(jcaInputName.getInputFileName());
        }
        this.setClassname(className);
        this.setFork(true);
        if (this.executeJava() != 0) {
            throw new BuildException(messages.getString("maskgen.failure"));
        }
    }
}

