/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.ant.tasks;

import com.sun.javacard.ant.tasks.JavacardTaskBase;
import com.sun.javacard.ant.types.AppletNameAID;
import java.io.File;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ConverterTask
extends JavacardTaskBase {
    private static final String Converter = "com.sun.javacard.converter.Converter";
    protected String packageName;
    protected String packageAID;
    protected String majorminorVersion;
    protected ArrayList applets;
    protected Path classDir;
    protected Path outputDir;
    protected boolean debug = false;
    protected boolean exportmap = false;
    protected Path exportPath;
    protected boolean intSupport = false;
    protected boolean mask = false;
    protected boolean noverify = false;
    protected boolean nowarn = false;
    protected boolean outCAP = false;
    protected boolean outJCA = false;
    protected boolean outEXP = false;
    protected boolean verbose = false;
    protected File configfile;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageaid(String packageAid) {
        this.packageAID = packageAid;
    }

    public void setMajorminorversion(String majorMinor) {
        this.majorminorVersion = majorMinor;
    }

    public void setClassdir(Path classdir) {
        this.classDir = classdir;
    }

    public void setOutputdirectory(Path dir) {
        this.outputDir = dir;
    }

    public void setDebug(boolean on) {
        this.debug = on;
    }

    public void setExportmap(boolean on) {
        this.exportmap = on;
    }

    public void setExportpath(Path exportPath) {
        if (this.exportPath == null) {
            this.exportPath = exportPath;
        } else {
            this.exportPath.append(exportPath);
        }
    }

    public Path createExportpath() {
        if (this.exportPath == null) {
            this.exportPath = new Path(this.getProject());
        }
        return this.exportPath.createPath();
    }

    public void addConfiguredAppletnameaid(AppletNameAID appletaid) {
        if (!appletaid.isNull()) {
            if (this.applets == null) {
                this.applets = new ArrayList();
            }
            this.applets.add(appletaid);
        }
    }

    public void setExportpathRef(Reference r) {
        this.createExportpath().setRefid(r);
    }

    public void setInt(boolean on) {
        this.intSupport = on;
    }

    public void setMask(boolean on) {
        this.mask = on;
    }

    public void setNoverify(boolean on) {
        this.noverify = on;
    }

    public void setNowarn(boolean on) {
        this.nowarn = on;
    }

    public void setCap(boolean on) {
        this.outCAP = on;
    }

    public void setJca(boolean on) {
        this.outJCA = on;
    }

    public void setExp(boolean on) {
        this.outEXP = on;
    }

    public void setVerbose(boolean on) {
        this.verbose = on;
    }

    public void setConfigfile(File config) {
        this.configfile = config;
    }

    public void execute() throws BuildException {
        this.printDisclaimer();
        if (this.configfile == null) {
            Commandline.Argument outputOption;
            super.setupCommonOptions();
            String output = "";
            if (this.outCAP || this.outJCA || this.outEXP) {
                Commandline.Argument out = this.createArg();
                out.setValue("-out");
            }
            if (this.outCAP) {
                outputOption = this.createArg();
                outputOption.setValue("CAP");
            }
            if (this.outJCA) {
                outputOption = this.createArg();
                outputOption.setValue("JCA");
            }
            if (this.outEXP) {
                outputOption = this.createArg();
                outputOption.setValue("EXP");
            }
            if (this.applets != null) {
                ListIterator appletsiter = this.applets.listIterator();
                while (appletsiter.hasNext()) {
                    AppletNameAID temp = (AppletNameAID)appletsiter.next();
                    Commandline.Argument applet = this.createArg();
                    applet.setValue("-applet");
                    Commandline.Argument appletaid = this.createArg();
                    appletaid.setValue(temp.getAid());
                    Commandline.Argument classname = this.createArg();
                    classname.setValue(temp.getAppletname());
                }
            }
            if (this.classDir != null) {
                Commandline.Argument classdir = this.createArg();
                classdir.setValue("-classdir");
                Commandline.Argument classDir = this.createArg();
                classDir.setPath(this.classDir);
            }
            if (this.outputDir != null) {
                Commandline.Argument d = this.createArg();
                d.setValue("-d");
                Commandline.Argument outputdir = this.createArg();
                outputdir.setPath(this.outputDir);
            }
            if (this.debug) {
                Commandline.Argument Debug = this.createArg();
                Debug.setValue("-debug");
            }
            if (this.exportmap) {
                Commandline.Argument Exportmap = this.createArg();
                Exportmap.setValue("-exportmap");
            }
            if (this.exportPath != null) {
                Commandline.Argument exportpath = this.createArg();
                exportpath.setValue("-exportpath");
                Commandline.Argument exportpathdir = this.createArg();
                exportpathdir.setPath(this.exportPath);
            }
            if (this.intSupport) {
                Commandline.Argument intsupport = this.createArg();
                intsupport.setValue("-i");
            }
            if (this.mask) {
                Commandline.Argument mmask = this.createArg();
                mmask.setValue("-mask");
            }
            if (this.noverify) {
                Commandline.Argument nnoverify = this.createArg();
                nnoverify.setValue("-noverify");
            }
            if (this.nowarn) {
                Commandline.Argument nowarn = this.createArg();
                nowarn.setValue("-nowarn");
            }
            if (this.verbose) {
                Commandline.Argument verbose = this.createArg();
                verbose.setValue("-verbose");
            }
            if (this.packageName == null) {
                throw new BuildException(messages.getString("converter.noPackageName"));
            }
            if (this.packageAID == null) {
                throw new BuildException(messages.getString("converter.noPackageAID"));
            }
            if (this.majorminorVersion == null) {
                throw new BuildException(messages.getString("converter.noVersionNumber"));
            }
            Commandline.Argument packagename = this.createArg();
            packagename.setValue(this.packageName);
            Commandline.Argument packageaid = this.createArg();
            packageaid.setValue(this.packageAID);
            Commandline.Argument majorminorversion = this.createArg();
            majorminorversion.setValue(this.majorminorVersion);
        } else if (this.configfile != null) {
            Commandline.Argument configfile = this.createArg();
            configfile.setValue("-config");
            Commandline.Argument filename = this.createArg();
            filename.setValue(this.configfile.getAbsolutePath());
        }
        this.setClassname(Converter);
        this.setFork(true);
        if (this.executeJava() != 0) {
            throw new BuildException(messages.getString("converter.ErrorReturned"));
        }
    }
}

