/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.crefterminal;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.Tracer;
import opencard.opt.terminal.PowerManagementInterface;

public class CrefCardTerminal
extends CardTerminal
implements Pollable,
PowerManagementInterface {
    private static ResourceBundle _messages = PropertyResourceBundle.getBundle("com/sun/javacard/crefterminal/MessagesBundle");
    private static Tracer ctracer = new Tracer(class$com$sun$javacard$crefterminal$CrefCardTerminal == null ? (class$com$sun$javacard$crefterminal$CrefCardTerminal = CrefCardTerminal.class$("com.sun.javacard.crefterminal.CrefCardTerminal")) : class$com$sun$javacard$crefterminal$CrefCardTerminal);
    private static String hostName = "localhost";
    private static int portNumber = 9025;
    private CadClient cad;
    private boolean CardPresent = false;
    private byte[] cachedATR = null;
    static /* synthetic */ Class class$com$sun$javacard$crefterminal$CrefCardTerminal;

    protected CrefCardTerminal(String string, String string2, String string3) throws CardTerminalException {
        super(string, string2, string3);
        int n = string3.indexOf(58);
        hostName = string3.substring(0, n);
        portNumber = Integer.parseInt(string3.substring(n + 1));
        this.addSlots(1);
    }

    public void open() throws CardTerminalException {
        try {
            ctracer.info("open", _messages.getString("msg.1") + this.getName());
            Socket socket = new Socket(hostName, portNumber);
            socket.setTcpNoDelay(true);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            this.cad = new CadClient((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
            this.powerUpCard(0, 0);
            CardTerminalRegistry.getRegistry().addPollable((Pollable)this);
            this.CardPresent = true;
        }
        catch (Exception exception) {
            throw new CardTerminalException(exception.toString());
        }
    }

    public void close() throws CardTerminalException {
        int n = 0;
        if (this.CardPresent) {
            ctracer.info("close", _messages.getString("msg.2") + this.getName());
            try {
                this.powerDownCard(n, 0);
                CardTerminalRegistry.getRegistry().removePollable((Pollable)this);
                this.CardPresent = false;
            }
            catch (Exception exception) {
                throw new CardTerminalException(exception.toString());
            }
        }
    }

    public void powerUpCard(int n, int n2) throws CardTerminalException {
        try {
            this.cachedATR = this.cad.powerUp();
        }
        catch (Exception exception) {
            throw new CardTerminalException(exception.toString());
        }
    }

    public void powerDownCard(int n, int n2) {
        try {
            this.cad.powerDown();
        }
        catch (Exception exception) {}
    }

    private Apdu cAPDUtoCrefapdu(CommandAPDU commandAPDU) {
        Apdu apdu = new Apdu();
        byte[] byArray = commandAPDU.getBytes();
        System.arraycopy(byArray, 0, apdu.command, 0, 4);
        int n = byArray[4] & 0xFF;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 5, byArray2, 0, n);
        ctracer.info("internalSendAPDU", _messages.getString("msg.3") + byArray2.toString());
        apdu.setDataIn(byArray2, n);
        apdu.Le = byArray[5 + n] & 0xFF;
        return apdu;
    }

    public ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        ResponseAPDU responseAPDU;
        Apdu apdu = this.cAPDUtoCrefapdu(commandAPDU);
        byte by = commandAPDU.getBytes()[4];
        ctracer.info("internalSendAPDU", _messages.getString("msg.4") + commandAPDU.toString());
        try {
            this.cad.exchangeApdu(apdu);
            byte[] byArray = apdu.getResponseApduBytes();
            byte[] byArray2 = new byte[byArray.length - by - 6];
            System.arraycopy(byArray, by + 6, byArray2, 0, byArray2.length);
            responseAPDU = new ResponseAPDU(byArray2);
        }
        catch (Exception exception) {
            throw new CardTerminalException(exception.toString());
        }
        return responseAPDU;
    }

    public boolean isCardPresent(int n) throws CardTerminalException {
        return this.CardPresent;
    }

    public CardID getCardID(int n) throws CardTerminalException {
        CardID cardID = null;
        ctracer.info("getCardID", _messages.getString("msg.5"));
        if (this.CardPresent) {
            if (this.cachedATR == null) {
                ctracer.debug("getCardID", _messages.getString("msg.6"));
                this.powerUpCard(n, 0);
            }
            cardID = new CardID(this.cachedATR);
            ctracer.debug("getCardID", _messages.getString("msg.7") + cardID);
        } else {
            ctracer.debug("getCardID", _messages.getString("msg.8"));
            this.cachedATR = null;
        }
        return cardID;
    }

    public void poll() throws CardTerminalException {
        int n = 0;
        if (this.CardPresent) {
            this.cardInserted(n);
        } else {
            this.cardRemoved(n);
        }
    }

    public Properties internalFeatures(Properties properties) {
        return properties;
    }

    public CardID internalReset(int n, int n2) throws CardTerminalException {
        ctracer.debug("internalReset", _messages.getString("msg.9"));
        return null;
    }

    public String toString() {
        return super.toString() + _messages.getString("msg.10");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

