/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.exportfile.EfConstant;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfConstantUtf8;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EfConstantClassRef
extends EfConstant {
    private int name_index;
    private String name;
    private EfConstantPool constant_pool;

    public EfConstantClassRef(EfConstantPool cp) {
        this.constant_pool = cp;
    }

    public EfConstantClassRef(EfConstantPool cp, String name) {
        this.constant_pool = cp;
        EfConstant[] constants = this.constant_pool.getConstants();
        this.name = name;
        for (int i = 0; i < constants.length; ++i) {
            EfConstantUtf8 utf8_constant;
            if (!(constants[i] instanceof EfConstantUtf8) || !(utf8_constant = (EfConstantUtf8)constants[i]).getUtf8String().equals(name)) continue;
            this.name_index = i;
            return;
        }
        this.name_index = cp.addConstantUtf8(name);
    }

    public void parse(DataInputStream dis) throws IOException {
        this.name_index = dis.readUnsignedShort();
    }

    public void resolve() {
        this.name = this.constant_pool.getConstantUtf8(this.name_index).getUtf8String();
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tab_level; ++i) {
            sb.append("\t");
        }
        String indent = sb.toString();
        pw.println(indent + "Constant_Classref_info {");
        pw.println(indent + "\ttag\t" + 7);
        pw.println(indent + "\tname_index\t" + this.name_index + "\t\t// " + this.name);
        pw.println(indent + "}");
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeByte(7);
        dos.writeShort(this.name_index);
    }

    public int getClassNameIndex() {
        return this.name_index;
    }

    public String getClassName() {
        return this.name;
    }
}

