/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AbstrInterpError;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Checkcode;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.OffsetAndLength;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.TreeSet;

class MethodComponent
extends Safeptr {
    private TreeSet allMethods;

    MethodComponent(byte[] byArray) {
        super(byArray, "Method");
    }

    int handlerCount() {
        return this.u1(0);
    }

    ExnHandlerInfo exceptionHandler(int n) {
        return new ExnHandlerInfo(this.offset(1 + n * 8));
    }

    Safeptr methInfo() {
        return this.offset(1 + this.handlerCount() * 8);
    }

    MethodInfo methodInfo(int n) {
        return new MethodInfo(this.offset(n));
    }

    Safeptr methodCode(int n) {
        return this.offset(n);
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("MethodComponent.100");
        }
        this.allMethods = new TreeSet();
        ClassDescriptor classDescriptor = Cap.Descriptor.firstClassDescriptor();
        for (int i = Cap.Descriptor.classCount(); i > 0; --i) {
            if ((classDescriptor.flags() & 0x40) == 0) {
                for (int j = 0; j < classDescriptor.methodCount(); ++j) {
                    MethodDescriptor methodDescriptor = classDescriptor.methodDescr(j);
                    MethodInfo methodInfo = this.methodInfo(methodDescriptor.methodOffset());
                    try {
                        this.verifyMethod(classDescriptor, methodDescriptor, methodInfo);
                        continue;
                    }
                    catch (AbstrInterpError abstrInterpError) {
                        throw new AbstrInterpError("MethodComponent.1", methodDescriptor, methodInfo, abstrInterpError.getMessage(), abstrInterpError, classDescriptor);
                    }
                    catch (VerifierError verifierError) {
                        throw new VerifierError("MethodComponent.1", (Object)methodDescriptor, (Object)methodInfo, (Object)verifierError.getMessage());
                    }
                }
            }
            classDescriptor.next();
        }
        this.verifyHandlers();
        this.verifyOverlap();
        this.allMethods = null;
    }

    private void verifyMethod(ClassDescriptor classDescriptor, MethodDescriptor methodDescriptor, MethodInfo methodInfo) {
        boolean bl;
        int n = methodInfo.flags();
        if ((n & 0xFFFFFFF3) != 0) {
            throw new VerifierError("MethodComponent.9", n);
        }
        boolean bl2 = (methodDescriptor.flags() & 0x40) != 0;
        boolean bl3 = bl = (n & 4) != 0;
        if (bl2 != bl) {
            throw new VerifierError("MethodComponent.2");
        }
        int n2 = (n & 8) == 0 ? 2 : 4;
        int n3 = methodDescriptor.bytecodeCount();
        if ((n & 8) != 0 && methodInfo.paddingExtended() != 0) {
            throw new VerifierError("MethodComponent.14");
        }
        methodInfo.offset(n2 + n3);
        int n4 = methodDescriptor.exnHandlerIndex();
        int n5 = methodDescriptor.exnHandlerCount();
        if (n5 == 0) {
            if (n4 != 0) {
                throw new VerifierError("MethodComponent.3");
            }
        } else if (n4 + n5 > this.handlerCount()) {
            throw new VerifierError("MethodComponent.4");
        }
        int n6 = methodInfo.ofs + n2;
        int n7 = n6 + n3;
        for (int i = 0; i < this.handlerCount(); ++i) {
            ExnHandlerInfo exnHandlerInfo = this.exceptionHandler(i);
            if (exnHandlerInfo.startOffset() >= n7 || exnHandlerInfo.endOffset() <= n6 || i >= n4 && i < n4 + n5) continue;
            throw new VerifierError("MethodComponent.5");
        }
        if ((n & 4) == 0) {
            Checkcode.typecheck(classDescriptor, methodDescriptor, methodInfo);
        }
        if (!this.allMethods.add(new OffsetAndLength(methodInfo.ofs, n2 + n3))) {
            throw new VerifierError("MethodComponent.10", methodInfo.ofs);
        }
    }

    private void verifyHandlers() {
        int n = -1;
        for (int i = 0; i < this.handlerCount(); ++i) {
            ExnHandlerInfo exnHandlerInfo = this.exceptionHandler(i);
            if (exnHandlerInfo.handlerOffset() < n) {
                throw new VerifierError("MethodComponent.11");
            }
            n = exnHandlerInfo.handlerOffset();
            if (exnHandlerInfo.activeLength() == 0) {
                throw new VerifierError("MethodComponent.13", i);
            }
            boolean bl = true;
            for (int j = i + 1; j < this.handlerCount(); ++j) {
                if (!exnHandlerInfo.intersect(this.exceptionHandler(j))) continue;
                bl = false;
                break;
            }
            if (exnHandlerInfo.stopBit() == bl) continue;
            throw new VerifierError("MethodComponent.12", i);
        }
    }

    private void verifyOverlap() {
        Safeptr safeptr = this.methInfo();
        for (OffsetAndLength offsetAndLength : this.allMethods) {
            if (offsetAndLength.offset < safeptr.ofs) {
                throw new VerifierError("MethodComponent.6", safeptr.ofs);
            }
            if (offsetAndLength.offset > safeptr.ofs) {
                throw new VerifierError("MethodComponent.7", safeptr.ofs);
            }
            safeptr.advance(offsetAndLength.length);
        }
        if (!safeptr.atComponentEnd()) {
            throw new VerifierError("MethodComponent.8");
        }
    }
}

