/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.javatest.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class SynchronizedFileAppender {
    private static final int MAX_TIME = 100;
    private static final int MAX_ATTEMPTS = 100;
    private File file;
    private File lockFile;
    private Appender writer;
    private Random rand = new Random(System.currentTimeMillis());
    private List queue = new LinkedList();
    private static String id;
    private static HashMap<File, SynchronizedFileAppender> instances;

    public static SynchronizedFileAppender getInstance(String path) {
        return SynchronizedFileAppender.getInstance(new File(path));
    }

    public static synchronized SynchronizedFileAppender getInstance(File file) {
        SynchronizedFileAppender retVal = instances.get(file);
        if (retVal == null) {
            retVal = new SynchronizedFileAppender(file);
            instances.put(file, retVal);
        }
        return retVal;
    }

    private SynchronizedFileAppender(File file) {
        this.file = file;
        this.lockFile = new File(file.getAbsolutePath() + ".lock");
        this.writer = new Appender(100);
        Thread thread = new Thread(this.writer);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String data) {
        List list = this.queue;
        synchronized (list) {
            this.queue.add(data);
            this.queue.notifyAll();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean isDone = false;
                for (int i = 0; i < 1000 && !isDone; ++i) {
                    isDone = true;
                    for (SynchronizedFileAppender current : instances.values()) {
                        if (current.queue.size() > 0) {
                            isDone = false;
                            List list = current.queue;
                            synchronized (list) {
                                current.queue.notifyAll();
                            }
                        }
                        isDone = isDone && !((SynchronizedFileAppender)current).writer.isFileLocked;
                    }
                    if (isDone) {
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw new RuntimeException("Can not synchronize files.");
            }
        }));
        instances = new HashMap();
    }

    private class Appender
    implements Runnable {
        int max_count;
        boolean isFileLocked = false;

        public Appender(int max_count) {
            this.max_count = max_count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            while (true) {
                this.runSynchronously(this.max_count);
                try {
                    List list = SynchronizedFileAppender.this.queue;
                    synchronized (list) {
                        SynchronizedFileAppender.this.queue.wait();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSynchronously(int max_count) {
            if (SynchronizedFileAppender.this.queue.isEmpty()) {
                return;
            }
            try {
                int count = 0;
                while (!(this.isFileLocked = SynchronizedFileAppender.this.lockFile.createNewFile())) {
                    if (count++ > max_count && max_count != 0) {
                        throw new RuntimeException();
                    }
                    Thread.sleep(SynchronizedFileAppender.this.rand.nextInt(100));
                }
                OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(SynchronizedFileAppender.this.file, true));
                List list = SynchronizedFileAppender.this.queue;
                synchronized (list) {
                    while (!SynchronizedFileAppender.this.queue.isEmpty()) {
                        out.write((String)SynchronizedFileAppender.this.queue.get(0));
                        SynchronizedFileAppender.this.queue.remove(0);
                    }
                }
                out.close();
            }
            catch (Exception exception) {
            }
            finally {
                if (this.isFileLocked) {
                    SynchronizedFileAppender.this.lockFile.delete();
                    this.isFileLocked = false;
                }
            }
        }
    }
}

