/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.javatest.services;

import com.sun.tck.j2me.J2MEUtils;
import com.sun.tck.j2me.services.LifeCycleAware;
import com.sun.tck.j2me.services.ServiceFault;
import com.sun.tck.jc.javatest.services.SynchronizedFileAppender;
import java.io.File;
import java.text.FieldPosition;
import java.text.MessageFormat;

public class LoggingService
implements LifeCycleAware {
    SynchronizedFileAppender appender;
    private static int backUpCount = 20;

    public void setTmpDir(File tmp) {
        File log = new File(tmp, "log-file");
        LoggingService.move(log, 0);
        this.appender = SynchronizedFileAppender.getInstance(log);
    }

    private static void move(File path, int count) {
        int toCount = count + 1;
        File toFile = new File(path.getAbsolutePath() + "." + toCount);
        if (toCount >= backUpCount) {
            toFile.delete();
        } else if (toFile.exists()) {
            LoggingService.move(path, toCount);
        }
        File fromFile = count == 0 ? path : new File(path.getAbsolutePath() + "." + count);
        fromFile.renameTo(toFile);
    }

    public void logException(String module, Throwable t) {
        this.log(module, J2MEUtils.getTrace(t), new Object[0]);
    }

    public void log(String module, String message, Object ... args) {
        String str;
        if (args.length != 0) {
            StringBuffer buff = new StringBuffer(">>> ");
            buff.append(module).append(":");
            new MessageFormat(message).format(args, buff, (FieldPosition)null);
            buff.append("<<<\n");
            str = buff.toString();
        } else {
            str = ">>> " + message + "<<<\n";
        }
        if (this.appender == null) {
            System.out.print(str);
        } else {
            this.appender.append(str);
        }
    }

    public void start() throws ServiceFault {
    }

    public void stop() throws ServiceFault {
    }
}

