/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.interview.lib;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.tck.jc.interview.lib.InterviewEntry;
import com.sun.tck.jc.interview.lib.InterviewPathResolver;
import com.sun.tck.jc.interview.lib.Validator;
import com.sun.tck.jc.interview.lib.ValueSetListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IntQuestion
extends com.sun.interview.IntQuestion
implements InterviewEntry {
    private InterviewPathResolver resolver;
    private Validator validator;
    private Map map;
    private Object defaultValue;
    private String key;
    private ArrayList listeners = new ArrayList();

    public IntQuestion(Interview interview, String tag, Validator validator, Map map) {
        super(interview, tag);
        this.setValidator(validator);
        this.map = map == null ? new HashMap() : map;
        this.defaultValue = map.get(this.tag);
        this.clear();
    }

    public IntQuestion(Interview interview, String tag, int min, int max, Validator validator, Map map) {
        super(interview, tag, min, max);
        this.setValidator(validator);
        this.map = map == null ? new HashMap() : map;
        this.defaultValue = map.get(this.tag);
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public void setValue(int value) {
        Integer refValue = new Integer(value);
        if (this.validator.accept(this.tag, refValue, this.map)) {
            Iterator e = this.listeners.iterator();
            while (e.hasNext()) {
                ((ValueSetListener)e.next()).valueSet(Integer.toString(value));
            }
            this.map.put(this.tag, refValue);
        }
        super.setValue(value);
    }

    public void setValue(String value) throws Interview.Fault {
        if (this.validator.accept(this.tag, value, this.map)) {
            Iterator e = this.listeners.iterator();
            while (e.hasNext()) {
                ((ValueSetListener)e.next()).valueSet(value);
            }
            this.map.put(this.tag, value);
        }
        super.setValue(value);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void export(Map map) {
        if (this.key != null) {
            map.put(this.key, this.getStringValue());
        }
    }

    public void clear() {
        if (this.map == null) {
            return;
        }
        if (this.defaultValue == null) {
            super.clear();
        } else if (this.defaultValue instanceof Integer) {
            this.setValue((Integer)this.defaultValue);
        } else if (this.defaultValue instanceof String) {
            try {
                this.setValue((String)this.defaultValue);
            }
            catch (Interview.Fault e) {
                super.clear();
            }
        } else {
            super.clear();
        }
    }

    public void setResolver(InterviewPathResolver resolver) {
        this.resolver = resolver == null ? InterviewPathResolver.Null : resolver;
    }

    public void setValidator(Validator validator) {
        this.validator = validator == null ? Validator.TrueValidator : validator;
    }

    public Question getNext() {
        return this.validator.accept(this.tag, new Integer(this.getValue()), this.map) ? this.resolver.getNext(this.tag) : this.validator.getErrorQuestion(this.tag, new Integer(this.getValue()), this.map);
    }

    public void addListener(ValueSetListener listener) {
        this.listeners.add(listener);
    }
}

