/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.internal;

import com.sun.tck.jc.internal.BandI;
import com.sun.tck.jc.internal.BaseClassDescriptor;
import com.sun.tck.jc.internal.JCMultiTestEmitter;
import com.sun.tck.jc.internal.MultiPartSource;
import com.sun.tck.jc.internal.Source;
import com.sun.tgxml.tjtf.api.code.CodeSet;
import com.sun.tgxml.tjtf.api.code.SupportCode;
import com.sun.tgxml.tjtf.api.code.TestCode;
import com.sun.tgxml.tjtf.api.documentation.Documentation;
import com.sun.tgxml.tjtf.api.documentation.TestGroupDocumentation;
import com.sun.tgxml.tjtf.api.exceptions.TestFileException;
import com.sun.tgxml.tjtf.api.tests.TestCase;
import com.sun.tgxml.tjtf.api.tests.TestGroup;
import com.sun.tgxml.tjtf.api.tests.TestItem;
import com.sun.tgxml.tjtf.tools.BuildProperties;
import com.sun.tgxml.util.IR;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class DoTest
implements JCMultiTestEmitter.TestType {
    protected static String package_prefix;
    protected static String[] copyright_lines;
    private static final String[] empty;
    protected StringBuffer args = new StringBuffer();
    protected String executeClass;
    protected String output_Dir;
    protected String group_name;
    protected TestGroup testGroup;
    protected BaseClassDescriptor baseClass;
    private boolean containsScript = false;
    private String[] configs = empty;
    private String[] applets = empty;
    private String[] scripts = empty;
    private String package_name_internal;
    private String applet_name_internal;
    private static final String HEADER = "header";
    private static final String IMPORT = "import";
    private static final String CLASS = "class";
    private static final String DOTEST = "DoTest";
    private static final String END = "end";

    public DoTest(TestGroup testGroup, String baseClassName) {
        this.testGroup = testGroup;
        String name = BuildProperties.getString((String)(baseClassName + ".descriptor"));
        if (name == null) {
            this.baseClass = new BaseClassDescriptor(){

                public String getSupportCode(String className) {
                    return "";
                }

                public ArrayList getImports(String className) {
                    return new ArrayList();
                }

                public String getDoTestCode(String className) {
                    return "";
                }

                public int getFirstCase(String className) {
                    return 1;
                }
            };
        } else {
            try {
                this.baseClass = (BaseClassDescriptor)Class.forName(name).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Can not instantinate descriptor: " + name);
            }
        }
        String s = BandI.getExcuteArgs(testGroup);
        if (s != null) {
            this.args.append(s);
            this.containsScript = s.indexOf("-scriptClass") >= 0;
        }
    }

    public String getExecuteArgs() {
        return this.args.toString();
    }

    public String getExecuteClass() {
        return this.executeClass;
    }

    public void setGroupName(String group_name) {
        this.group_name = group_name;
    }

    public void setOutputDir(String outputDir) {
        this.output_Dir = outputDir;
    }

    public static void addIfNotNull(StringBuffer buff, Object value, Object suffix) {
        if (value != null) {
            buff.append(value);
            if (suffix != null) {
                buff.append(suffix);
            }
        }
    }

    public void createSources() throws TestFileException {
        this.createConfigFiles();
        this.createAppletAndScriptFiles();
    }

    public String[] getConfigFiles() {
        return this.configs;
    }

    public String[] getAppletFiles() {
        return this.applets;
    }

    public String[] getScriptFiles() {
        return this.scripts;
    }

    private void createConfigFiles() throws TestFileException {
        String aid = IR.getAttrElem((String)"AID", (TestItem)this.testGroup);
        if (aid == null) {
            return;
        }
        MultiPartSource buff = new MultiPartSource(new String[]{HEADER});
        buff.set(HEADER);
        buff.print("//");
        this.addAuthors(buff, (Documentation)this.testGroup.getTGDocumentation());
        this.addCopyright(buff, "// ");
        buff.print(this.getPackage(this.testGroup));
        buff.print(".");
        buff.print(this.getAppletName(this.testGroup));
        buff.print(" ");
        buff.print(aid);
        buff.print("\n");
        String name = this.group_name + ".cfg";
        this.writeFile(name, buff);
        this.args.append(" -M ");
        this.args.append(name);
        this.args.append(" -capfile ");
        String pack = this.getPackage(this.testGroup);
        this.args.append(pack.substring(pack.lastIndexOf(46) + 1));
        this.args.append(".cap");
        this.configs = new String[]{name};
    }

    protected void addAuthors(Source buff, Documentation doc) {
        ArrayList list = null;
        if (doc != null && (list = doc.getAuthors()) != null) {
            buff.print("Authors: ");
            Iterator e = list.iterator();
            while (e.hasNext()) {
                buff.print((String)e.next());
                if (!e.hasNext()) continue;
                buff.print(", ");
            }
            buff.print("\n");
        }
    }

    protected void addCopyright(Source buff, String prefix) {
        for (int i = 0; i < copyright_lines.length; ++i) {
            buff.print(prefix);
            buff.print(copyright_lines[i]);
            buff.print("\n");
        }
    }

    protected String getPackage(TestGroup tg) throws TestFileException {
        return this.getPackageInternal(tg, "tests.api");
    }

    protected String getScriptsPackage(TestGroup tg) throws TestFileException {
        return this.getPackageInternal(tg, "scripts.api");
    }

    private String getPackageInternal(TestGroup tg, String suffix) throws TestFileException {
        if (this.package_name_internal == null) {
            TestGroupDocumentation doc = tg.getTGDocumentation();
            if (doc == null) {
                throw new TestFileException("The TestGroup does not contain documentaton.");
            }
            StringBuffer retVal = new StringBuffer(package_prefix);
            DoTest.addIfNotNull(retVal, suffix, ".");
            DoTest.addIfNotNull(retVal, doc.getTestedPackage(), ".");
            DoTest.addIfNotNull(retVal, doc.getTestedClass(), ".");
            retVal.append(this.group_name);
            this.package_name_internal = retVal.toString().toLowerCase();
        }
        return this.package_name_internal;
    }

    protected String getAppletName(TestGroup tg) throws TestFileException {
        if (this.applet_name_internal == null) {
            int pos = this.group_name.lastIndexOf(46);
            this.applet_name_internal = (pos >= 0 ? this.group_name.substring(pos) : this.group_name) + "Applet";
        }
        return this.applet_name_internal;
    }

    public void writeFile(String name, MultiPartSource buff) throws TestFileException {
        try {
            FileOutputStream f = new FileOutputStream(new File(this.output_Dir, name));
            PrintWriter out = new PrintWriter(f);
            buff.write(out);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TestFileException("Can not write: " + this.output_Dir + "/" + name);
        }
    }

    public MultiPartSource createSource() {
        MultiPartSource retVal = new MultiPartSource(null);
        retVal.addPart(HEADER, new MultiPartSource.SequenceSection());
        retVal.addPart(IMPORT, new Source(){
            TreeSet set = new TreeSet();

            public void print(Object o) {
                this.set.add(o);
            }

            public String toString() {
                StringBuffer buff = new StringBuffer();
                for (String line : this.set) {
                    buff.append("import ");
                    buff.append(line);
                    buff.append(";\n");
                }
                return buff.toString();
            }
        });
        retVal.addPart(CLASS, new MultiPartSource.SequenceSection());
        retVal.addPart(DOTEST, new MultiPartSource.SequenceSection());
        retVal.addPart(END, new MultiPartSource.SequenceSection());
        this.addFrameworkImports(retVal);
        return retVal;
    }

    private MultiPartSource createMapFile(String full_name) {
        if (full_name == null) {
            return null;
        }
        String name = BandI.getShortClassName(full_name);
        MultiPartSource buff = new MultiPartSource(null);
        buff.addPart(CLASS, new MultiPartSource.SequenceSection());
        buff.set(CLASS);
        this.printJavaHeaderComment(buff, name, this.testGroup);
        buff.print("\npackage ");
        buff.print(BandI.getPackageName(full_name));
        buff.print(";\n\npublic class ");
        buff.print(name);
        buff.print(" {\n");
        return buff;
    }

    protected void printJavaHeaderComment(Source buff, String name, TestGroup testGroup) {
        buff.print("/*\n * @(#)");
        buff.print(name);
        buff.print(".java ");
        this.addAuthors(buff, (Documentation)testGroup.getTGDocumentation());
        this.addCopyright(buff, " * ");
        buff.print(" */\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAppletAndScriptFiles() throws TestFileException {
        this.executeClass = this.getPackage(this.testGroup) + "." + this.getAppletName(this.testGroup);
        MultiPartSource mapFile = this.createMapFile(IR.getAttrElem((String)"ProtocolMapFile", (TestItem)this.testGroup));
        MultiPartSource buff = this.createSource();
        buff.set(HEADER);
        this.printJavaHeaderComment(buff, this.getAppletName(this.testGroup), this.testGroup);
        buff.print("\npackage ");
        buff.print(this.getPackage(this.testGroup));
        buff.print(";\n\n");
        buff.set(CLASS);
        this.addImports(buff, this.testGroup.getCodeSet());
        buff.set(IMPORT);
        try {
            Iterator e = this.baseClass.getImports(this.executeClass).iterator();
            while (e.hasNext()) {
                buff.print(e.next());
            }
        }
        finally {
            buff.restore();
        }
        buff.print("\npublic class ");
        buff.print(this.getAppletName(this.testGroup));
        buff.print(" extends Applet {\n\n    /**\n     * CLA byte: jcre test class\n     */\n    private final static byte CLA_JCRE_TEST = (byte)0x80;\n\n    /**\n     * INS byte: DoTests command\n     */\n    private final static byte INS_DO_TESTS = (byte)0x20;\n\n    private static final byte CJCK_PASS = (byte)0;\n    private static final byte CJCK_FAIL = (byte)1;\n    private static final byte CJCK_FAIL1 = (byte)2;\n    private static final byte CJCK_FAIL2 = (byte)3;\n    private static final byte CJCK_FAIL3 = (byte)4;\n    private static final byte CJCK_FAIL4 = (byte)5;\n    private static final byte CJCK_FAIL5 = (byte)6;\n    private static final byte CJCK_FAIL6 = (byte)7;\n    private static final byte CJCK_FAIL7 = (byte)8;\n    private static final byte CJCK_FAIL8 = (byte)9;\n    private static final byte CJCK_FAIL9 = (byte)10;\n    private static final byte CJCK_SW1  = (byte)0x9b;\n    private static final byte CJCK_SYSERR = (byte)0xfe;\n    private static final byte CJCK_SYSERROR = (byte)0xff;\n\n    /**\n     * constructor\n     * @param bArray from install().\n     * @param bOffset from install().\n     * @param bLength from install().\n     */\n    protected ");
        buff.print(this.getAppletName(this.testGroup));
        buff.print("(byte bArray[], short bOffset, byte bLength) {\n        register();\n    }\n\n    public static void install(byte[] bArray, short bOffset, byte bLength) {\n        new ");
        buff.print(this.getAppletName(this.testGroup));
        buff.print("(bArray, bOffset, bLength);\n    }\n\n    public static void throwPassed() throws ISOException {\n        ISOException.throwIt(Util.makeShort(CJCK_SW1, CJCK_PASS));\n    }\n\n    public static void throwFailed(byte status) throws ISOException {\n        if (status == CJCK_PASS) {\n            status = CJCK_SYSERROR;\n        }\n        ISOException.throwIt(Util.makeShort(CJCK_SW1, status));\n    }\n\n    public void process(APDU apdu) {\n\n        byte status = CJCK_PASS;\n        byte[] buffer = apdu.getBuffer();\n\n        if ((buffer[ISO7816.OFFSET_CLA] == CLA_JCRE_TEST) ||\n            (buffer[ISO7816.OFFSET_CLA] == ISO7816.CLA_ISO7816)) {\n\n            short bytesReceived = apdu.setIncomingAndReceive();\n\n            switch (buffer[ISO7816.OFFSET_INS]) {\n\n            case ISO7816.INS_SELECT:\n                // verify that the AIDs match\n                if (!JCSystem.getAID().equals(buffer, ISO7816.OFFSET_CDATA,\n                                              buffer[ISO7816.OFFSET_LC]))\n                    ISOException.throwIt(ISO7816.SW_APPLET_SELECT_FAILED);\n                break;\n\n            case INS_DO_TESTS:\t// do one or more tests\n                // Lc = number of tests\n                // Data = array of test codes\n                if (buffer[ISO7816.OFFSET_P1] == (byte)0) {\n                    short numTests = (short)(buffer[ISO7816.OFFSET_LC] & 0xFF);\n\n                    // must receive all tests in one block (1-32 tests allowed)\n                    if (numTests != bytesReceived)\n                        ISOException.throwIt(ISO7816.SW_WRONG_LENGTH);\n\n                    // get codes of tests to perform from APDU, perform test\n                    // and overwrite test code byte in buffer with test result\n                    for (short i = ISO7816.OFFSET_CDATA;\n                         i < ((short)(ISO7816.OFFSET_CDATA + numTests)); i++) {\n                        buffer[i] = this.doTest(buffer[i], buffer, ISO7816.OFFSET_CDATA,\n                                                buffer[ISO7816.OFFSET_LC]);\n                        if (buffer[i] != CJCK_PASS)\n                            status = CJCK_FAIL;\n                    }\n                    apdu.setOutgoingAndSend(ISO7816.OFFSET_CDATA, numTests);\n                } else {\n                    status = this.doTest(buffer[ISO7816.OFFSET_P1], buffer,\n                                         ISO7816.OFFSET_CDATA,\n                                         buffer[ISO7816.OFFSET_LC]);\n                }\n                ISOException.throwIt(Util.makeShort(CJCK_SW1, status));\n\n                break;\n\n            default: // unsupported INS\n                ISOException.throwIt(ISO7816.SW_INS_NOT_SUPPORTED);\n            }\n        } else { // unsupported CLA\n            ISOException.throwIt(ISO7816.SW_CLA_NOT_SUPPORTED);\n        }\n    }\n\n");
        buff.print(this.baseClass.getSupportCode(this.executeClass));
        this.addSupportCode(buff, (TestItem)this.testGroup);
        this.addTestCases(buff, this.testGroup, mapFile);
        buff.print(END, "}");
        String name = this.getAppletName(this.testGroup) + ".java";
        this.writeFile(name, buff);
        if (mapFile != null) {
            mapFile.print("}\n");
            String mn = BandI.getShortClassName(IR.getAttrElem((String)"ProtocolMapFile", (TestItem)this.testGroup)) + ".java";
            this.writeFile(mn, mapFile);
            this.scripts = new String[]{mn};
        }
        this.applets = new String[]{name};
    }

    protected void addSupportCode(Source buff, TestItem item) throws TestFileException {
        CodeSet cs = item.getCodeSet();
        if (cs == null) {
            return;
        }
        SupportCode code = cs.getSupportCode();
        if (code != null) {
            buff.print(code.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFrameworkImports(MultiPartSource set) {
        set.set(IMPORT);
        try {
            set.print("javacard.framework.APDU");
            set.print("javacard.framework.Applet");
            set.print("javacard.framework.ISO7816");
            set.print("javacard.framework.ISO7816");
            set.print("javacard.framework.ISOException");
            set.print("javacard.framework.Util");
            set.print("javacard.framework.JCSystem");
        }
        finally {
            set.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImports(MultiPartSource buff, CodeSet set) {
        buff.set(IMPORT);
        try {
            ArrayList list;
            if (set != null && (list = set.getImports()) != null) {
                Iterator e = list.iterator();
                while (e.hasNext()) {
                    buff.print(e.next());
                }
            }
        }
        finally {
            buff.restore();
        }
    }

    protected void addTestCases(MultiPartSource buff, TestGroup tg, MultiPartSource mapFile) throws TestFileException {
        buff.print(DOTEST, "    /*\n     * doTest() - perform test indicated by testCode\n     */\n    byte doTest(byte testCode, byte[] buffer, short offset, short length) {\n            switch (testCode) {\n            // The trivial success case, is required for and testcase excluding and memory clean-up\n            case 0:\n                try {\n                    cleanUp();\n                    if (javacard.framework.JCSystem.isObjectDeletionSupported()) {\n                        javacard.framework.JCSystem.requestObjectDeletion();\n                    }\n                } catch (Throwable t) {\n                }\n                return (byte)0;\n");
        buff.print(DOTEST, this.baseClass.getDoTestCode(this.executeClass));
        ArrayList cases = tg.getTestCases();
        boolean hasCleanUp = false;
        int case_count = this.baseClass.getFirstCase(this.executeClass) - 1;
        for (TestCase item : cases) {
            String name = item.getID();
            this.addSupportCode(buff, (TestItem)item);
            if ("cleanUp".equals(name)) {
                hasCleanUp = true;
            } else {
                this.printCaseAndMap(buff, mapFile, ++case_count, name);
            }
            if ("cleanUp".equals(name)) {
                buff.print("    void cleanUp() {\n");
            } else {
                buff.print("    byte ");
                buff.print(name);
                buff.print("(byte[] buffer, short offset, short length) {\n");
            }
            TestCode code = item.getTestCode();
            if (code == null) {
                throw new TestFileException("The TestCode is undefined for TestCase:" + name);
            }
            buff.print(code.getSource());
            this.addImports(buff, item.getCodeSet());
            buff.print("\n    }\n\n");
        }
        if (!hasCleanUp) {
            buff.print("    void cleanUp() {\n    }\n");
        }
        buff.print(DOTEST, "            default:\n                // failure code - no test found for given testCode\n                return CJCK_SYSERROR;\n            }\n    }\n");
        if (!this.containsScript || this.baseClass.getFirstCase(this.executeClass) > 1) {
            this.args.append(" -TestCount ");
            this.args.append(case_count);
        }
    }

    protected void printCaseAndMap(MultiPartSource buff, MultiPartSource map, int case_count, String name) {
        buff.print(DOTEST, "            case ");
        buff.print(DOTEST, Integer.toString(case_count));
        buff.print(DOTEST, ":\n                return ");
        buff.print(DOTEST, name);
        buff.print(DOTEST, "(buffer, offset, length);\n");
        if (map != null) {
            map.print("    public static final byte ");
            map.print(name.toUpperCase());
            map.print(" = (byte)");
            map.print(Integer.toString(case_count));
            map.print(";\n");
        }
    }

    static {
        empty = new String[0];
        StringTokenizer e = new StringTokenizer(BuildProperties.getString((String)"test.copyrightNotice"), "\n");
        copyright_lines = new String[e.countTokens()];
        for (int i = 0; i < copyright_lines.length; ++i) {
            DoTest.copyright_lines[i] = e.nextToken();
        }
        if (!(package_prefix = BuildProperties.getString((String)"test.packagePrefix", (String)package_prefix)).endsWith(".")) {
            package_prefix = package_prefix + ".";
        }
    }
}

