/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.j2me.services;

import com.sun.tck.j2me.J2MEUtils;
import com.sun.tck.j2me.services.LifeCycleAware;
import com.sun.tck.j2me.services.ServiceFault;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Logger;

public class LifeCycleAwareManager
implements LifeCycleAware {
    private LinkedHashMap awareObjects = new LinkedHashMap();
    private static final Logger log = Logger.getLogger(LifeCycleAwareManager.class.getName());

    public synchronized void start() throws ServiceFault {
        log.finer(this + ".start() started");
        Iterator i = this.awareObjects.keySet().iterator();
        while (i.hasNext()) {
            LifeCycleAware aware = (LifeCycleAware)this.awareObjects.get(i.next());
            try {
                aware.start();
            }
            catch (Exception e) {
                log.fine(aware + " throws Exception in starting:" + e + ". Stacktrace: " + J2MEUtils.getTrace(e));
                ServiceFault fault = new ServiceFault(e.getMessage());
                log.finer(this + ".start() completed abnormally.");
                throw fault;
            }
            log.finer(aware + " started successfully");
        }
        log.finer(this + ".start() completed normally");
    }

    public synchronized void stop() throws ServiceFault {
        log.finer(this + ".stop() started");
        StringBuilder message = new StringBuilder("The following exceptions have been thrown: ");
        boolean isThrown = false;
        ArrayList keyList = new ArrayList(this.awareObjects.keySet());
        for (int i = keyList.size() - 1; i >= 0; --i) {
            LifeCycleAware obj = (LifeCycleAware)this.awareObjects.get(keyList.get(i));
            try {
                obj.stop();
                log.finer(obj + " stopped successfully.");
                continue;
            }
            catch (Exception e) {
                log.fine(obj + ".stop() throws Exception:" + J2MEUtils.getTrace(e));
                isThrown = true;
                message.append(e.toString());
                message.append("; ");
            }
        }
        if (isThrown) {
            ServiceFault fault = new ServiceFault(message.toString());
            log.finer(this + ".stop() completed abnormally: " + fault);
            throw fault;
        }
        log.finer(this + ".stop() completed normally");
    }

    public synchronized void addLifeCycleAware(LifeCycleAware aware) {
        String key = aware.getClass().getName() + '@' + Integer.toHexString(aware.hashCode());
        this.addLifeCycleAware(key, aware);
    }

    public synchronized void addLifeCycleAware(String name, LifeCycleAware aware) {
        if (!this.awareObjects.containsValue(aware)) {
            log.finer(aware + " has been added to the " + this);
            this.awareObjects.put(name, aware);
        }
    }

    public synchronized void clear() {
        this.awareObjects.clear();
        log.finer(this + ".clear()");
    }
}

