/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.j2me;

import com.sun.javatest.TestEnvironment;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2MEUtils {
    private static final int MAX_TRACE_LENGTH = 1000;

    public static String getTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringBuffer retVal = new StringBuffer(t.toString());
        retVal.append('\n');
        int count = 0;
        String pref = "\tat ";
        while (count < 1000 && t != null) {
            StackTraceElement[] list = t.getStackTrace();
            for (int i = 0; i < list.length; ++i) {
                retVal.append(pref);
                retVal.append(list[i].toString());
                retVal.append('\n');
                ++count;
            }
            if ((t = t.getCause()) == null) continue;
            retVal.append(" Caused by ").append(t.toString());
            pref = "\t" + pref;
        }
        return retVal.toString();
    }

    public static boolean getBooleanFromEnv(TestEnvironment env, String name, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            String[] envData = env.lookup(name);
            if (envData != null && envData.length == 1) {
                value = Boolean.valueOf(envData[0]);
            }
        }
        catch (TestEnvironment.Fault tef) {
            // empty catch block
        }
        return value;
    }

    public static int getIntFromEnv(TestEnvironment env, String name, int defaultValue) {
        String[] envData = null;
        int n = defaultValue;
        try {
            envData = env.lookup(name);
            if (envData != null && envData.length == 1) {
                n = Integer.parseInt(envData[0]);
            }
        }
        catch (NumberFormatException nfe) {
        }
        catch (TestEnvironment.Fault tef) {
            // empty catch block
        }
        return n;
    }

    public static String getJarNameFromEnv(TestEnvironment env, String key) throws TestEnvironment.Fault, IllegalArgumentException, NullPointerException {
        File file = J2MEUtils.getJarFromEnv(env, key);
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static File getJarFromEnv(TestEnvironment env, String key) throws TestEnvironment.Fault, IllegalArgumentException, NullPointerException {
        String[] envData = env.lookup(key);
        if (envData == null || envData.length == 0) {
            throw new NullPointerException();
        }
        String jarName = envData[0];
        File f = new File(jarName);
        if (!J2MEUtils.fileExistsAndReadable(f)) {
            throw new IllegalArgumentException(jarName);
        }
        return f;
    }

    private static boolean fileExistsAndReadable(File file) {
        return file != null && !file.isDirectory() && file.canRead();
    }

    public static List<URL> getPathFromEnv(TestEnvironment env, String key) throws TestEnvironment.Fault, IllegalArgumentException, NullPointerException {
        ArrayList<URL> retVal = new ArrayList<URL>();
        String[] envData = null;
        envData = env.lookup(key);
        if (envData == null || envData.length == 0) {
            throw new NullPointerException();
        }
        String path = envData[0];
        for (String entry : path.split(File.pathSeparator)) {
            if (entry == null || entry.equals("")) continue;
            try {
                File f = new File(entry);
                if (!J2MEUtils.fileExistsAndReadable(f)) continue;
                retVal.add(new File(entry).toURI().toURL());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (retVal.size() == 0) {
            throw new IllegalArgumentException(path);
        }
        return retVal;
    }

    public static String getURLFmtAddress(String addr) {
        if (addr != null && addr.indexOf(58) != -1 && addr.indexOf(91) != 0) {
            return "[" + addr + "]";
        }
        return addr;
    }

    public static Class getParamClass(String name) throws Exception {
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("String")) {
            return String.class;
        }
        if (name.equals("String[]")) {
            return String[].class;
        }
        return Class.forName(name);
    }
}

