/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardServicesPool;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.CommunicationService;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.FrameworkException;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.javacard.referenceimpl.Logger;
import com.sun.tck.bvtool.etsi.gp.GPOverETSICardService;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import com.sun.tck.jc.javatest.services.BVTDiscoveryUtils;
import com.sun.tck.jc.javatest.services.LoggingService;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TerminalCardService
implements CJCKCardService {
    private StatefulCardTerminal terminal;
    private CJCKCardService service;
    private PrintWriter out;
    private PrintWriter ref;
    protected Logger log;
    protected Properties serviceProperties = new Properties();
    private Stack<AppletID> installedPackages = new Stack();
    private static final long PACKAGE_AID_LENGTH_POS = 12L;

    public TerminalCardService(CJCKCardService service) {
        this.service = service;
    }

    public void setCardTerminal(StatefulCardTerminal terminal) {
        this.terminal = terminal;
        if (this.service != null) {
            this.service.setCardTerminal(terminal);
        }
    }

    public StatefulCardTerminal getCardTerminal() {
        return this.terminal;
    }

    public CJCKCardService getBaseCardService() {
        return this.service;
    }

    public CommunicationService getCommunicationService(int iface) throws CardProxyException {
        return this.service.getCommunicationService(iface);
    }

    public String convertPackage(String packageName, AppletID packageAid, int majorVersion, int minorVersion, String classRootDir, String exportRootDir, boolean isExportMap, String outputRootDir, AppletProperties[] apa) throws FrameworkException {
        throw new UnsupportedOperationException(I18n.getString("cardservice.unsupported.operation"));
    }

    public boolean deleteAppletInstances(AppletProperties[] applets) throws CardProxyException {
        return this.service.deleteAppletInstances(applets);
    }

    public boolean deletePackage(AppletID packageID, String packageName) throws CardProxyException {
        boolean deleted = this.service.deletePackage(packageID, packageName);
        if (deleted) {
            this.installedPackages.remove(packageID);
        }
        return deleted;
    }

    public boolean deletePackageAndInstances(AppletID packageID, String packageName) throws CardProxyException {
        boolean deleted = this.service.deletePackageAndInstances(packageID, packageName);
        if (deleted) {
            this.installedPackages.remove(packageID);
        }
        return deleted;
    }

    public Hashtable getProperties() {
        return this.service.getProperties();
    }

    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        this.out = out;
        this.ref = ref;
        this.service.init(args, out, ref);
        this.log = new Logger(0, out, ref);
    }

    public boolean installCAPFile(AppletProperties[] appletPropertiesArray, String aCAPFileName, String outputDir) throws CardProxyException {
        boolean installed = this.service.installCAPFile(appletPropertiesArray, aCAPFileName, outputDir);
        if (installed) {
            this.installedPackages.push(TerminalCardService.getPackageID(aCAPFileName));
        }
        return installed;
    }

    public boolean loadCapFileApplets(String[] capfiles, AppletProperties[] appletProperties, String outputRootDir) throws DeploymentException {
        throw new UnsupportedOperationException(I18n.getString("cardservice.unsupported.operation"));
    }

    public boolean loadClassFileApplets(String[] packageNames, AppletProperties[] appletProperties, String classRootDir, String outputRootDir) throws DeploymentException {
        throw new UnsupportedOperationException(I18n.getString("cardservice.unsupported.operation"));
    }

    public void powerDown() throws CardProxyException {
        this.service.powerDown();
    }

    public void powerUp() throws CardProxyException {
        this.service.powerUp();
    }

    public void reset() throws CardProxyException {
        this.service.reset();
    }

    public ResponseAPDU sendAPDU(CommandAPDU capdu) throws CardProxyException {
        return this.service.sendAPDU(capdu);
    }

    public void startTest(String workingDir, int numberOfExecutions) throws CardProxyException {
        this.service.startTest(workingDir, numberOfExecutions);
    }

    public void deleteInstalledPackages() throws CardProxyException {
        this.reset();
        while (!this.installedPackages.isEmpty()) {
            AppletID aid = this.installedPackages.peek();
            boolean deleted = this.deletePackageAndInstances(aid, aid.toString());
            if (deleted) continue;
            throw new FrameworkException(I18n.getString("package.deletion.failed", aid.toString()));
        }
    }

    public void stopTest() throws CardProxyException {
        this.service.stopTest();
    }

    public void releaseTerminal() {
        CardServicesPool.releaseTerminal(this.terminal);
    }

    public boolean initializeCardService() {
        LoggingService log = BVTDiscoveryUtils.getLogger();
        log.log("GPCasrdService", "In initializeCardService() for {0}", this.terminal);
        if (this.service != null && this.service instanceof GPOverETSICardService) {
            try {
                ((GPOverETSICardService)this.service).setCard(this.terminal.getInsertedCard());
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return true;
    }

    public StatefulCardTerminal.State getState() {
        return this.terminal.getState();
    }

    public String getTerminalName() {
        return this.terminal.getLabel();
    }

    public void setTerminalName(String name) {
        this.terminal.setLabel(name);
    }

    public String toString() {
        return "GPCardService for terminal: " + this.terminal;
    }

    public void setState(StatefulCardTerminal.State state) {
        this.terminal.setState(state);
        LoggingService log = BVTDiscoveryUtils.getLogger();
        log.log("GPCasrdService", "CardService state set to {0}", new Object[]{state});
    }

    private static AppletID getPackageID(String capFileName) throws DeploymentException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(capFileName);
        }
        catch (IOException ex) {
            throw new DeploymentException(I18n.getString("no.cap.file", capFileName));
        }
        ZipEntry headerEntry = null;
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith("Header.cap")) continue;
            headerEntry = entry;
            break;
        }
        AppletID aid = null;
        InputStream in = null;
        if (headerEntry != null) {
            try {
                in = zip.getInputStream(headerEntry);
                in.skip(12L);
                int packageAidLength = in.read();
                byte[] aidBytes = new byte[packageAidLength];
                in.read(aidBytes, 0, packageAidLength);
                aid = new AppletID(aidBytes);
            }
            catch (IOException ex) {
                throw new DeploymentException(I18n.getString("error.reading.package.aid", capFileName));
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        return aid;
    }
}

