/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.security;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum KeyType {
    DES_CBC(1, "DES/CBC/NoPadding"),
    DES_ECB(13, "DES/ECB/NoPadding"),
    TRIPLE_DES_CBC_2_OF_3(5, "DESede/CBC/NoPadding"),
    TRIPLE_DES_CBC(9, "DESede/CBC/NoPadding");

    private byte code;
    private String name;

    private KeyType(int code, String name) {
        this.code = (byte)code;
        this.name = name;
    }

    public Cipher createCipher(int mode, byte[] password, boolean doEncrypt) throws GeneralSecurityException {
        Cipher retVal = Cipher.getInstance(this.name);
        if (this.name.indexOf("/CBC/") > 0) {
            byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            if (doEncrypt) {
                Cipher step = Cipher.getInstance(this.name);
                IvParameterSpec paramSpec = new IvParameterSpec(iv);
                step.init(mode, KeyType.createKeyForSignature(this.name, password), paramSpec);
                iv = step.doFinal(iv);
            }
            IvParameterSpec paramSpec = new IvParameterSpec(iv);
            retVal.init(mode, KeyType.createKeyForSignature(this.name, password), paramSpec);
        } else {
            retVal.init(mode, KeyType.createKeyForSignature(this.name, password));
        }
        return retVal;
    }

    public byte getCode() {
        return this.code;
    }

    public static Key createKeyForSignature(String sigName, byte[] password) throws GeneralSecurityException {
        KeySpec spec;
        String keyName = sigName.substring(0, sigName.indexOf(47));
        SecretKeyFactory factory = SecretKeyFactory.getInstance(keyName);
        if ("DES".equals(keyName)) {
            spec = new DESKeySpec(password);
        } else {
            byte[] data;
            if (password.length < 24) {
                data = new byte[24];
                System.arraycopy(password, 0, data, 0, password.length);
                System.arraycopy(password, 0, data, password.length, 24 - password.length);
            } else {
                data = password;
            }
            spec = new DESedeKeySpec(data);
        }
        return factory.generateSecret(spec);
    }
}

