/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.gp;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardServicesPool;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommunicationService;
import com.sun.javacard.cjck.userinterface.FatalException;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.tck.bvtool.etsi.gp.ExternalAuthenticator;
import com.sun.tck.bvtool.etsi.gp.GPCapFileInfo;
import com.sun.tck.bvtool.etsi.gp.GPConstants;
import com.sun.tck.bvtool.etsi.gsm.StatusCodes;
import com.sun.tck.bvtool.etsi.security.KeyDescr;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLV;
import com.sun.tck.bvtool.etsi.tlv.TLVEncoder;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import com.sun.tck.me.utils.CommandLineAdapter;
import com.sun.tck.me.utils.Utils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CommandAPDU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPCardService
implements CJCKCardService {
    boolean isInSession;
    boolean isInGPAction;
    private byte GET_RESPONSE_CLA_BYTE = 0;
    private StatefulCardTerminal terminal;
    protected boolean includeMakeSelectable = true;
    private static final byte GP_CLA = -128;
    private static final byte JC_CM_CLA = 0;
    private static final byte DELETE_INS = -28;
    private static final byte INSTALL_INS = -26;
    private static final byte LOAD_INS = -24;
    private static final byte SELECT_INS = -92;
    private static final byte SELECT_BY_DF_NAME = 4;
    private static final byte AID_TAG = 79;
    public static final byte APPLICATION_SPECIFIC_PARAMETERS_TAG = -55;
    public static final byte SYSTEM_SPECIFIC_PARAMETERS_TAG = -17;
    public static final byte VOLATILE_DATA_SPACE_LIMIT_TAG = -57;
    public static final byte NON_VOLATILE_DATA_SPACE_LIMIT_TAG = -56;
    public static final byte SECURITY_DOMAIN_PRIVILEDGE = -128;
    public static final byte DAP_VERIFICATION_PRIVILEDGE = -64;
    public static final byte DELEGATED_MANAGEMENT_PRIVILEDGE = -96;
    public static final byte CARD_LOCK_PRIVILEDGE = 16;
    public static final byte CARD_TERMINATE_PRIVILEDGE = 8;
    public static final byte DEFAULT_SELECTED_PRIVILEDGE = 4;
    public static final byte CVM_MANAGEMENT_PRIVILEDGE = 2;
    public static final byte MANDATED_DAP_VERIFICATION_PRIVILEDGE = -63;
    private static final int SW_OK = 36864;
    private static final int HEADER_LENGTH = 37;
    private static final int APDU_LENGTH = 254;
    private static final int APDU_LENGTH_NET = 217;
    public PrintWriter out;
    protected PrintWriter ref;
    private CardReader cad = new CardReader();
    private KeyDescr key;
    protected TLVPrototypeFactory parser;
    protected com.sun.tck.bvtool.terminal.Card card;
    private static final byte[] EMPTY = new byte[0];
    String wA = "A0:00:00:00:62:03:01:0A:01:01:02:01:04:05:01:81";
    private int resetDelay = 0;
    private byte[] installerAid = Utils.parse("A000000003000000");

    public void setIncludeMakeSelectable(boolean includeMakeSelectable) {
        this.includeMakeSelectable = includeMakeSelectable;
    }

    @Override
    public CommunicationService getCommunicationService(int i) throws CardProxyException {
        return this;
    }

    @Override
    public void setCardTerminal(StatefulCardTerminal terminal) {
        this.terminal = terminal;
        this.cad = new CardReader(terminal);
        this.card = terminal.getInsertedCard();
    }

    protected StatefulCardTerminal getCardTerminal() {
        return this.terminal;
    }

    public void setCad(CardReader cad) {
        this.cad = cad;
    }

    public TLVPrototypeFactory getFactory() {
        return this.parser;
    }

    @Override
    public void startTest(String workingDir, int numberOfExecutions) throws CardProxyException {
        this.cad.init(this.out);
        this.resetCard();
    }

    public void resetCard() throws CardProxyException {
        this.powerUp();
        this.sendAPDU(new com.sun.javacard.cjck.userinterface.CommandAPDU(Utils.parse("D08111222000112233445566778899aabbccddeeff00112233445566778899aabbccddeeff")));
        this.sendAPDU(new com.sun.javacard.cjck.userinterface.CommandAPDU(Utils.parse("D080010000")));
        this.sendAPDU(new com.sun.javacard.cjck.userinterface.CommandAPDU(Utils.parse("D08000003A11FF050001000005404142434445464748494A4B4C4D4E4F404142434445464748494A4B4C4D4E4F404142434445464748494A4B4C4D4E4F0215")));
    }

    private ResponseAPDU send(String apdu) throws CardProxyException {
        return this.send(new com.sun.javacard.cjck.userinterface.CommandAPDU(Utils.parse(apdu)));
    }

    private ResponseAPDU send(com.sun.javacard.cjck.userinterface.CommandAPDU apdu) throws CardProxyException {
        ResponseAPDU answer = this.sendApduToCardManager(apdu);
        if (!GPCardService.isOk(answer)) {
            throw new CardProxyException("Unknown SW:0x" + Integer.toHexString(answer.sw() & 0xFFFF));
        }
        return answer;
    }

    @Override
    public void stopTest() throws CardProxyException {
        try {
            this.cad.release();
        }
        catch (Exception e) {
            e.printStackTrace(this.out);
        }
    }

    @Override
    public void powerUp() throws CardProxyException {
        this.isInSession = false;
        this.out("GP.powerUp()");
        this.cad.powerUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void powerDown() throws CardProxyException {
        this.out("GP.powerDown()");
        try {
            this.cad.powerDown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CardProxyException(I18n.getString("power.down.exception", ex));
        }
        if (this.resetDelay > 0) {
            GPCardService gPCardService = this;
            synchronized (gPCardService) {
                try {
                    this.wait(this.resetDelay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String convertPackage(String packageName, AppletID packageAid, int majorVersion, int minorVersion, String classRootDir, String exportRootDir, boolean isExportMap, String outputRootDir, AppletProperties[] apa) throws CardProxyException {
        throw new UnsupportedOperationException(I18n.getString("not.supported.yet"));
    }

    @Override
    public boolean loadClassFileApplets(String[] packageNames, AppletProperties[] appletProperties, String classRootDir, String outputRootDir) throws CardProxyException {
        throw new UnsupportedOperationException(I18n.getString("not.supported.yet"));
    }

    @Override
    public boolean loadCapFileApplets(String[] capfiles, AppletProperties[] appletProperties, String outputRootDir) throws CardProxyException {
        throw new UnsupportedOperationException(I18n.getString("not.supported.yet"));
    }

    public void selectInstaller() throws CardProxyException {
        this.out("GP.selectInstaller");
        if (!this.isInSession) {
            com.sun.javacard.cjck.userinterface.CommandAPDU extAuth;
            com.sun.javacard.cjck.userinterface.CommandAPDU apdu = new com.sun.javacard.cjck.userinterface.CommandAPDU(0, -92, 4, 0, this.installerAid, 0);
            ResponseAPDU answer = this.sendAPDU(apdu);
            if (!GPCardService.isOk(answer)) {
                throw new CardProxyException(I18n.getString("can.not.select.installer"));
            }
            this.out("START SESSION");
            answer = this.send("80 50 00 00 08 11 22 33 44 55 66 77 88 00");
            ExternalAuthenticator auth = new ExternalAuthenticator("4041424344454647 48494A4B4C4D4E4F", "4041424344454647 48494A4B4C4D4E4F");
            try {
                extAuth = auth.createAnswer(Utils.parse("1122334455667788"), answer.getResponseData());
            }
            catch (Exception e) {
                e.printStackTrace(this.out);
                throw new CardProxyException(I18n.getString("can.not.create.external.authenticate", e));
            }
            this.send(extAuth);
            this.isInSession = true;
        }
    }

    public void startSession() throws CardProxyException {
        byte[] hostChallenge = Utils.parse("11 22 33 44 55 66 77 88 00");
        ResponseAPDU answer = this.send("80 50 00 00 08 11 22 33 44 55 66 77 88 00");
        byte[] data = answer.getBytes();
        byte[] challenge = new byte[24];
        System.arraycopy(data, 12, challenge, 0, 8);
        System.arraycopy(hostChallenge, 0, challenge, 8, 8);
        challenge[16] = -128;
        this.send(new com.sun.javacard.cjck.userinterface.CommandAPDU(-124, -126, 0, 0, this.createExternalAuthenticate(challenge), 0));
    }

    private byte[] createExternalAuthenticate(byte[] request) throws CardProxyException {
        byte[] retVal = new byte[16];
        try {
            this.key.checksum.update(request, 0, request.length);
            byte[] hostCryptogram = this.key.checksum.calculateCheckSum();
            System.arraycopy(hostCryptogram, 0, retVal, 0, 8);
        }
        catch (GeneralSecurityException e) {
            throw new CardProxyException(I18n.getString("can.not.create.response", e));
        }
        return retVal;
    }

    @Override
    public boolean installCAPFile(AppletProperties[] applets, String catFile, String outputDir) throws CardProxyException {
        this.isInGPAction = true;
        try {
            this.selectInstaller();
            GPCapFileInfo info = GPCapFileInfo.createData(this.out, catFile);
            for (AppletProperties apl : applets) {
                if (apl.getPackageAID() != null) continue;
                apl.setPackageAID(info.packageAID);
            }
            if (this.card != null) {
                this.card.notifyRegisteredCapFile(info.packageAID, applets);
            }
            boolean bl = this.load(info) && this.install(info, applets);
            Object var10_11 = null;
            this.isInGPAction = false;
            return bl;
        }
        catch (Exception e) {
            try {
                if (e instanceof CardProxyException) {
                    throw (CardProxyException)e;
                }
                e.printStackTrace(this.out);
                throw new CardProxyException(I18n.getString("io.exception.cap.installation", e));
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.isInGPAction = false;
                throw throwable;
            }
        }
    }

    public boolean load(GPCapFileInfo info) throws CardProxyException, EncodingException {
        this.out("GP.load " + info);
        if (!this.installForLoad(info)) {
            this.out("!! install for load fails.");
            return false;
        }
        ArrayList<com.sun.javacard.cjck.userinterface.CommandAPDU> list = this.dataToLoadApdus(info.data);
        this.out("list.length=" + list.size());
        List<ResponseAPDU> answers = this.sendApduListToCardManager(list.toArray(new com.sun.javacard.cjck.userinterface.CommandAPDU[list.size()]));
        GPConstants data = GPConstants.getLoad();
        for (ResponseAPDU answer : answers) {
            this.out("STATUS: " + data.findName(answer.sw()));
            if (GPCardService.isOk(answer)) continue;
            return false;
        }
        return true;
    }

    public boolean installForLoad(GPCapFileInfo info) throws CardProxyException {
        this.out("GP.installForLoad " + info);
        AppletID aid = info.packageAID;
        byte[] aidBytes = aid.getBytes();
        byte[] data = new byte[aidBytes.length + 5];
        int offset = 0;
        offset = this.encodeArrayAsLV(data, offset, aidBytes);
        data[offset++] = 0;
        data[offset++] = 0;
        data[offset++] = 0;
        data[offset++] = 0;
        com.sun.javacard.cjck.userinterface.CommandAPDU apdu = new com.sun.javacard.cjck.userinterface.CommandAPDU(-128, -26, 2, 0, data, 1);
        ResponseAPDU answer = this.sendApduToCardManager(apdu);
        this.out("STATUS: " + GPConstants.getInstall().findName(answer.sw()));
        return GPCardService.isOk(answer);
    }

    private static byte[] nullToEmpty(byte[] data) {
        return data == null ? EMPTY : data;
    }

    public boolean installForInstall(String name, AppletID packageID, AppletProperties applet, boolean includeMakeSelectable) throws EncodingException, CardProxyException {
        this.out("GP.installForInstall " + name + applet + " includeMakeSelectable=" + includeMakeSelectable);
        TLVEncoder out = new TLVEncoder(1024);
        byte[] packAidBytes = packageID.getBytes();
        byte[] appletAidBytes = applet.getAID().getBytes();
        this.encodeArrayAsLV(out, packAidBytes);
        this.encodeArrayAsLV(out, appletAidBytes);
        this.encodeArrayAsLV(out, appletAidBytes);
        out.out().write(1);
        out.out().write(applet.getPriviledges());
        out.startLV("Install parameters field");
        this.encodeInstallParameters(out, applet);
        out.end("Install parameters field");
        out.out().write(0);
        byte p1 = (byte)(includeMakeSelectable ? 12 : 4);
        com.sun.javacard.cjck.userinterface.CommandAPDU apdu = new com.sun.javacard.cjck.userinterface.CommandAPDU(-128, -26, p1, 0, out.toByteArray(), 1);
        ResponseAPDU answer = this.sendApduToCardManager(apdu);
        this.out("STATUS: " + GPConstants.getInstall().findName(answer.sw()));
        return GPCardService.isOk(answer);
    }

    protected void encodeInstallParameters(TLVEncoder out, AppletProperties applet) throws EncodingException {
        byte[] applicationParams = GPCardService.nullToEmpty(applet.getParms());
        byte[] gpParams = applet.getGPParameters();
        if (gpParams != null) {
            out.out().write(gpParams);
        } else {
            out.startTag(-55);
            out.out().write(applicationParams);
            out.end();
            this.encodeNonZeroShortAsTLV(out, (byte)-57, applet.getVolatileSpace());
            this.encodeNonZeroShortAsTLV(out, (byte)-57, applet.getNonVolatileSpace());
        }
    }

    private void encodeNonZeroShortAsTLV(TLVEncoder out, byte tag, int value) throws EncodingException {
        if (value != 0) {
            out.startTag(tag);
            out.out().write(value, 2);
            out.end();
        }
    }

    public boolean installForMakeSelectable(String name, AppletProperties applet) throws CardProxyException {
        this.out("GP.installForMakeSelectable " + name + " " + applet);
        byte[] aidBytes = applet.getAID().getBytes();
        byte[] data = new byte[7 + aidBytes.length];
        int pos = 0;
        data[pos++] = 0;
        data[pos++] = 0;
        pos = this.encodeArrayAsLV(data, pos, aidBytes);
        data[pos++] = 1;
        data[pos++] = 0;
        data[pos++] = 0;
        data[pos++] = 0;
        com.sun.javacard.cjck.userinterface.CommandAPDU apdu = new com.sun.javacard.cjck.userinterface.CommandAPDU(-128, -26, 8, 0, data, 1);
        ResponseAPDU answer = this.sendApduToCardManager(apdu);
        this.out("STATUS: " + GPConstants.getInstall().findName(answer.sw()));
        return GPCardService.isOk(answer);
    }

    public boolean deleteObject(AppletID aid, boolean deleteRelated) throws CardProxyException {
        this.out("GP.deleteObject " + aid + " deleteRelated=" + deleteRelated);
        this.selectInstaller();
        byte p2 = (byte)(deleteRelated ? 128 : 0);
        byte[] aidBytes = aid.getBytes();
        byte[] data = new byte[aidBytes.length + 2];
        data[0] = 79;
        this.encodeArrayAsLV(data, 1, aidBytes);
        com.sun.javacard.cjck.userinterface.CommandAPDU apdu = new com.sun.javacard.cjck.userinterface.CommandAPDU(-128, -28, 0, p2, data, 0);
        ResponseAPDU answer = this.sendApduToCardManager(apdu);
        this.out("STATUS: " + GPConstants.getDelete().findName(answer.sw()));
        return GPCardService.isOk(answer);
    }

    private int encodeArrayAsLV(byte[] out, int offset, byte[] data) {
        out[offset++] = (byte)data.length;
        System.arraycopy(data, 0, out, offset, data.length);
        return offset + data.length;
    }

    private void encodeArrayAsLV(TLVEncoder out, byte[] data) {
        out.out().write(data.length);
        out.out().write(data);
    }

    public static boolean isOk(ResponseAPDU answer) {
        return StatusCodes.isOkOrWarning(answer.sw());
    }

    public int getHeaderLength() {
        return 0;
    }

    private ArrayList<com.sun.javacard.cjck.userinterface.CommandAPDU> dataToLoadApdus(TLV tlv) throws EncodingException {
        byte[] data = tlv.toByteArray();
        return this.dataToLoadApdus(data, 0, data.length);
    }

    public ArrayList<com.sun.javacard.cjck.userinterface.CommandAPDU> dataToLoadApdus(byte[] data, int offset, int length) {
        ArrayList<com.sun.javacard.cjck.userinterface.CommandAPDU> retVal = new ArrayList<com.sun.javacard.cjck.userinterface.CommandAPDU>();
        int blockNumber = 0;
        int limit = offset + length;
        int apduLengthNet = 254 - this.getHeaderLength();
        int pos = offset;
        while (pos < limit) {
            int blockLength = Math.min(apduLengthNet, data.length - pos);
            byte[] apduData = new byte[blockLength];
            System.arraycopy(data, pos, apduData, 0, blockLength);
            byte controlParameter = (pos += blockLength) == data.length ? (byte)-128 : 0;
            retVal.add(new com.sun.javacard.cjck.userinterface.CommandAPDU(-128, -24, controlParameter, (byte)blockNumber++, apduData, (byte)(pos >= limit ? 1 : 0)));
        }
        return retVal;
    }

    public boolean install(GPCapFileInfo info, AppletProperties[] appletPropertiesArray) throws EncodingException, CardProxyException {
        boolean retVal = true;
        for (AppletProperties appletProperties : appletPropertiesArray) {
            boolean bl = retVal = this.installForInstall(info.toString(), info.packageAID, appletProperties, this.includeMakeSelectable) && retVal;
            if (this.includeMakeSelectable) continue;
            retVal = this.installForMakeSelectable(String.valueOf(info), appletProperties) && retVal;
        }
        return retVal;
    }

    @Override
    public void reset() throws CardProxyException {
        this.powerDown();
        this.powerUp();
    }

    @Override
    public ResponseAPDU sendAPDU(com.sun.javacard.cjck.userinterface.CommandAPDU capdu) throws CardProxyException {
        if (!this.isInGPAction) {
            this.isInSession = false;
        }
        this.out("  CAD:<<< " + capdu);
        ResponseAPDU retVal = this.cad.sendAPDU(capdu);
        this.out("  CAD:>>> " + retVal);
        this.out.flush();
        return retVal;
    }

    @Override
    public Hashtable getProperties() {
        throw new UnsupportedOperationException(I18n.getString("not.supported.yet"));
    }

    protected Object[] getConfigurables() {
        return new Object[]{this};
    }

    @Override
    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        this.out = out;
        this.ref = ref;
        if (args == null) {
            return;
        }
        try {
            Object[] configurables = this.getConfigurables();
            CommandLineAdapter adapter = new CommandLineAdapter(configurables);
            adapter.init(args);
            this.validate(configurables);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unexpected", e);
        }
        this.out("(DRIVER type=" + this.cad.getClass().getSimpleName() + ")");
    }

    public void validate(Object[] configurables) throws Exception {
    }

    @Override
    public boolean deleteAppletInstances(AppletProperties[] applets) throws CardProxyException {
        boolean retVal = true;
        for (AppletProperties applet : applets) {
            boolean status = this.deleteObject(applet.getAID(), false);
            if (status && this.card != null) {
                this.card.notifyDeletedCapFile(applet.getAID());
            }
            retVal = status && retVal;
        }
        return retVal;
    }

    @Override
    public boolean deletePackage(AppletID packageID, String packageName) throws CardProxyException {
        boolean retVal = this.deleteObject(packageID, false);
        if (retVal && this.card != null) {
            this.card.notifyDeletedCapFile(packageID);
        }
        return retVal;
    }

    @Override
    public boolean deletePackageAndInstances(AppletID packageID, String packageName) throws CardProxyException {
        boolean retVal = this.deleteObject(packageID, true);
        if (retVal && this.card != null) {
            this.card.notifyDeletedCapFile(packageID);
        }
        return retVal;
    }

    public List<ResponseAPDU> sendApduListToCardManager(com.sun.javacard.cjck.userinterface.CommandAPDU ... apdus) throws CardProxyException {
        ArrayList<ResponseAPDU> retVal = new ArrayList<ResponseAPDU>();
        for (com.sun.javacard.cjck.userinterface.CommandAPDU apdu : apdus) {
            retVal.add(this.sendApduToCardManager(apdu));
        }
        return retVal;
    }

    public ResponseAPDU sendApduToCardManager(com.sun.javacard.cjck.userinterface.CommandAPDU apdu) throws CardProxyException {
        ResponseAPDU answer = this.sendAPDU(apdu);
        int sw = answer.sw();
        if ((sw & 0xFF00) != 24832) {
            return answer;
        }
        ArrayList<ResponseAPDU> list = new ArrayList<ResponseAPDU>();
        int length = 0;
        while ((sw & 0xFF00) == 24832 || (sw & 0xFF00) == 25088) {
            list.add(answer);
            length += answer.getLe();
            answer = this.sendAPDU(this.getGetResponseAPDU(apdu.getCLA(), sw));
            sw = answer.sw();
        }
        list.add(answer);
        byte[] data = new byte[(length += answer.getLe()) + 2];
        int offset = 0;
        for (ResponseAPDU current : list) {
            for (int i = 0; i < answer.getLe(); ++i) {
                data[offset++] = (byte)current.getData(i);
            }
        }
        data[offset++] = (byte)(sw >> 8);
        data[offset++] = (byte)sw;
        return new ResponseAPDU(data);
    }

    private com.sun.javacard.cjck.userinterface.CommandAPDU getGetResponseAPDU(byte original_cla, int sw) {
        return new com.sun.javacard.cjck.userinterface.CommandAPDU(new byte[]{(byte)(this.GET_RESPONSE_CLA_BYTE & 0xF0 | original_cla & 0xF), -64, 0, 0, (byte)sw});
    }

    private AppletProperties parse(String[] list, int offset) {
        AppletProperties retVal = new AppletProperties("unknown.package", null, "unknown.class");
        retVal.setAID(new AppletID(Utils.parse(list[offset++])));
        if (offset >= list.length) {
            return retVal;
        }
        if (list[offset].startsWith("app:")) {
            retVal.setParms(Utils.parse(list[offset].substring(4)));
        } else if (!list[offset].isEmpty()) {
            retVal.setGPParameters(Utils.parse(list[offset]));
        }
        if (list.length > ++offset && list[offset].length() > 0) {
            retVal.setPriviledges(Integer.parseInt(list[offset++], 16));
        }
        return retVal;
    }

    public boolean install(String[] args) throws Exception {
        String capFile = args[0];
        AppletProperties[] applets = new AppletProperties[args.length - 1];
        for (int i = 0; i < applets.length; ++i) {
            applets[i] = this.parse(args[i + 1].split(","), 0);
        }
        boolean retVal = this.installCAPFile(applets, capFile, ".");
        StringBuilder line = new StringBuilder("install(capFile=").append(capFile);
        for (AppletProperties applet : applets) {
            line.append(" ").append(applet.getAID());
        }
        line.append(")");
        this.out(line + (retVal ? " is SUCCESSFUL" : " is FAILED"));
        return retVal;
    }

    public void installApplet(String[] args) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException(I18n.getString("aid.not.defined"));
        }
        String val = args[0];
        AppletID parent = Utils.isHexString(val) ? new AppletID(Utils.parse(val)) : GPCapFileInfo.createData((PrintWriter)this.out, (String)val).packageAID;
        AppletProperties applet = this.parse(args, 1);
        boolean status = this.installForInstall(val, parent, applet, this.includeMakeSelectable);
        this.out("INSTALL(for INSTALL) " + (status ? "PASSED" : "FAILED"));
        if (status && !this.includeMakeSelectable) {
            status = this.installForMakeSelectable(val, applet);
            this.out("INSTALL(for MAKE SELECTABLE) " + (status ? "PASSED" : "FAILED"));
        }
    }

    public void delete_Package(String[] args) throws IOException, CardProxyException {
        AppletID aid = new AppletID(Utils.parse(args[0]));
        boolean status = this.deletePackage(aid, "no-name");
        this.out("deletePackage(" + aid + ") returns " + status);
    }

    public void delete_Applet(String[] args) throws IOException, CardProxyException {
        AppletProperties applet = new AppletProperties("no-name", null, "no-name");
        AppletID aid = new AppletID(Utils.parse(args[0]));
        applet.setAID(aid);
        boolean status = this.deleteAppletInstances(new AppletProperties[]{applet});
        this.out("deleteApplet(" + aid + ") returns " + status);
    }

    public void delete(String[] args) throws IOException, CardProxyException {
        AppletID aid = new AppletID(Utils.parse(args[0]));
        boolean status = this.deletePackageAndInstances(aid, "no-name");
        this.out("deletePackageAndInstances(" + aid + ") returns " + status);
    }

    public ResponseAPDU select(String aid) throws CardProxyException {
        byte[] bytes = Utils.parse(aid);
        return this.sendAPDU(new com.sun.javacard.cjck.userinterface.CommandAPDU(0, -92, 4, 0, bytes, 127));
    }

    public void setDriver(String driver) throws Exception {
        CardReader cad;
        if (driver.equalsIgnoreCase("java")) {
            cad = new CardReader();
        } else {
            String name = "com.sun.tck.bvtool.etsi.gp." + driver;
            cad = (CardReader)Class.forName(name).newInstance();
        }
        this.setCad(cad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: <installer AID> <command> [<cap file>] [config file]");
            return;
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter(System.out));
        try {
            GPCardService service = new GPCardService();
            service.setDriver("JPCSC");
            service.init(new String[]{args[0]}, out, out);
            service.startTest(".", 10);
            String[] methArgs = new String[args.length - 2];
            System.arraycopy(args, 2, methArgs, 0, methArgs.length);
            String command = args[1];
            GPCardService.invoke(service, command, methArgs);
            Object var6_5 = null;
            out.flush();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            out.flush();
            throw throwable;
        }
    }

    public static Object invoke(Object instance, String name, String[] args) throws Exception {
        try {
            Method meth = instance.getClass().getMethod(name, args.getClass());
            return meth.invoke(instance, new Object[]{args});
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw e;
        }
        Method meth = instance.getClass().getMethod(name, args.getClass());
        return meth.invoke(instance, new Object[0]);
    }

    public void out(String msg) {
        if (this.out == null) {
            System.out.println(msg);
        } else {
            this.out.println(msg);
            this.out.flush();
        }
    }

    public void stop() throws Exception {
        if (this.cad != null) {
            this.cad.stop();
        }
    }

    public static class CardReader {
        private StatefulCardTerminal terminal;
        private Card card;

        public CardReader(StatefulCardTerminal terminal) {
            this.terminal = terminal;
        }

        public CardReader() {
        }

        public void init(PrintWriter out) throws FatalException {
            if (this.terminal == null) {
                this.terminal = CardServicesPool.getAvailableTerminals().get(0);
            }
            try {
                this.terminal.waitForCardPresent(600000L);
            }
            catch (CardException ex) {
                throw new FatalException(FatalException.Scope.CAD, I18n.getString("card.exception.waitforpresent", ex));
            }
            this.card = this.terminal.connectToCard("*");
            out.println("ATR: bytes: 0x" + Utils.canonize(this.card.getATR().getBytes()) + " historical bytes: 0x" + Utils.canonize(this.card.getATR().getHistoricalBytes()));
            out.flush();
        }

        public ResponseAPDU sendAPDU(com.sun.javacard.cjck.userinterface.CommandAPDU capdu) throws FatalException {
            CommandAPDU scApdu = new CommandAPDU(capdu.getBytes());
            try {
                javax.smartcardio.ResponseAPDU scAnswer = this.card.getBasicChannel().transmit(scApdu);
                return new ResponseAPDU(scAnswer.getBytes());
            }
            catch (CardNotPresentException ex) {
                throw new FatalException(FatalException.Scope.Card, I18n.getString("cardnopresent.exception.transmit", ex));
            }
            catch (CardException ex) {
                try {
                    if (!this.terminal.isCardPresent()) {
                        throw new FatalException(FatalException.Scope.Card, I18n.getString("card.exception.transmit", ex));
                    }
                }
                catch (CardException ex2) {
                    // empty catch block
                }
                throw new FatalException(FatalException.Scope.CAD, I18n.getString("card.exception.transmit", ex));
            }
        }

        public void powerUp() throws FatalException {
            this.card = this.terminal.connectToCard("*");
        }

        public void powerDown() throws FatalException {
            try {
                this.card.disconnect(true);
            }
            catch (CardException ex) {
                throw new FatalException(FatalException.Scope.Card, I18n.getString("card.exception.disconnect", ex));
            }
        }

        public void release() throws Exception {
        }

        public void stop() throws Exception {
            if (this.terminal != null) {
                this.terminal.close();
            }
        }
    }
}

