/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.data.sms;

import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.FatalException;
import com.sun.tck.bvtool.etsi.data.CompactApduPacket;
import com.sun.tck.bvtool.etsi.data.sms.Phone;
import com.sun.tck.bvtool.etsi.data.sms.SMSParser;
import com.sun.tck.bvtool.etsi.tlv.ConstructedTLV;
import com.sun.tck.bvtool.etsi.tlv.Encodable;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.RawTLV;
import com.sun.tck.bvtool.etsi.tlv.TLV;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TreeNode;
import com.sun.tck.bvtool.terminal.Card;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMS_PP_TLV
extends ConstructedTLV {
    private Phone phone = new Phone(new byte[]{18, 52, 86, 120});
    private Phone serviceCenterPhone = new Phone(new byte[]{17, 51, 85, 119});
    private Encodable packet;
    private Date date;
    private boolean isConcatinated = false;
    private byte refNumber;
    private byte sequenceNumber;
    private byte numberOfMessages;
    StringBuffer tpduString = new StringBuffer("    TPDU={\n");
    private static int refCount = 0;

    public TLV createDeviceIdentities() {
        return new RawTLV(-126, new byte[]{-125, -127});
    }

    public TLV createTPDU() throws EncodingException {
        TLVBuffer out = new TLVBuffer(256);
        out.write(64);
        this.tpduString.append("        header=0x40\n");
        this.serviceCenterPhone.encodeTP_OA(out);
        this.encodeTP_PID(out);
        this.encodeTP_DCS(out);
        SMS_PP_TLV.encodeTP_SCTS(out, this.date);
        this.encodeTP_UD_as_LV(out);
        byte[] data = new byte[out.getPos()];
        System.arraycopy(out.getBuffer(), 0, data, 0, data.length);
        return new RawTLV(-117, data);
    }

    private void encodeTP_PID(TLVBuffer out) {
        this.tpduString.append("        TP_PID=0x7F\n");
        out.write(127);
    }

    private void encodeTP_DCS(TLVBuffer out) {
        this.tpduString.append("        TP_DCS=0xF6\n");
        out.write(246);
    }

    private static void encodeTP_SCTS(TLVBuffer out, Date current) {
        current = current == null ? new Date() : current;
        Calendar cal = Calendar.getInstance();
        cal.setTime(current);
        out.write(SMSParser.swapNibble(cal.get(1) % 100, 10));
        out.write(SMSParser.swapNibble(cal.get(2) + 1, 10));
        out.write(SMSParser.swapNibble(cal.get(5), 10));
        out.write(SMSParser.swapNibble(cal.get(11), 10));
        out.write(SMSParser.swapNibble(cal.get(12), 10));
        out.write(SMSParser.swapNibble(cal.get(13), 10));
        int timezone = cal.getTimeZone().getOffset(current.getTime()) / 900000;
        if (timezone < 0) {
            out.write(SMSParser.swapNibble(-timezone, 10) | 8);
        } else {
            out.write(SMSParser.swapNibble(timezone, 10));
        }
    }

    private static Date decodeTP_SCTS(TLVBuffer in) throws EncodingException {
        Calendar cal = Calendar.getInstance();
        cal.set(1, SMSParser.swapNibble(in.read(), 16, 10) + 2000);
        cal.set(2, SMSParser.swapNibble(in.read(), 16, 10) - 1);
        cal.set(5, SMSParser.swapNibble(in.read(), 16, 10));
        cal.set(11, SMSParser.swapNibble(in.read(), 16, 10));
        cal.set(12, SMSParser.swapNibble(in.read(), 16, 10));
        cal.set(13, SMSParser.swapNibble(in.read(), 16, 10));
        int tmz = in.read();
        int sign = (tmz & 8) != 0 ? -1 : 1;
        tmz = SMSParser.swapNibble(tmz & 0xF7, 16, 10) * sign;
        cal.setTimeZone(new SimpleTimeZone(tmz * 15 * 60000, "RawOffset"));
        return cal.getTime();
    }

    private void encodeUDHL(TLVBuffer out) {
        if (this.isConcatinated) {
            out.write(this.sequenceNumber == 1 ? 7 : 5);
            out.write(0);
            out.write(3);
            out.write(this.refNumber);
            out.write(this.numberOfMessages);
            out.write(this.sequenceNumber);
            if (this.sequenceNumber == 1) {
                out.write(112);
                out.write(0);
            }
        } else {
            out.write(2);
            out.write(112);
            out.write(0);
        }
    }

    private void encodeTP_UD_as_LV(TLVBuffer out) throws EncodingException {
        TLVBuffer TP_UDL = out.createChild(1);
        this.encodeUDHL(out);
        this.packet.encode(out);
        TP_UDL.write(out.getPos() - TP_UDL.end());
    }

    public void init() throws EncodingException {
        this.addIfNonNull("device-identities", this.createDeviceIdentities());
        this.addIfNonNull("address", this.createAddress());
        this.addIfNonNull("tpdu", this.createTPDU());
    }

    public TLV createAddress() {
        return new RawTLV(-122, this.phone.toBytes());
    }

    public void addIfNonNull(String name, TLV tlv) {
        if (tlv != null) {
            this.add(name, tlv);
        }
    }

    public SMS_PP_TLV() throws Exception {
        this.setTag((byte)-47, null);
    }

    public SMS_PP_TLV(Encodable packet, boolean doInit) throws EncodingException {
        this.setTag((byte)-47, null);
        this.packet = packet;
        if (doInit) {
            this.init();
        }
    }

    private static synchronized byte createReferenceNumber() {
        return (byte)(++refCount);
    }

    public static List<SMS_PP_TLV> create(Card card, int length, CommandAPDU ... apdus) throws EncodingException, FatalException {
        CompactApduPacket packet = new CompactApduPacket(apdus);
        packet.init(card);
        packet.setCompactMode(true);
        byte[] data = packet.toByteArray();
        if (data.length <= length) {
            SMS_PP_TLV sms = new SMS_PP_TLV(new TreeNode.Data("compact-apdu", data), false);
            sms.phone = card.getPhone();
            sms.serviceCenterPhone = card.getServiceCenterPhone();
            sms.init();
            return Collections.singletonList(sms);
        }
        ArrayList<SMS_PP_TLV> retVal = new ArrayList<SMS_PP_TLV>();
        int count = data.length / length;
        count += data.length % length > 0 ? 1 : 0;
        byte refNumber = SMS_PP_TLV.createReferenceNumber();
        for (int i = 0; i < count; ++i) {
            int offset = i * length;
            int toDo = Math.min(data.length - offset, length);
            TreeNode.Data part = new TreeNode.Data("data-" + i, data, offset, toDo);
            SMS_PP_TLV sms = new SMS_PP_TLV(part, false);
            sms.isConcatinated = true;
            sms.refNumber = refNumber;
            sms.numberOfMessages = (byte)count;
            sms.sequenceNumber = (byte)(i + 1);
            sms.phone = card.getPhone();
            sms.serviceCenterPhone = card.getServiceCenterPhone();
            sms.init();
            retVal.add(sms);
        }
        return retVal;
    }

    public String getShortDescription() {
        return this.isConcatinated ? "(concatenated-short-message referenceNumber=" + this.refNumber + " sequenceNumber=" + this.sequenceNumber + " numberOfMessages=" + this.numberOfMessages + ")" : "(command-packet)";
    }

    public static void main(String[] args) throws EncodingException {
        Date date = new Date();
        TLVBuffer out = new TLVBuffer(7);
        SMS_PP_TLV.encodeTP_SCTS(out, date);
        System.out.println(date);
        System.out.println(out.toString());
        out.setPosTo(0);
        System.out.println(SMS_PP_TLV.decodeTP_SCTS(out));
    }
}

