/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.data.sms;

import com.sun.tck.bvtool.etsi.data.sms.SMSParser;
import com.sun.tck.bvtool.etsi.tlv.Encodable;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.me.utils.Utils;
import java.io.Serializable;

public class Phone
implements Encodable,
Serializable {
    private TON ton;
    private NPI npi;
    private byte[] phone;

    private static Code find(Code[] values, int code, Code def) {
        for (Code current : values) {
            if (current.getCode() != code) continue;
            return current;
        }
        return def;
    }

    public Phone(int TP_ID, byte[] phone) {
        this(TP_ID >> 4 & 7, TP_ID & 0xF, phone);
    }

    public Phone(int ton, int npi, byte[] phone) {
        this.ton = (TON)Phone.find(TON.values(), ton & 7, TON.Unknown);
        this.npi = (NPI)Phone.find(NPI.values(), npi & 0xF, NPI.Unknown);
        this.phone = phone == null ? new byte[]{} : phone;
    }

    public Phone(byte[] phone) {
        this(TON.Unknown, NPI.ISDN_TelephonyNumberingPlan, phone);
    }

    public Phone(TON ton, NPI npi, byte[] phone) {
        this.ton = ton == null ? TON.Unknown : ton;
        this.npi = npi == null ? NPI.Unknown : npi;
        this.phone = phone == null ? new byte[]{} : phone;
    }

    public static Phone parseTP_DA(TLVBuffer in) throws EncodingException {
        int length = in.read();
        return new Phone((byte)in.read(), in.readArray(length / 2));
    }

    public String toString() {
        return "(type=Phone TON=" + this.ton + " NPI=" + this.npi + " phone=" + Utils.canonize(this.phone) + ')';
    }

    public void encodeTP_OA(TLVBuffer out) throws EncodingException {
        out.write(this.phone.length * 2);
        this.encode(out);
    }

    public void encode(TLVBuffer out) {
        out.write(0x80 | this.ton.getCode() << 4 & 0x70 | this.npi.getCode() & 0xF);
        for (int i = 0; i < this.phone.length; ++i) {
            out.write(SMSParser.swapNibble(this.phone[i], 16));
        }
    }

    public byte[] toBytes() {
        TLVBuffer out = new TLVBuffer(this.phone.length + 1);
        this.encode(out);
        byte[] retVal = out.getBuffer();
        return TLVUtils.trim(retVal, out.getPos());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NPI implements Code
    {
        Unknown(0),
        ISDN_TelephonyNumberingPlan(1),
        DataNumberingPlan(3),
        TelexNumberingPlan(4),
        ServiceCentreNumberingPlan(5),
        ServiceCentreNumberingPlan2(6),
        NationalNumberingPlan(8),
        PrivateNumberingPlan(9),
        ERMES_NumberingPlan(10),
        ReservedForExtension(15);

        private int code;

        @Override
        public int getCode() {
            return this.code;
        }

        private NPI(int id) {
            this.code = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TON implements Code
    {
        Unknown(0),
        InternationalNumber(1),
        NationalNumber(2),
        NetworkSpecificNumber(3),
        SubscriberNumber(4),
        AbbreviatedNumber(6),
        Reserved(7);

        private int code;

        @Override
        public int getCode() {
            return this.code;
        }

        private TON(int id) {
            this.code = id;
        }
    }

    public static interface Code
    extends Serializable {
        public int getCode();
    }
}

