/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.data;

import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.tck.bvtool.etsi.data.ResponseHeader;
import com.sun.tck.bvtool.etsi.data.ResponseScriptingTemplate;
import com.sun.tck.bvtool.etsi.data.SecuredPacketTLV;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.etsi.tlv.TreeNode;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponsePacket
extends SecuredPacketTLV {
    ResponseScriptingTemplate response = new ResponseScriptingTemplate();
    private ArrayList<ResponseAPDU> apdus = new ArrayList();
    private int processedCount;

    public ResponsePacket() {
        this.setTagInternal((byte)2, null);
    }

    public ResponsePacket(int count, ResponseAPDU apdu) {
        this.setTagInternal((byte)2, null);
        this.apdus.add(apdu);
        this.header.setTAR(0);
        this.processedCount = count;
    }

    public ResponsePacket(ResponseScriptingTemplate response) {
        this.setTagInternal((byte)2, null);
        this.add(response);
        this.header.setTAR(11665664);
        this.response = response;
        this.apdus = response.getResponses();
        this.processedCount = response.apduCount;
        this.add("processed-count", new TreeNode.Value("processed-count", new Integer(this.processedCount)));
        this.add("response-apdus", new TreeNode.Value("response", this.apdus));
    }

    @Override
    public void decodeSecuredData(TLVPrototypeFactory processor, TLVBuffer securedData) throws Exception {
        if (securedData.available() == 0) {
            return;
        }
        this.header = (ResponseHeader)this.header;
        if (this.header.getTAR() == 0) {
            this.processedCount = securedData.read();
            byte[] data = new byte[securedData.available()];
            data[data.length - 2] = (byte)securedData.read();
            data[data.length - 1] = (byte)securedData.read();
            System.arraycopy(securedData.getBuffer(), securedData.getPos(), data, 0, data.length - 2);
            ResponseAPDU answer = new ResponseAPDU(data);
            this.apdus.add(answer);
        } else {
            this.response = new ResponseScriptingTemplate();
            this.response.decode(processor, securedData);
            this.add("response", this.response);
            this.processedCount = this.response.apduCount;
            this.apdus = this.response.getResponses();
        }
        this.add("processed-count", new TreeNode.Value("processed-count", new Integer(this.processedCount)));
        this.add("response-apdus", new TreeNode.Value("response", this.apdus));
    }

    @Override
    protected void writeSecuredData(TLVBuffer buff) throws EncodingException {
        if (this.header.getTAR() == 0) {
            ResponseAPDU apdu = this.apdus.get(0);
            buff.write(this.processedCount);
            buff.write(apdu.sw(), 2);
            byte[] data = apdu.getBytes();
            buff.write(data, 0, data.length - 2);
        } else {
            super.writeSecuredData(buff);
        }
    }

    public ResponseHeader getHeader() {
        return (ResponseHeader)this.header;
    }

    public List<ResponseAPDU> getApdus() {
        return this.apdus;
    }

    public ResponseScriptingTemplate getResponse() {
        return this.response;
    }

    @Override
    protected SecuredPacketTLV.Header createHeader() {
        this.header = this.header == null ? new ResponseHeader() : this.header;
        return this.header;
    }
}

